/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import ksp.org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/checkers/declaration/IrPrivateDeclarationOverrideChecker;", "Lksp/org/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrPrivateDeclarationOverrideChecker
implements IrDeclarationChecker<IrDeclaration> {
    @NotNull
    public static final IrPrivateDeclarationOverrideChecker INSTANCE = new IrPrivateDeclarationOverrideChecker();

    private IrPrivateDeclarationOverrideChecker() {
    }

    @Override
    public void check(@NotNull IrDeclaration declaration2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (declaration2 instanceof IrOverridableDeclaration) {
            for (IrSymbol overriddenSymbol : ((IrOverridableDeclaration)declaration2).getOverriddenSymbols()) {
                IrDeclarationWithVisibility overriddenDeclaration;
                IrSymbolOwner irSymbolOwner = overriddenSymbol.getOwner();
                IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
                if (irDeclarationWithVisibility == null || !Intrinsics.areEqual((Object)(overriddenDeclaration = irDeclarationWithVisibility).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) continue;
                context2.error(declaration2, "Overrides private declaration " + overriddenDeclaration);
            }
        }
    }
}

