/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.actualizer;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollectorKt;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMap;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import ksp.org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitor;
import ksp.org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import ksp.org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualMatcher;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCheckingCompatibility;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector;", "", "<init>", "()V", "collectAndCheckMapping", "", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "data", "Lksp/org/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "ExpectActualLinkCollectorVisitor", "MatchingContext", "ir.actualization"})
final class ExpectActualLinkCollector {
    public final void collectAndCheckMapping(@NotNull IrModuleFragment declaration2, @NotNull MatchingContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ExpectActualLinkCollectorVisitor.INSTANCE.visitModuleFragment(declaration2, data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016J&\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$ExpectActualLinkCollectorVisitor;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lksp/org/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "<init>", "()V", "visitFile", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "data", "visitFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProperty", "Lksp/org/jetbrains/kotlin/ir/declarations/IrProperty;", "matchExpectTopLevelCallable", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "context", "visitClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "matchAndCheckExpectTopLevelDeclaration", "expectSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbols", "", "visitElement", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "ir.actualization"})
    private static final class ExpectActualLinkCollectorVisitor
    extends IrVisitor<Unit, MatchingContext> {
        @NotNull
        public static final ExpectActualLinkCollectorVisitor INSTANCE = new ExpectActualLinkCollectorVisitor();

        private ExpectActualLinkCollectorVisitor() {
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super.visitFile(declaration2, data.withNewCurrentFile(declaration2));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration2.isExpect()) {
                this.matchExpectTopLevelCallable(declaration2, AdditionalIrUtilsKt.getCallableId(declaration2), data);
            }
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration2.isExpect()) {
                this.matchExpectTopLevelCallable(declaration2, AdditionalIrUtilsKt.getCallableId(declaration2), data);
            }
        }

        private final void matchExpectTopLevelCallable(IrDeclarationWithName declaration2, CallableId callableId, MatchingContext context2) {
            IrSymbol irSymbol = declaration2.getSymbol();
            List list = context2.getClassActualizationInfo$ir_actualization().getActualTopLevels().get(callableId);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.matchAndCheckExpectTopLevelDeclaration(irSymbol, list, context2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!declaration2.isExpect()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail(declaration2);
            IrClassSymbol expectClassSymbol = declaration2.getSymbol();
            IrSymbol actualClassLikeSymbol = data.getClassActualizationInfo$ir_actualization().getActualWithoutExpansion(classId);
            this.matchAndCheckExpectTopLevelDeclaration(expectClassSymbol, CollectionsKt.listOfNotNull((Object)actualClassLikeSymbol), data);
        }

        private final void matchAndCheckExpectTopLevelDeclaration(IrSymbol expectSymbol, List<? extends IrSymbol> actualSymbols, MatchingContext context2) {
            DeclarationSymbolMarker matched = AbstractExpectActualMatcher.INSTANCE.matchSingleExpectTopLevelDeclarationAgainstPotentialActuals(expectSymbol, actualSymbols, context2);
            if (matched != null) {
                AbstractExpectActualChecker.INSTANCE.checkSingleExpectTopLevelDeclarationAgainstMatchedActual(expectSymbol, matched, context2, context2.getLanguageVersionSettings$ir_actualization());
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element2.acceptChildren(this, data);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000bJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016JB\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020&2\u001c\u0010'\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0*0(2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010,H\u0016J>\u0010.\u001a\u00020!2\u0006\u0010\"\u001a\u00020&2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0*0(2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010,H\u0016J\u0014\u00100\u001a\u00020!*\u00020\u00072\u0006\u0010$\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00061"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "Lksp/org/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMatchingContext;", "typeSystemContext", "Lksp/org/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "diagnosticsReporter", "Lksp/org/jetbrains/kotlin/ir/IrDiagnosticReporter;", "expectActualTracker", "Lksp/org/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "classActualizationInfo", "Lksp/org/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "currentExpectFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "expectActualMap", "Lksp/org/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;)V", "getClassActualizationInfo$ir_actualization", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "getExpectActualMap", "()Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "currentExpectIoFile", "Ljava/io/File;", "getCurrentExpectIoFile", "()Ljava/io/File;", "currentExpectIoFile$delegate", "Lkotlin/Lazy;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings$ir_actualization", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "withNewCurrentFile", "newCurrentFile", "onMatchedDeclarations", "", "expectSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbol", "onIncompatibleMembersFromClassScope", "Lksp/org/jetbrains/kotlin/mpp/DeclarationSymbolMarker;", "actualSymbolsByIncompatibility", "", "Lksp/org/jetbrains/kotlin/resolve/multiplatform/ExpectActualCheckingCompatibility$Incompatible;", "", "containingExpectClassSymbol", "Lksp/org/jetbrains/kotlin/mpp/RegularClassSymbolMarker;", "containingActualClassSymbol", "onMismatchedMembersFromClassScope", "Lksp/org/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility$Mismatch;", "reportWithCurrentFile", "ir.actualization"})
    public static final class MatchingContext
    extends IrExpectActualMatchingContext {
        @NotNull
        private final IrDiagnosticReporter diagnosticsReporter;
        @Nullable
        private final ExpectActualTracker expectActualTracker;
        @NotNull
        private final ClassActualizationInfo classActualizationInfo;
        @Nullable
        private final IrFile currentExpectFile;
        @NotNull
        private final IrExpectActualMap expectActualMap;
        @NotNull
        private final Lazy currentExpectIoFile$delegate;

        public MatchingContext(@NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrDiagnosticReporter diagnosticsReporter, @Nullable ExpectActualTracker expectActualTracker, @NotNull ClassActualizationInfo classActualizationInfo, @Nullable IrFile currentExpectFile, @NotNull IrExpectActualMap expectActualMap) {
            Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
            Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            Intrinsics.checkNotNullParameter((Object)expectActualMap, (String)"expectActualMap");
            super(typeSystemContext2, classActualizationInfo.getActualClasses());
            this.diagnosticsReporter = diagnosticsReporter;
            this.expectActualTracker = expectActualTracker;
            this.classActualizationInfo = classActualizationInfo;
            this.currentExpectFile = currentExpectFile;
            this.expectActualMap = expectActualMap;
            this.currentExpectIoFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> MatchingContext.currentExpectIoFile_delegate$lambda$0(this));
        }

        public /* synthetic */ MatchingContext(IrTypeSystemContext irTypeSystemContext, IrDiagnosticReporter irDiagnosticReporter, ExpectActualTracker expectActualTracker, ClassActualizationInfo classActualizationInfo, IrFile irFile, IrExpectActualMap irExpectActualMap, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x20) != 0) {
                irExpectActualMap = new IrExpectActualMap();
            }
            this(irTypeSystemContext, irDiagnosticReporter, expectActualTracker, classActualizationInfo, irFile, irExpectActualMap);
        }

        @NotNull
        public final ClassActualizationInfo getClassActualizationInfo$ir_actualization() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final IrExpectActualMap getExpectActualMap() {
            return this.expectActualMap;
        }

        private final File getCurrentExpectIoFile() {
            Lazy lazy = this.currentExpectIoFile$delegate;
            return (File)lazy.getValue();
        }

        @NotNull
        public final LanguageVersionSettings getLanguageVersionSettings$ir_actualization() {
            return this.diagnosticsReporter.getLanguageVersionSettings();
        }

        @NotNull
        public final MatchingContext withNewCurrentFile(@NotNull IrFile newCurrentFile) {
            Intrinsics.checkNotNullParameter((Object)newCurrentFile, (String)"newCurrentFile");
            return new MatchingContext(this.getTypeContext(), this.diagnosticsReporter, this.expectActualTracker, this.classActualizationInfo, newCurrentFile, this.expectActualMap);
        }

        @Override
        public void onMatchedDeclarations(@NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter((Object)actualSymbol, (String)"actualSymbol");
            ExpectActualTracker expectActualTracker = this.expectActualTracker;
            if (expectActualTracker != null) {
                this.reportWithCurrentFile(expectActualTracker, actualSymbol);
            }
            IrActualizerUtilsKt.recordActualForExpectDeclaration(expectSymbol, actualSymbol, this.expectActualMap, this.diagnosticsReporter);
        }

        @Override
        public void onIncompatibleMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull Map<ExpectActualCheckingCompatibility.Incompatible<?>, ? extends List<? extends DeclarationSymbolMarker>> actualSymbolsByIncompatibility, @Nullable RegularClassSymbolMarker containingExpectClassSymbol, @Nullable RegularClassSymbolMarker containingActualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbolsByIncompatibility, (String)"actualSymbolsByIncompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            for (Map.Entry<ExpectActualCheckingCompatibility.Incompatible<?>, List<DeclarationSymbolMarker>> entry : actualSymbolsByIncompatibility.entrySet()) {
                ExpectActualCheckingCompatibility.Incompatible<?> incompatibility = entry.getKey();
                List<DeclarationSymbolMarker> actualMemberSymbols = entry.getValue();
                for (DeclarationSymbolMarker declarationSymbolMarker : actualMemberSymbols) {
                    if (!(declarationSymbolMarker instanceof IrSymbol)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    IrActualizerUtilsKt.reportExpectActualIncompatibility(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)declarationSymbolMarker, incompatibility);
                }
            }
        }

        @Override
        public void onMismatchedMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull Map<ExpectActualMatchingCompatibility.Mismatch, ? extends List<? extends DeclarationSymbolMarker>> actualSymbolsByIncompatibility, @Nullable RegularClassSymbolMarker containingExpectClassSymbol, @Nullable RegularClassSymbolMarker containingActualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbolsByIncompatibility, (String)"actualSymbolsByIncompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (actualSymbolsByIncompatibility.isEmpty() && !IrActualizerUtilsKt.containsOptionalExpectation(((IrSymbol)expectSymbol).getOwner())) {
                IrActualizerUtilsKt.reportMissingActual(this.diagnosticsReporter, (IrSymbol)expectSymbol);
            }
            for (Map.Entry<ExpectActualMatchingCompatibility.Mismatch, ? extends List<? extends DeclarationSymbolMarker>> entry : actualSymbolsByIncompatibility.entrySet()) {
                ExpectActualMatchingCompatibility.Mismatch incompatibility = entry.getKey();
                List<? extends DeclarationSymbolMarker> actualMemberSymbols = entry.getValue();
                for (DeclarationSymbolMarker declarationSymbolMarker : actualMemberSymbols) {
                    if (!(declarationSymbolMarker instanceof IrSymbol)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    IrActualizerUtilsKt.reportExpectActualMismatch(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)declarationSymbolMarker, incompatibility);
                }
            }
        }

        private final void reportWithCurrentFile(ExpectActualTracker $this$reportWithCurrentFile, IrSymbol actualSymbol) {
            if (this.currentExpectFile != null) {
                File actualIoFile;
                IrFile irFile = this.classActualizationInfo.getActualSymbolsToFile().get(actualSymbol);
                File file2 = actualIoFile = irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
                if (actualIoFile != null) {
                    File file3 = this.getCurrentExpectIoFile();
                    Intrinsics.checkNotNull((Object)file3);
                    $this$reportWithCurrentFile.report(file3, actualIoFile);
                }
            }
        }

        private static final File currentExpectIoFile_delegate$lambda$0(MatchingContext this$0) {
            IrFile irFile = this$0.currentExpectFile;
            return irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
        }
    }
}

