/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.ClassFileViewProvider;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import ksp.org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001f\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u001c\u001a\u00020\u000e*\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R2\u0010\u0018\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u000e0\u000e \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder;", "", "<init>", "()V", "findMultifileClassParts", "", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "file", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "partNames", "", "isKotlinInternalCompiledFile", "", "fileContent", "", "multifileClassPartKindStrategy", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder$MultifileClassPartKindStrategy;", "allowMultifileClassPart", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "treatMultifileClassPartAsInternal", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "isMultifileClassPartFile", "isValidAndExists", "MultifileClassPartKindStrategy", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nClsClassFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClsClassFinder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1617#2,9:145\n1869#2:154\n1870#2:156\n1626#2:157\n1#3:155\n*S KotlinDebug\n*F\n+ 1 ClsClassFinder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder\n*L\n26#1:145,9\n26#1:154\n26#1:156\n26#1:157\n26#1:155\n*E\n"})
public final class ClsClassFinder {
    @NotNull
    public static final ClsClassFinder INSTANCE = new ClsClassFinder();
    private static final ThreadLocal<Boolean> treatMultifileClassPartAsInternal = ThreadLocal.withInitial(ClsClassFinder::treatMultifileClassPartAsInternal$lambda$1);

    private ClsClassFinder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file2, @NotNull ClassId classId, @NotNull List<String> partNames) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(partNames, (String)"partNames");
        FqName packageFqName = classId.getPackageFqName();
        VirtualFile virtualFile = file2.getParent();
        Intrinsics.checkNotNull((Object)virtualFile);
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        Iterable $this$mapNotNull$iv = partNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            KotlinClassFinder kotlinClassFinder = partsFinder;
            Name name2 = Name.identifier(StringsKt.substringAfterLast$default((String)it, (char)'/', null, (int)2, null));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            if (KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, new ClassId(packageFqName, name2), MetadataVersion.INSTANCE) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent, @NotNull MultifileClassPartKindStrategy multifileClassPartKindStrategy) {
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)multifileClassPartKindStrategy), (String)"multifileClassPartKindStrategy");
        if (!this.isValidAndExists(file2, fileContent)) {
            return false;
        }
        ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
        if (!clsKotlinBinaryClassCache.isKotlinJvmCompiledFile(file2, fileContent)) {
            return false;
        }
        try {
            bl3 = fileContent == null ? ClassFileViewProvider.isInnerClass(file2) : ClassFileViewProvider.isInnerClass(file2, fileContent);
        }
        catch (Exception exception) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(exception);
            Logger.getInstance("ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder.isKotlinInternalCompiledFile").debug(file2.getPath(), exception);
            return false;
        }
        boolean innerClass = bl3;
        if (innerClass) {
            return true;
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = clsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(file2, fileContent);
        if (kotlinBinaryClassHeaderData == null) {
            return false;
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData header = kotlinBinaryClassHeaderData;
        if (header.getClassId().isLocal()) {
            return true;
        }
        block1 : switch (WhenMappings.$EnumSwitchMapping$1[header.getKind().ordinal()]) {
            case 1: 
            case 2: {
                bl2 = true;
                break;
            }
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$0[multifileClassPartKindStrategy.ordinal()]) {
                    case 1: {
                        bl2 = true;
                        break block1;
                    }
                    case 2: {
                        bl2 = false;
                        break block1;
                    }
                    case 3: {
                        Boolean bl4 = treatMultifileClassPartAsInternal.get();
                        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"get(...)");
                        bl2 = bl4;
                        break block1;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: 
            case 5: 
            case 6: {
                bl2 = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl2;
    }

    public static /* synthetic */ boolean isKotlinInternalCompiledFile$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile, byte[] byArray, MultifileClassPartKindStrategy multifileClassPartKindStrategy, int n2, Object object) {
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        if ((n2 & 4) != 0) {
            multifileClassPartKindStrategy = MultifileClassPartKindStrategy.FROM_STACK;
        }
        return clsClassFinder.isKotlinInternalCompiledFile(virtualFile, byArray, multifileClassPartKindStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T allowMultifileClassPart(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Boolean old = treatMultifileClassPartAsInternal.get();
        try {
            treatMultifileClassPartAsInternal.set(false);
            object = action.invoke();
        }
        finally {
            treatMultifileClassPartAsInternal.set(old);
        }
        return (T)object;
    }

    public final boolean isMultifileClassPartFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData headerData;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.isValidAndExists(file2, fileContent)) {
            return false;
        }
        ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = headerData = clsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(file2, fileContent);
        return (kotlinBinaryClassHeaderData != null ? kotlinBinaryClassHeaderData.getKind() : null) == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    public static /* synthetic */ boolean isMultifileClassPartFile$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile, byte[] byArray, int n2, Object object) {
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        return clsClassFinder.isMultifileClassPartFile(virtualFile, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidAndExists(VirtualFile $this$isValidAndExists, byte[] fileContent) {
        boolean bl2;
        if (!$this$isValidAndExists.isValid()) return false;
        if (fileContent != null) {
            if (fileContent.length == 0) {
                return false;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return false;
        if (!$this$isValidAndExists.exists()) return false;
        return true;
    }

    static /* synthetic */ boolean isValidAndExists$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile, byte[] byArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byArray = null;
        }
        return clsClassFinder.isValidAndExists(virtualFile, byArray);
    }

    private static final Boolean treatMultifileClassPartAsInternal$lambda$1() {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder$MultifileClassPartKindStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "INTERNAL", "NON_INTERNAL", "FROM_STACK", "decompiler-to-file-stubs"})
    public static final class MultifileClassPartKindStrategy
    extends Enum<MultifileClassPartKindStrategy> {
        public static final /* enum */ MultifileClassPartKindStrategy INTERNAL = new MultifileClassPartKindStrategy();
        public static final /* enum */ MultifileClassPartKindStrategy NON_INTERNAL = new MultifileClassPartKindStrategy();
        public static final /* enum */ MultifileClassPartKindStrategy FROM_STACK = new MultifileClassPartKindStrategy();
        private static final /* synthetic */ MultifileClassPartKindStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MultifileClassPartKindStrategy[] values() {
            return (MultifileClassPartKindStrategy[])$VALUES.clone();
        }

        public static MultifileClassPartKindStrategy valueOf(String value2) {
            return Enum.valueOf(MultifileClassPartKindStrategy.class, value2);
        }

        @NotNull
        public static EnumEntries<MultifileClassPartKindStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = multifileClassPartKindStrategyArray = new MultifileClassPartKindStrategy[]{MultifileClassPartKindStrategy.INTERNAL, MultifileClassPartKindStrategy.NON_INTERNAL, MultifileClassPartKindStrategy.FROM_STACK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MultifileClassPartKindStrategy.values().length];
            try {
                nArray[MultifileClassPartKindStrategy.INTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultifileClassPartKindStrategy.NON_INTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultifileClassPartKindStrategy.FROM_STACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.SYNTHETIC_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

