/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

public final class Bits {
    public static boolean getBoolean(byte[] b2, int off) {
        return b2[off] != 0;
    }

    public static char getChar(byte[] b2, int off) {
        return (char)(((b2[off + 1] & 0xFF) << 0) + ((b2[off + 0] & 0xFF) << 8));
    }

    public static short getShort(byte[] b2, int off) {
        return (short)(((b2[off + 1] & 0xFF) << 0) + ((b2[off + 0] & 0xFF) << 8));
    }

    public static int getInt(byte[] b2, int off) {
        return ((b2[off + 3] & 0xFF) << 0) + ((b2[off + 2] & 0xFF) << 8) + ((b2[off + 1] & 0xFF) << 16) + ((b2[off + 0] & 0xFF) << 24);
    }

    public static float getFloat(byte[] b2, int off) {
        int i2 = ((b2[off + 3] & 0xFF) << 0) + ((b2[off + 2] & 0xFF) << 8) + ((b2[off + 1] & 0xFF) << 16) + ((b2[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i2);
    }

    public static long getLong(byte[] b2, int off) {
        return (((long)b2[off + 7] & 0xFFL) << 0) + (((long)b2[off + 6] & 0xFFL) << 8) + (((long)b2[off + 5] & 0xFFL) << 16) + (((long)b2[off + 4] & 0xFFL) << 24) + (((long)b2[off + 3] & 0xFFL) << 32) + (((long)b2[off + 2] & 0xFFL) << 40) + (((long)b2[off + 1] & 0xFFL) << 48) + (((long)b2[off + 0] & 0xFFL) << 56);
    }

    public static double getDouble(byte[] b2, int off) {
        long j2 = (((long)b2[off + 7] & 0xFFL) << 0) + (((long)b2[off + 6] & 0xFFL) << 8) + (((long)b2[off + 5] & 0xFFL) << 16) + (((long)b2[off + 4] & 0xFFL) << 24) + (((long)b2[off + 3] & 0xFFL) << 32) + (((long)b2[off + 2] & 0xFFL) << 40) + (((long)b2[off + 1] & 0xFFL) << 48) + (((long)b2[off + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(j2);
    }

    public static void putBoolean(byte[] b2, int off, boolean val) {
        b2[off] = (byte)(val ? 1 : 0);
    }

    public static void putChar(byte[] b2, int off, char val) {
        b2[off + 1] = (byte)(val >>> 0);
        b2[off + 0] = (byte)(val >>> 8);
    }

    public static void putShort(byte[] b2, int off, short val) {
        b2[off + 1] = (byte)(val >>> 0);
        b2[off + 0] = (byte)(val >>> 8);
    }

    public static void putInt(byte[] b2, int off, int val) {
        b2[off + 3] = (byte)(val >>> 0);
        b2[off + 2] = (byte)(val >>> 8);
        b2[off + 1] = (byte)(val >>> 16);
        b2[off + 0] = (byte)(val >>> 24);
    }

    public static void putFloat(byte[] b2, int off, float val) {
        int i2 = Float.floatToIntBits(val);
        b2[off + 3] = (byte)(i2 >>> 0);
        b2[off + 2] = (byte)(i2 >>> 8);
        b2[off + 1] = (byte)(i2 >>> 16);
        b2[off + 0] = (byte)(i2 >>> 24);
    }

    public static void putLong(byte[] b2, int off, long val) {
        b2[off + 7] = (byte)(val >>> 0);
        b2[off + 6] = (byte)(val >>> 8);
        b2[off + 5] = (byte)(val >>> 16);
        b2[off + 4] = (byte)(val >>> 24);
        b2[off + 3] = (byte)(val >>> 32);
        b2[off + 2] = (byte)(val >>> 40);
        b2[off + 1] = (byte)(val >>> 48);
        b2[off + 0] = (byte)(val >>> 56);
    }

    public static void putDouble(byte[] b2, int off, double val) {
        long j2 = Double.doubleToLongBits(val);
        b2[off + 7] = (byte)(j2 >>> 0);
        b2[off + 6] = (byte)(j2 >>> 8);
        b2[off + 5] = (byte)(j2 >>> 16);
        b2[off + 4] = (byte)(j2 >>> 24);
        b2[off + 3] = (byte)(j2 >>> 32);
        b2[off + 2] = (byte)(j2 >>> 40);
        b2[off + 1] = (byte)(j2 >>> 48);
        b2[off + 0] = (byte)(j2 >>> 56);
    }
}

