/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Getter;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.UserDataHolder;
import ksp.com.intellij.openapi.util.UserDataHolderEx;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.util.CachedValue;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.ParameterizedCachedValue;
import ksp.com.intellij.psi.util.ParameterizedCachedValueProvider;
import ksp.com.intellij.serviceContainer.NonInjectable;
import ksp.com.intellij.util.CachedValueBase;
import ksp.com.intellij.util.CachedValueLeakChecker;
import ksp.com.intellij.util.CachedValueStabilityChecker;
import ksp.com.intellij.util.CachedValuesFactory;
import ksp.com.intellij.util.DefaultCachedValuesFactory;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class CachedValuesManagerImpl
extends CachedValuesManager {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
    private Set<Key<?>> myKeys = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project) {
        this(project, project.getService(CachedValuesFactory.class));
    }

    @NonInjectable
    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory2) {
        this.myProject = project;
        this.myFactory = factory2 == null ? new DefaultCachedValuesFactory(project) : factory2;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider2, boolean trackValue) {
        if (provider2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue2 = this.myFactory.createCachedValue(provider2, trackValue);
        if (cachedValue2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue2;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull UserDataHolder userDataHolder, @NotNull CachedValueProvider<T> provider2, boolean trackValue) {
        if (userDataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        CachedValue<T> cachedValue2 = this.myFactory.createCachedValue(userDataHolder, provider2, trackValue);
        if (cachedValue2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        return cachedValue2;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider2, boolean trackValue) {
        if (provider2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider2, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        return parameterizedCachedValue;
    }

    @Override
    @NotNull
    protected <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull UserDataHolder userDataHolder, @NotNull ParameterizedCachedValueProvider<T, P> provider2, boolean trackValue) {
        if (userDataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(7);
        }
        if (provider2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(8);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(userDataHolder, provider2, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(9);
        }
        return parameterizedCachedValue;
    }

    @Override
    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider2, boolean trackValue) {
        CachedValue<T> value2;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(10);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(11);
        }
        if (provider2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(12);
        }
        if ((value2 = dataHolder.getUserData(key)) instanceof CachedValueBase && ((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject)) {
            Getter<T> data = value2.getUpToDateOrNull();
            if (data != null) {
                return data.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider2, value2.getValueProvider(), key);
        }
        if (value2 == null) {
            value2 = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider2, trackValue));
        }
        return value2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value2) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(13);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(14);
        }
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return ((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value2);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue<T> existing = dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value2);
            return value2;
        }
    }

    @Override
    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(15);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(16);
        }
        if (!CachedValuesManagerImpl.isClearedOnPluginUnload(dataHolder)) {
            this.myCacheHolders.put(dataHolder, NULL);
            this.myKeys.add(key);
        }
    }

    private static boolean isClearedOnPluginUnload(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(17);
        }
        return dataHolder instanceof PsiElement || dataHolder instanceof ASTNode || dataHolder instanceof FileViewProvider;
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider2, boolean trackValue) {
        CachedValueLeakChecker.checkProviderDoesNotLeakPSI(provider2, key, dh);
        CachedValue<T> value2 = this.myFactory.createCachedValue(dh, provider2, trackValue);
        assert (((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject));
        return value2;
    }

    @ApiStatus.Internal
    public void clearCachedValues() {
        for (UserDataHolder holder : this.myCacheHolders.keySet()) {
            for (Key<?> key : this.myKeys) {
                holder.putUserData(key, null);
            }
        }
        CachedValueStabilityChecker.cleanupFieldCache();
        this.myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
        this.myKeys = ContainerUtil.newConcurrentSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveInUserData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trackKeyHolder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isClearedOnPluginUnload";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

