/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree;

import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.com.intellij.psi.codeStyle.CodeStyleManager;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.PsiManagerEx;
import ksp.com.intellij.psi.impl.source.DummyHolder;
import ksp.com.intellij.psi.impl.source.SourceJavaCodeReference;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.LightTreeUtil;
import ksp.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.CharTable;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public final class JavaSourceUtil {
    private static final Logger LOG = Logger.getInstance(JavaSourceUtil.class);
    private static final TokenSet REF_FILTER = TokenSet.orSet(ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, TokenSet.create(JavaElementType.ANNOTATION));

    private JavaSourceUtil() {
    }

    public static void fullyQualifyReference(@NotNull CompositeElement reference2, @NotNull PsiClass targetClass) {
        if (reference2 == null) {
            JavaSourceUtil.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            JavaSourceUtil.$$$reportNull$$$0(1);
        }
        if (((SourceJavaCodeReference)((Object)reference2)).isQualified()) {
            PsiClass parentClass = targetClass.getContainingClass();
            if (parentClass == null) {
                return;
            }
            ASTNode qualifier2 = reference2.findChildByRole(54);
            if (qualifier2 instanceof SourceJavaCodeReference) {
                ((SourceJavaCodeReference)((Object)qualifier2)).fullyQualify(parentClass);
            }
        } else {
            String qName = targetClass.getQualifiedName();
            if (qName == null) {
                return;
            }
            int i2 = qName.lastIndexOf(46);
            if (i2 > 0) {
                String prefix = qName.substring(0, i2);
                PsiManagerEx manager = reference2.getManager();
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
                TreeElement qualifier3 = reference2 instanceof PsiReferenceExpression ? (TreeElement)parserFacade.createExpressionFromText(prefix, null).getNode() : (TreeElement)parserFacade.createReferenceFromText(prefix, null).getNode();
                if (qualifier3 != null) {
                    CharTable systemCharTab = SharedImplUtil.findCharTableByTree(qualifier3);
                    LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, systemCharTab, manager);
                    qualifier3.rawInsertAfterMe(dot);
                    reference2.addInternal(qualifier3, dot, null, Boolean.FALSE);
                }
            }
        }
    }

    @NotNull
    public static String getReferenceText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            JavaSourceUtil.$$$reportNull$$$0(2);
        }
        final StringBuilder buffer = new StringBuilder();
        ((TreeElement)ref.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                if (!REF_FILTER.contains(leaf.getElementType())) {
                    char lastInBuffer;
                    String leafText = leaf.getText();
                    if (buffer.length() > 0 && !leafText.isEmpty() && Character.isJavaIdentifierPart(leafText.charAt(0)) && ((lastInBuffer = buffer.charAt(buffer.length() - 1)) == '?' || Character.isJavaIdentifierPart(lastInBuffer))) {
                        buffer.append(" ");
                    }
                    buffer.append(leafText);
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (!REF_FILTER.contains(composite.getElementType())) {
                    super.visitComposite(composite);
                }
            }
        });
        String string2 = buffer.toString();
        if (string2 == null) {
            JavaSourceUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static String getReferenceText(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaSourceUtil.$$$reportNull$$$0(4);
        }
        if (node == null) {
            JavaSourceUtil.$$$reportNull$$$0(5);
        }
        String string2 = LightTreeUtil.toFilteredString(tree, node, REF_FILTER);
        if (string2 == null) {
            JavaSourceUtil.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public static TreeElement addParenthToReplacedChild(@NotNull ASTNode child, @NotNull TreeElement newChild, @NotNull PsiManager manager) {
        boolean needParenth;
        if (child == null) {
            JavaSourceUtil.$$$reportNull$$$0(7);
        }
        if (newChild == null) {
            JavaSourceUtil.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            JavaSourceUtil.$$$reportNull$$$0(9);
        }
        boolean bl2 = needParenth = ElementType.EXPRESSION_BIT_SET.contains(child.getElementType()) && ElementType.EXPRESSION_BIT_SET.contains(newChild.getElementType()) && ReplaceExpressionUtil.isNeedParenthesis(child, newChild);
        if (!needParenth) {
            TreeElement treeElement = newChild;
            if (treeElement == null) {
                JavaSourceUtil.$$$reportNull$$$0(10);
            }
            return treeElement;
        }
        CompositeElement parenthExpr = ASTFactory.composite(JavaElementType.PARENTH_EXPRESSION);
        TreeElement dummyExpr = (TreeElement)newChild.clone();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(newChild);
        new DummyHolder(manager, parenthExpr, null, charTableByTree);
        parenthExpr.putUserData(CharTable.CHAR_TABLE_KEY, charTableByTree);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.LPARENTH, "("));
        parenthExpr.rawAddChildren(dummyExpr);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.RPARENTH, ")"));
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(manager.getProject());
            PsiElement formatted = codeStyleManager.reformat((PsiElement)SourceTreeToPsiMap.treeToPsiNotNull(parenthExpr));
            parenthExpr = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(formatted);
        }
        catch (IncorrectOperationException e2) {
            LOG.error(e2);
        }
        newChild.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(newChild));
        dummyExpr.getTreeParent().replaceChild(dummyExpr, newChild);
        TreeUtil.clearCaches(TreeUtil.getFileElement(parenthExpr));
        CompositeElement compositeElement = parenthExpr;
        if (compositeElement == null) {
            JavaSourceUtil.$$$reportNull$$$0(11);
        }
        return compositeElement;
    }

    public static void deleteSeparatingComma(@NotNull CompositeElement element2, @NotNull ASTNode child) {
        if (element2 == null) {
            JavaSourceUtil.$$$reportNull$$$0(12);
        }
        if (child == null) {
            JavaSourceUtil.$$$reportNull$$$0(13);
        }
        assert (child.getElementType() != JavaTokenType.COMMA) : child;
        ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
        if (next != null && next.getElementType() == JavaTokenType.COMMA) {
            element2.deleteChildInternal(next);
        } else {
            ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
            if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
                element2.deleteChildInternal(prev);
            }
        }
    }

    public static void addSeparatingComma(@NotNull CompositeElement element2, @NotNull ASTNode child, @NotNull TokenSet listTypes) {
        if (element2 == null) {
            JavaSourceUtil.$$$reportNull$$$0(14);
        }
        if (child == null) {
            JavaSourceUtil.$$$reportNull$$$0(15);
        }
        if (listTypes == null) {
            JavaSourceUtil.$$$reportNull$$$0(16);
        }
        assert (child.getElementType() != JavaTokenType.COMMA) : child;
        JavaSourceUtil.scanChildren(element2, child, listTypes, true);
        JavaSourceUtil.scanChildren(element2, child, listTypes, false);
    }

    private static void scanChildren(CompositeElement element2, ASTNode node, TokenSet listTypes, boolean forward) {
        block1: {
            ASTNode child = node;
            do {
                ASTNode aSTNode = child = forward ? child.getTreeNext() : child.getTreePrev();
                if (child == null || child.getElementType() == JavaTokenType.COMMA) break block1;
            } while (!listTypes.contains(child.getElementType()));
            CharTable charTable = SharedImplUtil.findCharTableByTree(element2);
            PsiManager manager = element2.getPsi().getManager();
            LeafElement comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, charTable, manager);
            element2.addInternal(comma, comma, forward ? node : child, Boolean.FALSE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/JavaSourceUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/JavaSourceUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addParenthToReplacedChild";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fullyQualifyReference";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceText";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParenthToReplacedChild";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteSeparatingComma";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSeparatingComma";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

