/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util.io;

import java.util.Comparator;
import ksp.com.intellij.openapi.util.SystemInfoRt;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.util.PathUtilRt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (Strings.areSameInstance(path1, path2)) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };

    private OSAgnosticPathUtil() {
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(0);
        }
        return path.startsWith("/") || OSAgnosticPathUtil.isAbsoluteDosPath(path) || OSAgnosticPathUtil.isUncPath(path);
    }

    public static boolean isAbsoluteDosPath(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(1);
        }
        return path.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path) && PathUtilRt.isSeparator(path.charAt(2));
    }

    public static boolean startsWithWindowsDrive(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(2);
        }
        return path.length() >= 2 && path.charAt(1) == ':' && OSAgnosticPathUtil.isDriveLetter(path.charAt(0));
    }

    public static boolean isUncPath(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(3);
        }
        if (!PathUtilRt.startsWithSeparatorSeparator(path)) {
            return false;
        }
        int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path, 2);
        return PathUtilRt.isWindowsUNCRoot(path, slashIndex == -1 ? path.length() : slashIndex);
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        char next;
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(5);
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return true;
        }
        if (prefixLength > pathLength) {
            return false;
        }
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < pathLength && pos < prefixLength; ++pos) {
            char ch2;
            char ch1 = path.charAt(pos);
            if (ch1 == (ch2 = prefix.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return false;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return false;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return false;
            }
            if (StringUtil.compare(ch1, ch2, ignoreCase) == 0) continue;
            return false;
        }
        if (pathLength == prefixLength) {
            return true;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == '\\') {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        return (next = path.charAt(slashOrSeparatorIdx)) == '/' || next == '\\';
    }

    @Nullable
    public static String getParent(@NotNull String path) {
        int length;
        int lastSeparator;
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(6);
        }
        if ((lastSeparator = PathUtilRt.lastSeparatorIndex(path, (length = path.length()) - 1)) < 0) {
            return null;
        }
        if (lastSeparator == length - 1) {
            lastSeparator = PathUtilRt.lastSeparatorIndex(path, length - 2);
        }
        if (lastSeparator < 0) {
            return null;
        }
        if (PathUtilRt.startsWithSeparatorSeparator(path)) {
            int prevSeparator;
            int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path, 2);
            if (lastSeparator > 1 && slashIndex != -1 && slashIndex <= lastSeparator && PathUtilRt.isWindowsUNCRoot(path, slashIndex) && (prevSeparator = PathUtilRt.lastSeparatorIndex(path, lastSeparator - 1)) > 1) {
                return path.substring(0, lastSeparator);
            }
            return null;
        }
        if (lastSeparator == 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path)) {
            return path.substring(0, 3);
        }
        return path.substring(0, lastSeparator == 0 ? 1 : lastSeparator);
    }

    private static int nextSeparatorIndex(String s2, int start) {
        for (int i2 = start; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (!PathUtilRt.isSeparator(c2)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isDriveLetter(char c2) {
        return 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/openapi/util/io/OSAgnosticPathUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsolute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsoluteDosPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithWindowsDrive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWith";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

