/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import ksp.com.intellij.core.CoreBundle;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import ksp.com.intellij.ide.plugins.PluginManagerCoreKt;
import ksp.com.intellij.ide.plugins.PluginSet;
import ksp.com.intellij.ide.plugins.cl.PluginClassLoader;
import ksp.com.intellij.openapi.application.PathManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.util.io.FileUtilRt;
import ksp.com.intellij.openapi.util.text.HtmlChunk;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u000b\u0010\u000b\u001a\u00070\u0006\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0007\u001aI\u0010\u0013\u001a\r\u0012\u0004\u0012\u00020\u00060\u0014\u00a2\u0006\u0002\b\u00152\u0017\u0010\u0016\u001a\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u00192\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001d\u001a0\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00140\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\"H\u0002\u001a\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0010H\u0002\u001a\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006+"}, d2={"FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT", "", "QODANA_PLUGINS_THIRD_PARTY_ACCEPT", "getQODANA_PLUGINS_THIRD_PARTY_ACCEPT$annotations", "()V", "THIRD_PARTY_PLUGINS_FILE", "", "thirdPartyPluginsNoteAccepted", "Ljava/lang/Boolean;", "findClassInPluginThatUsesCoreClassloader", "Lksp/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "className", "Lksp/org/jetbrains/annotations/NonNls;", "pluginSet", "Lksp/com/intellij/ide/plugins/PluginSet;", "getPluginDistDirByClass", "Ljava/nio/file/Path;", "aClass", "Ljava/lang/Class;", "message", "Ljava/util/function/Supplier;", "Lksp/org/jetbrains/annotations/Nls;", "key", "Lksp/org/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.CoreBundle", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/function/Supplier;", "prepareActions", "", "Lksp/com/intellij/openapi/util/text/HtmlChunk;", "pluginNamesToDisable", "", "pluginNamesToEnable", "readPluginIdsFromFile", "", "Lksp/com/intellij/openapi/extensions/PluginId;", "path", "tryReadPluginIdsFromFile", "log", "Lksp/com/intellij/openapi/diagnostic/Logger;", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nPluginManagerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCoreKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1079:1\n1#2:1080\n*E\n"})
public final class PluginManagerCoreKt {
    private static final boolean QODANA_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("idea.qodana.thirdpartyplugins.accept");
    private static final boolean FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("fleet.backend.third-party.plugins.accept");
    @NotNull
    private static final String THIRD_PARTY_PLUGINS_FILE = "alien_plugins.txt";
    @Nullable
    private static volatile Boolean thirdPartyPluginsNoteAccepted;

    private static /* synthetic */ void getQODANA_PLUGINS_THIRD_PARTY_ACCEPT$annotations() {
    }

    private static final Supplier<String> message(String key, Object ... params) {
        return () -> PluginManagerCoreKt.message$lambda$0(key, params);
    }

    @ApiStatus.Internal
    @NotNull
    public static final synchronized Set<PluginId> tryReadPluginIdsFromFile(@NotNull Path path, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        try {
            return PluginManagerCoreKt.readPluginIdsFromFile(path);
        }
        catch (IOException e2) {
            log.warn("Unable to read plugin id list from: " + path, e2);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized Set<PluginId> readPluginIdsFromFile(Path path) {
        try {
            AutoCloseable autoCloseable = Files.lines(path);
            Throwable throwable = null;
            try {
                Stream lines = (Stream)autoCloseable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)lines);
                Set set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)lines), (Function1)readPluginIdsFromFile.1.1.INSTANCE), (Function1)readPluginIdsFromFile.1.2.INSTANCE), (Function1)readPluginIdsFromFile.1.3.INSTANCE));
                return set;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException _) {
            return SetsKt.emptySet();
        }
    }

    private static final List<Supplier<HtmlChunk>> prepareActions(Collection<String> pluginNamesToDisable, Collection<String> pluginNamesToEnable) {
        String string2;
        if (pluginNamesToDisable.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Supplier<HtmlChunk>> actions = new ArrayList<Supplier<HtmlChunk>>();
        String pluginNameToDisable = (String)CollectionsKt.singleOrNull((Iterable)pluginNamesToDisable);
        if (pluginNameToDisable != null) {
            Object[] objectArray = new Object[]{pluginNameToDisable};
            string2 = CoreBundle.message("link.text.disable.plugin", objectArray);
        } else {
            string2 = CoreBundle.message("link.text.disable.not.loaded.plugins", new Object[0]);
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String disableMessage = string3;
        actions.add(() -> PluginManagerCoreKt.prepareActions$lambda$2(disableMessage));
        if (!pluginNamesToEnable.isEmpty()) {
            String string4;
            String pluginNameToEnable = (String)CollectionsKt.singleOrNull((Iterable)pluginNamesToEnable);
            if (pluginNameToEnable != null) {
                Object[] objectArray = new Object[]{pluginNameToEnable};
                string4 = CoreBundle.message("link.text.enable.plugin", objectArray);
            } else {
                string4 = CoreBundle.message("link.text.enable.all.necessary.plugins", new Object[0]);
            }
            String string5 = string4;
            Intrinsics.checkNotNull((Object)string5);
            String enableMessage = string5;
            actions.add(() -> PluginManagerCoreKt.prepareActions$lambda$3(enableMessage));
        }
        actions.add(PluginManagerCoreKt::prepareActions$lambda$4);
        return actions;
    }

    private static final IdeaPluginDescriptorImpl findClassInPluginThatUsesCoreClassloader(String className, PluginSet pluginSet) {
        String root = null;
        for (IdeaPluginDescriptorImpl descriptor2 : pluginSet.enabledPlugins) {
            if (!descriptor2.isUseIdeaClassLoader) continue;
            if (root == null && (root = PathManager.getResourceRoot(descriptor2.getClassLoader(), StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class")) == null) {
                return null;
            }
            Path path = descriptor2.getPluginPath();
            String string2 = FileUtilRt.toSystemIndependentName(((Object)path).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            if (!StringsKt.startsWith$default(root, (String)string2, (boolean)false, (int)2, null)) continue;
            return descriptor2;
        }
        return null;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @Nullable
    public static final Path getPluginDistDirByClass(@NotNull Class<?> aClass) {
        Path pluginDir;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Object object = aClass.getClassLoader();
        Object object2 = object instanceof PluginClassLoader ? (PluginClassLoader)object : null;
        Path path = object2 != null && (object2 = ((PluginClassLoader)object2).getPluginDescriptor()) != null ? object2.getPluginPath() : (pluginDir = null);
        if (pluginDir != null) {
            return pluginDir;
        }
        Path path2 = PathManager.getJarForClass(aClass);
        if (path2 == null) {
            throw new IllegalStateException(("Can't find plugin dist home for " + aClass.getSimpleName()).toString());
        }
        Path jarInsideLib = path2;
        if (StringsKt.endsWith((String)((Object)jarInsideLib.getFileName()).toString(), (String)"jar", (boolean)true)) {
            Object it = object = jarInsideLib.getParent();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)"lib")) {
                boolean bl3 = false;
                String string2 = it + " should be lib directory";
                throw new IllegalStateException(string2.toString());
            }
            return object.getParent();
        }
        return null;
    }

    private static final String message$lambda$0(String $key, Object[] $params) {
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        String string2 = $key;
        Intrinsics.checkNotNull((Object)string2);
        return CoreBundle.message(string2, Arrays.copyOf($params, $params.length));
    }

    private static final HtmlChunk prepareActions$lambda$2(String $disableMessage) {
        Intrinsics.checkNotNullParameter((Object)$disableMessage, (String)"$disableMessage");
        return HtmlChunk.link("disable", $disableMessage);
    }

    private static final HtmlChunk prepareActions$lambda$3(String $enableMessage) {
        Intrinsics.checkNotNullParameter((Object)$enableMessage, (String)"$enableMessage");
        return HtmlChunk.link("enable", $enableMessage);
    }

    private static final HtmlChunk prepareActions$lambda$4() {
        return HtmlChunk.link("edit", CoreBundle.message("link.text.open.plugin.manager", new Object[0]));
    }

    public static final /* synthetic */ IdeaPluginDescriptorImpl access$findClassInPluginThatUsesCoreClassloader(String className, PluginSet pluginSet) {
        return PluginManagerCoreKt.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    public static final /* synthetic */ Supplier access$message(String key, Object ... params) {
        return PluginManagerCoreKt.message(key, params);
    }

    public static final /* synthetic */ List access$prepareActions(Collection pluginNamesToDisable, Collection pluginNamesToEnable) {
        return PluginManagerCoreKt.prepareActions(pluginNamesToDisable, pluginNamesToEnable);
    }

    public static final /* synthetic */ boolean access$getQODANA_PLUGINS_THIRD_PARTY_ACCEPT$p() {
        return QODANA_PLUGINS_THIRD_PARTY_ACCEPT;
    }

    public static final /* synthetic */ boolean access$getFLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT$p() {
        return FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT;
    }

    public static final /* synthetic */ void access$setThirdPartyPluginsNoteAccepted$p(Boolean bl2) {
        thirdPartyPluginsNoteAccepted = bl2;
    }

    public static final /* synthetic */ Boolean access$getThirdPartyPluginsNoteAccepted$p() {
        return thirdPartyPluginsNoteAccepted;
    }

    public static final /* synthetic */ Set access$readPluginIdsFromFile(Path path) {
        return PluginManagerCoreKt.readPluginIdsFromFile(path);
    }
}

