/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.io.Serializable;
import java.util.Iterator;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.collect.Ordering;
import ksp.com.google.common.collect.ParametricNullness;
import ksp.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ReverseOrdering<T>
extends Ordering<T>
implements Serializable {
    final Ordering<? super T> forwardOrder;
    private static final long serialVersionUID = 0L;

    ReverseOrdering(Ordering<? super T> forwardOrder) {
        this.forwardOrder = Preconditions.checkNotNull(forwardOrder);
    }

    @Override
    public int compare(@ParametricNullness T a2, @ParametricNullness T b2) {
        return this.forwardOrder.compare(b2, a2);
    }

    @Override
    public <S extends T> Ordering<S> reverse() {
        return this.forwardOrder;
    }

    @Override
    public <E extends T> E min(@ParametricNullness E a2, @ParametricNullness E b2) {
        return this.forwardOrder.max(a2, b2);
    }

    @Override
    public <E extends T> E min(@ParametricNullness E a2, @ParametricNullness E b2, @ParametricNullness E c2, E ... rest) {
        return this.forwardOrder.max(a2, b2, c2, rest);
    }

    @Override
    public <E extends T> E min(Iterator<E> iterator2) {
        return this.forwardOrder.max(iterator2);
    }

    @Override
    public <E extends T> E min(Iterable<E> iterable) {
        return this.forwardOrder.max(iterable);
    }

    @Override
    public <E extends T> E max(@ParametricNullness E a2, @ParametricNullness E b2) {
        return this.forwardOrder.min(a2, b2);
    }

    @Override
    public <E extends T> E max(@ParametricNullness E a2, @ParametricNullness E b2, @ParametricNullness E c2, E ... rest) {
        return this.forwardOrder.min(a2, b2, c2, rest);
    }

    @Override
    public <E extends T> E max(Iterator<E> iterator2) {
        return this.forwardOrder.min(iterator2);
    }

    @Override
    public <E extends T> E max(Iterable<E> iterable) {
        return this.forwardOrder.min(iterable);
    }

    public int hashCode() {
        return -this.forwardOrder.hashCode();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ReverseOrdering) {
            ReverseOrdering that = (ReverseOrdering)object;
            return this.forwardOrder.equals(that.forwardOrder);
        }
        return false;
    }

    public String toString() {
        return this.forwardOrder + ".reverse()";
    }
}

