/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/SealedInheritorInSamePackageChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInheritorInSamePackageChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInheritorInSamePackageChecker INSTANCE = new SealedInheritorInSamePackageChecker();

    private SealedInheritorInSamePackageChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        FqName fqName = DescriptorUtilKt.containingPackage(descriptor2);
        if (fqName == null) {
            return;
        }
        FqName classPackage = fqName;
        for (KtSuperTypeListEntry superTypeListEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            FqName superClassPackage;
            ClassifierDescriptor superClass;
            KotlinType superType;
            KtTypeReference typeReference;
            if (superTypeListEntry.getTypeReference() == null) continue;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, bindingContext);
            if (kotlinType == null) continue;
            if ((kotlinType = kotlinType.unwrap()) == null || (superType = kotlinType).getConstructor().getDeclarationDescriptor() == null || !DescriptorUtilKt.isSealed(superClass) || DescriptorUtilKt.containingPackage(superClass) == null || Intrinsics.areEqual((Object)classPackage, (Object)superClassPackage)) continue;
            context2.getTrace().report(Errors.SEALED_INHERITOR_IN_DIFFERENT_PACKAGE.on((KtTypeReference)((PsiElement)typeReference), classPackage, superClassPackage));
        }
    }
}

