/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.functions.Function3;
import ksp.com.google.common.collect.Lists;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtCallExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunctionLiteral;
import ksp.org.jetbrains.kotlin.psi.KtQualifiedExpression;
import ksp.org.jetbrains.kotlin.psi.KtReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.TraceEntryFilter;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.expressions.CaptureKind;
import ksp.org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import ksp.org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import ksp.org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import ksp.org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import ksp.org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingContextUtils {
    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableFromResolvedCall(@NotNull BindingContext bindingContext, @Nullable KtElement callElement) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(0);
        }
        if ((resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext)) == null || !(resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor)) {
            return null;
        }
        return (VariableDescriptor)resolvedCall2.getResultingDescriptor();
    }

    @Nullable
    public static VariableDescriptor variableDescriptorForDeclaration(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor2;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return TowerLevelsKt.getFakeDescriptorForObject((ClassDescriptor)descriptor2);
        }
        return null;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorFromReference(@NotNull BindingContext bindingContext, @Nullable KtElement element2) {
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(1);
        }
        if (element2 instanceof KtSimpleNameExpression) {
            return BindingContextUtils.variableDescriptorForDeclaration(bindingContext.get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)element2));
        }
        if (element2 instanceof KtQualifiedExpression) {
            return BindingContextUtils.extractVariableDescriptorFromReference(bindingContext, ((KtQualifiedExpression)element2).getSelectorExpression());
        }
        return null;
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function2) {
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(2);
        }
        if (psiElement == null) {
            BindingContextUtils.$$$reportNull$$$0(3);
        }
        if (function2 == null) {
            BindingContextUtils.$$$reportNull$$$0(4);
        }
        trace.record(BindingContext.FUNCTION, psiElement, function2);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(5);
        }
        if (slice == null) {
            BindingContextUtils.$$$reportNull$$$0(6);
        }
        if (key == null) {
            BindingContextUtils.$$$reportNull$$$0(7);
        }
        return BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
    }

    @NotNull
    public static KotlinType getTypeNotNull(@NotNull BindingContext bindingContext, @NotNull KtExpression expression2) {
        KotlinType result2;
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(8);
        }
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(9);
        }
        if ((result2 = bindingContext.getType(expression2)) == null) {
            throw new IllegalStateException("Type must be not null for " + expression2);
        }
        KotlinType kotlinType = result2;
        if (kotlinType == null) {
            BindingContextUtils.$$$reportNull$$$0(10);
        }
        return kotlinType;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        V value2;
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(11);
        }
        if (slice == null) {
            BindingContextUtils.$$$reportNull$$$0(12);
        }
        if (key == null) {
            BindingContextUtils.$$$reportNull$$$0(13);
        }
        if (messageIfNull == null) {
            BindingContextUtils.$$$reportNull$$$0(14);
        }
        if ((value2 = bindingContext.get(slice, key)) == null) {
            throw new IllegalStateException(messageIfNull);
        }
        V v = value2;
        if (v == null) {
            BindingContextUtils.$$$reportNull$$$0(15);
        }
        return v;
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull KtSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(16);
        }
        if (targetLabel == null) {
            BindingContextUtils.$$$reportNull$$$0(17);
        }
        if (declarationsByLabel == null) {
            BindingContextUtils.$$$reportNull$$$0(18);
        }
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor2 : declarationsByLabel) {
            PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            assert (element2 != null) : "Label can only point to something in the same lexical scope";
            targets.add(element2);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static KotlinType updateRecordedType(@Nullable KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(19);
        }
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(20);
        }
        if (type2 == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type2 = TypeUtils.makeNullable(type2);
        }
        trace.recordType(expression2, type2);
        return type2;
    }

    @Nullable
    public static KotlinTypeInfo getRecordedTypeInfo(@NotNull KtExpression expression2, @NotNull BindingContext context2) {
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            BindingContextUtils.$$$reportNull$$$0(22);
        }
        if (context2.get(BindingContext.PROCESSED, expression2) != Boolean.TRUE) {
            return null;
        }
        KotlinTypeInfo result2 = context2.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return result2 != null ? result2 : TypeInfoFactoryKt.noTypeInfo(DataFlowInfoFactory.EMPTY);
    }

    public static boolean isExpressionWithValidReference(@NotNull KtExpression expression2, @NotNull BindingContext context2) {
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(23);
        }
        if (context2 == null) {
            BindingContextUtils.$$$reportNull$$$0(24);
        }
        if (expression2 instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context2);
            return resolvedCall2 instanceof VariableAsFunctionResolvedCall;
        }
        return expression2 instanceof KtReferenceExpression;
    }

    public static boolean isCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null;
    }

    public static boolean isCapturedInClosureWithExactlyOnceEffect(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) == CaptureKind.EXACTLY_ONCE_EFFECT;
    }

    public static boolean isBoxedLocalCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        return BindingContextUtils.isCapturedInClosure(bindingContext, descriptor2) && ((VariableDescriptor)descriptor2).isVar() || BindingContextUtils.isCapturedInClosureWithExactlyOnceEffect(bindingContext, descriptor2);
    }

    @NotNull
    public static Pair<FunctionDescriptor, PsiElement> getContainingFunctionSkipFunctionLiterals(@Nullable DeclarationDescriptor startDescriptor, boolean strict) {
        PsiElement containingFunction;
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(startDescriptor, FunctionDescriptor.class, strict);
        PsiElement psiElement = containingFunction = containingFunctionDescriptor != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        while (containingFunction instanceof KtFunctionLiteral) {
            containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        }
        return new Pair<FunctionDescriptor, PsiElement>(containingFunctionDescriptor, containingFunction);
    }

    @Nullable
    public static ResolvedCall<ConstructorDescriptor> getDelegationConstructorCall(@NotNull BindingContext bindingContext, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(25);
        }
        if (constructorDescriptor == null) {
            BindingContextUtils.$$$reportNull$$$0(26);
        }
        return bindingContext.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructorDescriptor);
    }

    static void addOwnDataTo(@NotNull BindingTrace trace, @Nullable TraceEntryFilter filter, boolean commitDiagnostics, @NotNull MutableSlicedMap map, MutableDiagnosticsWithSuppression diagnostics) {
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(27);
        }
        if (map == null) {
            BindingContextUtils.$$$reportNull$$$0(28);
        }
        map.forEach((Function3<WritableSlice, Object, Object, Void>)((Function3)(slice, key, value2) -> {
            if (filter == null || filter.accept((WritableSlice<?, ?>)slice, key)) {
                trace.record(slice, key, value2);
            }
            return null;
        }));
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : diagnostics.getOwnDiagnostics()) {
            if (filter != null && !filter.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/resolve/BindingContextUtils";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageIfNull";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLabel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsByLabel";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorDescriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/BindingContextUtils";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNotNull";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractVariableFromResolvedCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractVariableDescriptorFromReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordFunctionDeclarationToDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNotNull";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNotNull";
                break;
            }
            case 10: 
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportAmbiguousLabel";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateRecordedType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRecordedTypeInfo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionWithValidReference";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDelegationConstructorCall";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addOwnDataTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

