/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.navigation.ItemPresentation;
import ksp.com.intellij.navigation.ItemPresentationProviders;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.IfNotParsed;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtClassBody;
import ksp.org.jetbrains.kotlin.psi.KtContextReceiver;
import ksp.org.jetbrains.kotlin.psi.KtContextReceiverList;
import ksp.org.jetbrains.kotlin.psi.KtContractEffectList;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;
import ksp.org.jetbrains.kotlin.psi.KtScript;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterList;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import ksp.org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

public class KtNamedFunction
extends KtTypeParameterListOwnerStub<KotlinFunctionStub>
implements KtFunction,
KtDeclarationWithInitializer {
    public KtNamedFunction(@NotNull ASTNode node) {
        if (node == null) {
            KtNamedFunction.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtNamedFunction(@NotNull KotlinFunctionStub stub) {
        if (stub == null) {
            KtNamedFunction.$$$reportNull$$$0(1);
        }
        super(stub, (IStubElementType)KtStubElementTypes.FUNCTION);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtNamedFunction.$$$reportNull$$$0(2);
        }
        return visitor2.visitNamedFunction(this, data);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasTypeParameterListBeforeFunctionName();
        }
        return this.hasTypeParameterListBeforeFunctionNameByTree();
    }

    private boolean hasTypeParameterListBeforeFunctionNameByTree() {
        KtTypeParameterList typeParameterList = this.getTypeParameterList();
        if (typeParameterList == null) {
            return false;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return true;
        }
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasBlockBody();
        }
        return this.getEqualsToken() == null;
    }

    @IfNotParsed
    @Nullable
    public PsiElement getFunKeyword() {
        return this.findChildByType(KtTokens.FUN_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), KtExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return (KtParameterList)this.getStubOrPsiChild(KtStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        KtParameterList list = this.getValueParameterList();
        List<KtParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            KtNamedFunction.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @Nullable
    public KtExpression getBodyExpression() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            if (!stub.hasBody()) {
                return null;
            }
            if (this.getContainingKtFile().isCompiled()) {
                return null;
            }
        }
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    @Nullable
    public KtBlockExpression getBodyBlockExpression() {
        KtExpression bodyExpression;
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            if (!stub.hasBlockBody() || !stub.hasBody()) {
                return null;
            }
            if (this.getContainingKtFile().isCompiled()) {
                return null;
            }
        }
        if ((bodyExpression = this.findChildByClass(KtExpression.class)) instanceof KtBlockExpression) {
            return (KtBlockExpression)bodyExpression;
        }
        return null;
    }

    @Override
    public boolean hasBody() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getTypeReference() != null;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            List childTypeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            if (!childTypeReferences.isEmpty()) {
                return (KtTypeReference)childTypeReferences.get(0);
            }
            return null;
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private KtTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (PsiElement child = this.getFirstChild(); child != null && (tt = child.getNode().getElementType()) != KtTokens.LPAR && tt != KtTokens.COLON; child = child.getNextSibling()) {
            if (!(child instanceof KtTypeReference)) continue;
            return (KtTypeReference)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<KtContextReceiver> getContextReceivers() {
        KtContextReceiverList contextReceiverList = this.getContextReceiverList();
        if (contextReceiverList != null) {
            List<KtContextReceiver> list = contextReceiverList.contextReceivers();
            if (list == null) {
                KtNamedFunction.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<KtContextReceiver> list = Collections.emptyList();
        if (list == null) {
            KtNamedFunction.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            int returnTypeIndex;
            List typeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeIndex = stub.isExtension() ? 1 : 0;
            if (returnTypeIndex >= typeReferences.size()) {
                return null;
            }
            return (KtTypeReference)typeReferences.get(returnTypeIndex);
        }
        return TypeRefHelpersKt.getTypeReference(this);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getValueParameterList(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Override
    public boolean isLocal() {
        PsiElement parent2 = this.getParent();
        return !KtPsiUtilKt.isKtFile(parent2) && !(parent2 instanceof KtClassBody) && !(parent2.getParent() instanceof KtScript);
    }

    public boolean isAnonymous() {
        return this.getName() == null && this.isLocal();
    }

    public boolean isTopLevel() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return KtPsiUtilKt.isKtFile(this.getParent());
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    @Override
    public KtContractEffectList getContractDescription() {
        return (KtContractEffectList)this.getStubOrPsiChild(KtStubElementTypes.CONTRACT_EFFECT_LIST);
    }

    public boolean mayHaveContract() {
        return this.mayHaveContract(true);
    }

    public boolean mayHaveContract(boolean isAllowedOnMembers) {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.mayHaveContract();
        }
        return KtPsiUtilKt.isContractPresentPsiCheck(this, isAllowedOnMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/psi/KtNamedFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/psi/KtNamedFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextReceivers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

