/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.ir.Symbols;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.inline.CallInlinerStrategy;
import ksp.org.jetbrains.kotlin.ir.inline.InlineMode;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "", "inlineMode", "Lksp/org/jetbrains/kotlin/ir/inline/InlineMode;", "<init>", "(Lorg/jetbrains/kotlin/ir/inline/InlineMode;)V", "getInlineMode", "()Lorg/jetbrains/kotlin/ir/inline/InlineMode;", "callInlinerStrategy", "Lksp/org/jetbrains/kotlin/ir/inline/CallInlinerStrategy;", "getCallInlinerStrategy", "()Lorg/jetbrains/kotlin/ir/inline/CallInlinerStrategy;", "allowExternalInlining", "", "getAllowExternalInlining", "()Z", "needsInlining", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getFunctionDeclaration", "symbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "shouldExcludeFunctionFromInlining", "ir.inline"})
public abstract class InlineFunctionResolver {
    @NotNull
    private final InlineMode inlineMode;

    public InlineFunctionResolver(@NotNull InlineMode inlineMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)inlineMode), (String)"inlineMode");
        this.inlineMode = inlineMode;
    }

    @NotNull
    public final InlineMode getInlineMode() {
        return this.inlineMode;
    }

    @NotNull
    public CallInlinerStrategy getCallInlinerStrategy() {
        return CallInlinerStrategy.DEFAULT.INSTANCE;
    }

    public boolean getAllowExternalInlining() {
        return false;
    }

    public boolean needsInlining(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2.isInline() && (this.getAllowExternalInlining() || !function2.isExternal());
    }

    public boolean needsInlining(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.needsInlining(((IrFunctionSymbol)expression2.getSymbol()).getOwner());
    }

    @Nullable
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (this.shouldExcludeFunctionFromInlining(symbol)) {
            return null;
        }
        IrFunction owner = symbol.getOwner();
        IrSimpleFunction irSimpleFunction = owner instanceof IrSimpleFunction ? (IrSimpleFunction)owner : null;
        return irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : owner;
    }

    protected boolean shouldExcludeFunctionFromInlining(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return !this.needsInlining(symbol.getOwner()) || Symbols.Companion.isTypeOfIntrinsic(symbol);
    }
}

