/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionResultOverridesOtherToPreserveCompatibility;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStageRunner;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\u00020\u001f8F\u00a2\u0006\f\u0012\u0004\b$\u0010%\u001a\u0004\b#\u0010\"\u00a8\u0006&"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/CandidateCollector;", "", "components", "Lksp/org/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "resolutionStageRunner", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "groupNumbers", "", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "candidates", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "value", "Lksp/org/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "currentApplicability", "getCurrentApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "bestGroup", "newDataSet", "", "consumeCandidate", "group", "candidate", "context", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "bestCandidates", "", "shouldStopAtTheGroup", "", "shouldStopResolve", "getShouldStopResolve", "()Z", "isSuccess", "isSuccess$annotations", "()V", "resolve"})
public class CandidateCollector {
    @NotNull
    private final BodyResolveComponents components;
    @NotNull
    private final ResolutionStageRunner resolutionStageRunner;
    @NotNull
    private final List<TowerGroup> groupNumbers;
    @NotNull
    private final List<Candidate> candidates;
    @NotNull
    private CandidateApplicability currentApplicability;
    @NotNull
    private TowerGroup bestGroup;

    public CandidateCollector(@NotNull BodyResolveComponents components, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)resolutionStageRunner, (String)"resolutionStageRunner");
        this.components = components;
        this.resolutionStageRunner = resolutionStageRunner;
        this.groupNumbers = new ArrayList();
        this.candidates = new ArrayList();
        this.currentApplicability = CandidateApplicability.HIDDEN;
        this.bestGroup = TowerGroup.Companion.getLast();
    }

    @NotNull
    public final BodyResolveComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final CandidateApplicability getCurrentApplicability() {
        return this.currentApplicability;
    }

    public final void newDataSet() {
        this.groupNumbers.clear();
        this.candidates.clear();
        this.currentApplicability = CandidateApplicability.HIDDEN;
        this.bestGroup = TowerGroup.Companion.getLast();
    }

    @NotNull
    public CandidateApplicability consumeCandidate(@NotNull TowerGroup group, @NotNull Candidate candidate, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CandidateApplicability applicability = ResolutionStageRunner.processCandidate$default(this.resolutionStageRunner, candidate, context2, false, 4, null);
        if (applicability.compareTo((Enum)this.currentApplicability) > 0 || applicability == this.currentApplicability && group.compareTo(this.bestGroup) < 0) {
            if (applicability.compareTo((Enum)CandidateApplicability.RESOLVED_LOW_PRIORITY) >= 0) {
                this.candidates.clear();
            }
            if (this.currentApplicability == CandidateApplicability.RESOLVED_NEED_PRESERVE_COMPATIBILITY && applicability.compareTo((Enum)this.currentApplicability) > 0) {
                candidate.addDiagnostic(ResolutionResultOverridesOtherToPreserveCompatibility.INSTANCE);
            }
            this.currentApplicability = applicability;
            this.bestGroup = group;
        }
        if (applicability == this.currentApplicability && Intrinsics.areEqual((Object)group, (Object)this.bestGroup) || this.currentApplicability == CandidateApplicability.INAPPLICABLE_ARGUMENTS_MAPPING_ERROR && applicability == CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER) {
            this.candidates.add(candidate);
        }
        return applicability;
    }

    @NotNull
    public final List<Candidate> bestCandidates() {
        return this.candidates;
    }

    public boolean shouldStopAtTheGroup(@NotNull TowerGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return this.getShouldStopResolve() && this.bestGroup.compareTo(group) < 0;
    }

    public final boolean getShouldStopResolve() {
        return CandidateApplicabilityKt.getShouldStopResolve(this.currentApplicability);
    }

    public final boolean isSuccess() {
        return CandidateApplicabilityKt.isSuccess(this.currentApplicability);
    }

    public static /* synthetic */ void isSuccess$annotations() {
    }
}

