/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J6\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J6\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsStaticChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotated", "targetSource", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "outerProperty", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "checkVisibility", "getMinimumVisibility", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "chooseMostSpecific", "a", "b", "checkOverrideCannotBeStatic", "Lksp/org/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkStaticOnConst", "containerIsInterface", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isCompanion", "findAnnotation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsStaticChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1#2:163\n21#3:164\n21#3:165\n21#3:166\n21#3:167\n37#3:168\n44#3:169\n34#4:170\n56#5:171\n295#6,2:172\n*S KotlinDebug\n*F\n+ 1 FirJsStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsStaticChecker\n*L\n97#1:164\n106#1:165\n109#1:166\n113#1:167\n135#1:168\n147#1:169\n151#1:170\n154#1:171\n157#1:172,2\n*E\n"})
public final class FirJsStaticChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsStaticChecker INSTANCE = new FirJsStaticChecker();

    private FirJsStaticChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirPropertyAccessor it;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration2 instanceof FirConstructor) {
                return;
            }
            if (declaration2 instanceof FirPropertyAccessor) {
                return;
            }
            FirAnnotation declarationAnnotation = this.findAnnotation(declaration2, JsStandardClassIds.Annotations.JsStatic, context2.getSession());
            if (declarationAnnotation != null) {
                FirJsStaticChecker.checkAnnotated$default(this, declaration2, context2, reporter, declaration2.getSource(), null, 16, null);
            }
            if (!(declaration2 instanceof FirProperty)) break block5;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration2).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirJsStaticChecker.check$checkIfAnnotated(context2, declaration2, reporter, it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration2).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                FirJsStaticChecker.check$checkIfAnnotated(context2, declaration2, reporter, it);
            }
        }
    }

    private final void checkAnnotated(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(declaration2);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> container = firClassLikeSymbol;
        if (!this.isCompanion(container) || this.containerIsInterface(container)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_NOT_IN_CLASS_COMPANION(), (DiagnosticContext)context2, null, 8, null);
        }
        this.checkOverrideCannotBeStatic((FirMemberDeclaration)declaration2, context2, reporter, targetSource, outerProperty);
        this.checkStaticOnConst(declaration2, context2, reporter, targetSource);
        this.checkVisibility(declaration2, context2, reporter, targetSource);
    }

    static /* synthetic */ void checkAnnotated$default(FirJsStaticChecker firJsStaticChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, FirProperty firProperty, int n, Object object) {
        if ((n & 0x10) != 0) {
            firProperty = null;
        }
        firJsStaticChecker.checkAnnotated(firDeclaration, checkerContext, diagnosticReporter, ktSourceElement, firProperty);
    }

    private final void checkVisibility(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement targetSource) {
        Visibility visibility;
        Visibility visibility2;
        if (!(declaration2 instanceof FirCallableDeclaration)) {
            return;
        }
        if (declaration2 instanceof FirProperty) {
            visibility2 = this.getMinimumVisibility((FirProperty)declaration2);
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$getVisibility = false;
            visibility2 = visibility = $this$visibility$iv.getStatus().getVisibility();
        }
        if (!Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Public.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_NON_PUBLIC_MEMBER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final Visibility getMinimumVisibility(FirProperty $this$getMinimumVisibility) {
        Visibility minVisibility;
        block1: {
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirPropertyAccessor it;
            minVisibility = null;
            FirMemberDeclaration $this$visibility$iv2 = $this$getMinimumVisibility;
            boolean $i$f$getVisibility2 = false;
            minVisibility = $this$visibility$iv2.getStatus().getVisibility();
            FirPropertyAccessor firPropertyAccessor = $this$getMinimumVisibility.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                $this$visibility$iv = it;
                $i$f$getVisibility = false;
                minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
            }
            FirPropertyAccessor firPropertyAccessor2 = $this$getMinimumVisibility.getSetter();
            if (firPropertyAccessor2 == null) break block1;
            it = firPropertyAccessor2;
            boolean bl = false;
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
        }
        return minVisibility;
    }

    private final Visibility chooseMostSpecific(Visibility a, Visibility b) {
        Integer n = a.compareTo(b);
        if (n == null) {
            return a;
        }
        int difference2 = n;
        return difference2 > 0 ? b : a;
    }

    private final void checkOverrideCannotBeStatic(FirMemberDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        block6: {
            block5: {
                boolean bl;
                boolean $i$f$isOverride;
                FirMemberDeclaration $this$isOverride$iv;
                FirProperty firProperty = outerProperty;
                if (firProperty != null) {
                    $this$isOverride$iv = firProperty;
                    $i$f$isOverride = false;
                    bl = $this$isOverride$iv.getStatus().isOverride();
                } else {
                    bl = false;
                }
                if (bl) break block5;
                $this$isOverride$iv = declaration2;
                $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block6;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_OVERRIDE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    static /* synthetic */ void checkOverrideCannotBeStatic$default(FirJsStaticChecker firJsStaticChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, FirProperty firProperty, int n, Object object) {
        if ((n & 0x10) != 0) {
            firProperty = null;
        }
        firJsStaticChecker.checkOverrideCannotBeStatic(firMemberDeclaration, checkerContext, diagnosticReporter, ktSourceElement, firProperty);
    }

    private final void checkStaticOnConst(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement targetSource) {
        if (!(declaration2 instanceof FirProperty)) {
            return;
        }
        FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isConst = false;
        if ($this$isConst$iv.getStatus().isConst()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_CONST(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean containerIsInterface(FirClassLikeSymbol<?> $this$containerIsInterface) {
        boolean bl;
        Object object = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$containerIsInterface);
        if (object != null && (object = FirHelpersKt.getClassKind(object)) != null) {
            Object $this$isInterface$iv = object;
            boolean $i$f$isInterface = false;
            bl = $this$isInterface$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCompanion(FirClassLikeSymbol<?> $this$isCompanion) {
        boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = $this$isCompanion instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$isCompanion : null;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl = false;
        }
        return bl;
    }

    private final FirAnnotation findAnnotation(FirDeclaration $this$findAnnotation, ClassId classId, FirSession session) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()), session), (Object)classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void check$checkIfAnnotated(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirDeclaration it) {
        if (!FirAnnotationUtilsKt.hasAnnotation(it, JsStandardClassIds.Annotations.JsStatic, $context.getSession())) {
            return;
        }
        KtSourceElement ktSourceElement = it.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = $declaration.getSource();
        }
        KtSourceElement targetSource = ktSourceElement;
        INSTANCE.checkAnnotated(it, $context, $reporter, targetSource, $declaration instanceof FirProperty ? (FirProperty)$declaration : null);
    }
}

