/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extra/UselessCallOnNotNullChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getCallableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "triggerOn", "", "checkers"})
public final class UselessCallOnNotNullChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final UselessCallOnNotNullChecker INSTANCE = new UselessCallOnNotNullChecker();
    @NotNull
    private static final Set<CallableId> triggerOn;

    private UselessCallOnNotNullChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        CallableId callableId = this.getCallableId(expression2);
        if (callableId == null) {
            return;
        }
        CallableId method = callableId;
        if (!triggerOn.contains(method)) {
            return;
        }
        FirExpression firExpression = expression2.getExplicitReceiver();
        if (firExpression == null) {
            return;
        }
        FirExpression calleeOn = firExpression;
        if (!TypeUtilsKt.canBeNull(FirTypeUtilsKt.getResolvedType(calleeOn), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CALL_ON_NOT_NULL(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final CallableId getCallableId(FirQualifiedAccessExpression $this$getCallableId) {
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$getCallableId.getCalleeReference(), false, 1, null);
        return firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getCallableId() : null;
    }

    static {
        Object[] objectArray = new CallableId[8];
        FqName fqName = StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE();
        Name name2 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        objectArray[0] = new CallableId(fqName, name2);
        FqName fqName2 = StandardClassIds.INSTANCE.getBASE_SEQUENCES_PACKAGE();
        Name name3 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        objectArray[1] = new CallableId(fqName2, name3);
        FqName fqName3 = StandardClassIds.INSTANCE.getBASE_TEXT_PACKAGE();
        Name name4 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        objectArray[2] = new CallableId(fqName3, name4);
        FqName fqName4 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name5 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        objectArray[3] = new CallableId(fqName4, name5);
        FqName fqName5 = StandardClassIds.INSTANCE.getBASE_TEXT_PACKAGE();
        Name name6 = Name.identifier("isNullOrBlank");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(...)");
        objectArray[4] = new CallableId(fqName5, name6);
        FqName fqName6 = StandardClassIds.INSTANCE.getBASE_TEXT_PACKAGE();
        Name name7 = Name.identifier("isNullOrEmpty");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
        objectArray[5] = new CallableId(fqName6, name7);
        FqName fqName7 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name8 = Name.identifier("isNullOrBlank");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"identifier(...)");
        objectArray[6] = new CallableId(fqName7, name8);
        FqName fqName8 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name9 = Name.identifier("isNullOrEmpty");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"identifier(...)");
        objectArray[7] = new CallableId(fqName8, name9);
        triggerOn = SetsKt.setOf((Object[])objectArray);
    }
}

