/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import ksp.org.jetbrains.kotlin.fir.FirExpectActualMatchingContextFactory;
import ksp.org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import ksp.org.jetbrains.kotlin.fir.FirSourceElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import ksp.org.jetbrains.kotlin.mpp.SourceElementMarker;
import ksp.org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.mpp.ExpectActualMatchingContext;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualAnnotationsMatchExpectChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationsMatch", "expectSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "actualSymbol", "expectContainingClass", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualAnnotationsMatchExpectChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualAnnotationsMatchExpectChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualAnnotationsMatchExpectChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,70:1\n33#2:71\n*S KotlinDebug\n*F\n+ 1 FirActualAnnotationsMatchExpectChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualAnnotationsMatchExpectChecker\n*L\n34#1:71\n*E\n"})
public final class FirActualAnnotationsMatchExpectChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirActualAnnotationsMatchExpectChecker INSTANCE = new FirActualAnnotationsMatchExpectChecker();

    private FirActualAnnotationsMatchExpectChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol actualContainingClass;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        FirBasedSymbol<FirDeclaration> actualSymbol = ((FirMemberDeclaration)declaration2).getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(actualSymbol);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> expectSymbol = firBasedSymbol;
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirBasedSymbol<FirDeclaration> firBasedSymbol2 = firDeclaration != null ? firDeclaration.getSymbol() : null;
        FirRegularClassSymbol firRegularClassSymbol = actualContainingClass = firBasedSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol2 : null;
        FirBasedSymbol<?> firBasedSymbol3 = firRegularClassSymbol != null ? ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(firRegularClassSymbol) : null;
        FirRegularClassSymbol expectContainingClass = firBasedSymbol3 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol3 : null;
        this.checkAnnotationsMatch(expectSymbol, actualSymbol, expectContainingClass, context2, reporter);
    }

    private final void checkAnnotationsMatch(FirBasedSymbol<?> expectSymbol, FirBasedSymbol<?> actualSymbol, FirRegularClassSymbol expectContainingClass, CheckerContext context2, DiagnosticReporter reporter) {
        FirExpectActualMatchingContext matchingContext2 = FirExpectActualMatchingContextFactory.create$default(FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()), context2.getSession(), context2.getScopeSession(), false, 4, null);
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility = AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible(expectSymbol, (DeclarationSymbolMarker)actualSymbol, expectContainingClass, matchingContext2);
        if (incompatibility == null) {
            return;
        }
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility2 = incompatibility;
        SourceElementMarker sourceElementMarker = incompatibility2.getActualAnnotationTargetElement();
        Intrinsics.checkNotNull((Object)sourceElementMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirSourceElement");
        KtSourceElement actualAnnotationTargetSourceElement = ((FirSourceElement)sourceElementMarker).getElement();
        KtDiagnosticFactory4<FirBasedSymbol<?>, FirBasedSymbol<?>, KtSourceElement, ExpectActualAnnotationsIncompatibilityType<FirAnnotation>> ktDiagnosticFactory4 = FirErrors.INSTANCE.getACTUAL_ANNOTATIONS_NOT_MATCH_EXPECT();
        AbstractKtSourceElement abstractKtSourceElement = KtDiagnosticReportHelpersKt.requireNotNull(actualSymbol.getSource());
        DeclarationSymbolMarker declarationSymbolMarker = incompatibility2.getExpectSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)declarationSymbolMarker;
        DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility2.getActualSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        reporter.report(ktDiagnosticFactory4.on(abstractKtSourceElement, firBasedSymbol, (FirBasedSymbol)declarationSymbolMarker2, actualAnnotationTargetSourceElement, incompatibility2.getType().mapAnnotationType(FirActualAnnotationsMatchExpectChecker::checkAnnotationsMatch$lambda$0), null), context2);
    }

    private static final FirAnnotation checkAnnotationsMatch$lambda$0(ExpectActualMatchingContext.AnnotationCallInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnnotationSymbol();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
        return (FirAnnotation)object;
    }
}

