/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationData;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import ksp.org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="TailCallOptimization")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/TailCallOptimizationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "coerceToUnit", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
public final class TailCallOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public TailCallOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transformChildren((IrElementTransformer)new IrTransformer<TailCallOptimizationData>(this){
            final /* synthetic */ TailCallOptimizationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitSimpleFunction(IrSimpleFunction declaration2, TailCallOptimizationData data) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return super.visitSimpleFunction(declaration2, declaration2.isSuspend() ? new TailCallOptimizationData(declaration2) : null);
            }

            public IrExpression visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, TailCallOptimizationData data) {
                Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
                if (IrInlineUtilsKt.isFunctionInlining(inlinedBlock)) {
                    return inlinedBlock;
                }
                return super.visitInlinedFunctionBlock(inlinedBlock, data);
            }

            public IrExpression visitCall(IrCall expression2, TailCallOptimizationData data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Object object = super.visitCall(expression2, data);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                IrExpression transformed = (IrExpression)object;
                return data == null || !data.getTailCalls().contains(expression2) ? transformed : (IrExpression)new IrReturnImpl(data.getFunction().getEndOffset(), data.getFunction().getEndOffset(), TailCallOptimizationLowering.access$getContext$p(this.this$0).getIrBuiltIns().getNothingType(), data.getFunction().getSymbol(), data.getReturnsUnit() ? TailCallOptimizationLowering.access$coerceToUnit(this.this$0, transformed) : transformed);
            }
        }, null);
    }

    private final IrExpression coerceToUnit(IrExpression $this$coerceToUnit) {
        return Intrinsics.areEqual((Object)$this$coerceToUnit.getType(), (Object)this.context.getIrBuiltIns().getUnitType()) ? $this$coerceToUnit : (IrExpression)BuildersKt.IrTypeOperatorCallImpl($this$coerceToUnit.getStartOffset(), $this$coerceToUnit.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, this.context.getIrBuiltIns().getUnitType(), $this$coerceToUnit);
    }

    public static final /* synthetic */ JvmBackendContext access$getContext$p(TailCallOptimizationLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ IrExpression access$coerceToUnit(TailCallOptimizationLowering $this, IrExpression $receiver) {
        return $this.coerceToUnit($receiver);
    }
}

