/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ShutDownTracker {
    private final Deque<Runnable> myShutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private final Deque<Runnable> myCachesShutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private final Thread myThread = new Thread(() -> this.run(), "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            ShutDownTracker.$$$reportNull$$$0(0);
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    @ApiStatus.Internal
    public void run() {
        Runnable task;
        while ((task = this.getNextTask()) != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                try {
                    Logger.getInstance(ShutDownTracker.class).error(e);
                }
                catch (AssertionError assertionError) {}
            }
        }
    }

    @Nullable
    private Runnable getNextTask() {
        Runnable task = this.myCachesShutdownTasks.pollLast();
        if (task != null) {
            return task;
        }
        return this.myShutdownTasks.pollLast();
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitFor(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ShutDownTracker.$$$reportNull$$$0(1);
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            try {
                void unit;
                this.myThread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myThread.isAlive();
        }
        return false;
    }

    public void registerShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            ShutDownTracker.$$$reportNull$$$0(2);
        }
        this.myShutdownTasks.addLast(task);
    }

    public void unregisterShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            ShutDownTracker.$$$reportNull$$$0(3);
        }
        this.myShutdownTasks.remove(task);
        this.myCachesShutdownTasks.remove(task);
    }

    @ApiStatus.Internal
    public void registerCacheShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            ShutDownTracker.$$$reportNull$$$0(4);
        }
        this.myCachesShutdownTasks.addLast(task);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/util/ShutDownTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/util/ShutDownTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerShutdownTask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterShutdownTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerCacheShutdownTask";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

