/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.folding;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.folding.FoldingBuilder;
import ksp.com.intellij.lang.folding.FoldingBuilderEx;
import ksp.com.intellij.lang.folding.LanguageFolding;
import ksp.com.intellij.openapi.editor.FoldingGroup;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.BitUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class FoldingDescriptor {
    public static final FoldingDescriptor[] EMPTY_ARRAY = new FoldingDescriptor[0];
    @Deprecated
    public static final FoldingDescriptor[] EMPTY = EMPTY_ARRAY;
    private static final byte FLAG_NEVER_EXPANDS = 1;
    private static final byte FLAG_COLLAPSED_BY_DEFAULT_DEFINED = 2;
    private static final byte FLAG_COLLAPSED_BY_DEFAULT = 4;
    private static final byte FLAG_CAN_BE_REMOVED_WHEN_COLLAPSED = 8;
    private static final byte FLAG_GUTTER_MARK_ENABLED_FOR_SINGLE_LINE = 16;
    private final ASTNode myElement;
    private final TextRange myRange;
    @Nullable
    private final FoldingGroup myGroup;
    private final Set<Object> myDependencies;
    private String myPlaceholderText;
    private byte myFlags;

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(1);
        }
        this(node, range, null);
    }

    public FoldingDescriptor(@NotNull PsiElement element2, @NotNull TextRange range) {
        if (element2 == null) {
            FoldingDescriptor.$$$reportNull$$$0(2);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(3);
        }
        this(Objects.requireNonNull(element2.getNode()), range, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(4);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(5);
        }
        this(node, range, group, Collections.emptySet());
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(6);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(7);
        }
        this(node, range, group, dependencies, false);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies, boolean neverExpands) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(8);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(9);
        }
        this(node, range, group, dependencies, neverExpands, null, null);
    }

    public FoldingDescriptor(@NotNull PsiElement e, int start, int end, @Nullable FoldingGroup group, @NotNull String placeholderText) {
        if (e == null) {
            FoldingDescriptor.$$$reportNull$$$0(10);
        }
        if (placeholderText == null) {
            FoldingDescriptor.$$$reportNull$$$0(11);
        }
        this(e.getNode(), new TextRange(start, end), group, placeholderText);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, @NotNull String placeholderText) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(12);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(13);
        }
        if (placeholderText == null) {
            FoldingDescriptor.$$$reportNull$$$0(14);
        }
        this(node, range, group, Collections.emptySet(), false, placeholderText, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, @NotNull String placeholderText, @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") Boolean collapsedByDefault, @NotNull Set<Object> dependencies) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(15);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(16);
        }
        if (placeholderText == null) {
            FoldingDescriptor.$$$reportNull$$$0(17);
        }
        if (dependencies == null) {
            FoldingDescriptor.$$$reportNull$$$0(18);
        }
        this(node, range, group, dependencies, false, placeholderText, collapsedByDefault);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, @NotNull Set<Object> dependencies, boolean neverExpands, @Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") @Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") String placeholderText, @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") Boolean collapsedByDefault) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(19);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(20);
        }
        if (dependencies == null) {
            FoldingDescriptor.$$$reportNull$$$0(21);
        }
        assert (range.getLength() > 0) : range + ", text: " + node.getText() + ", language = " + node.getPsi().getLanguage();
        if (neverExpands && group != null) {
            throw new IllegalArgumentException("'Never-expanding' region cannot be part of a group");
        }
        this.myElement = node;
        this.myRange = range;
        this.myGroup = group;
        this.myDependencies = dependencies;
        try {
            assert (dependencies.isEmpty() || !dependencies.contains(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.myPlaceholderText = placeholderText;
        this.setFlag((byte)1, neverExpands);
        if (collapsedByDefault != null) {
            this.setFlag((byte)2, true);
            this.setFlag((byte)4, collapsedByDefault);
        }
    }

    @NotNull
    public ASTNode getElement() {
        ASTNode aSTNode = this.myElement;
        if (aSTNode == null) {
            FoldingDescriptor.$$$reportNull$$$0(22);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            FoldingDescriptor.$$$reportNull$$$0(23);
        }
        return textRange;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getPlaceholderText() {
        return this.myPlaceholderText == null ? this.calcPlaceholderText() : this.myPlaceholderText;
    }

    @ApiStatus.Internal
    final String getCachedPlaceholderText() {
        return this.myPlaceholderText;
    }

    public void setPlaceholderText(@Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") @Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") String placeholderText) {
        this.myPlaceholderText = placeholderText;
    }

    String calcPlaceholderText() {
        PsiElement psiElement = this.myElement.getPsi();
        if (psiElement == null) {
            return null;
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiElement.getLanguage());
        if (foldingBuilder == null) {
            return null;
        }
        return foldingBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)foldingBuilder).getPlaceholderText(this.myElement, this.myRange) : foldingBuilder.getPlaceholderText(this.myElement);
    }

    @NotNull
    public Set<Object> getDependencies() {
        Set<Object> set = this.myDependencies;
        if (set == null) {
            FoldingDescriptor.$$$reportNull$$$0(24);
        }
        return set;
    }

    public boolean isNonExpandable() {
        return this.getFlag((byte)1);
    }

    public boolean canBeRemovedWhenCollapsed() {
        return this.getFlag((byte)8);
    }

    @Nullable
    public Boolean isCollapsedByDefault() {
        return this.getFlag((byte)2) ? Boolean.valueOf(this.getFlag((byte)4)) : null;
    }

    public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
        this.setFlag((byte)8, canBeRemovedWhenCollapsed);
    }

    public boolean isGutterMarkEnabledForSingleLine() {
        return this.getFlag((byte)16);
    }

    public void setGutterMarkEnabledForSingleLine(boolean value2) {
        this.setFlag((byte)16, value2);
    }

    private boolean getFlag(byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(byte mask, boolean value2) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value2);
    }

    public String toString() {
        return this.myRange + " for AST: " + this.myElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/folding/FoldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/folding/FoldingDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

