/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.github.benmanes.caffeine.cache;

import ksp.com.github.benmanes.caffeine.cache.CacheLoader;
import ksp.com.github.benmanes.caffeine.cache.Caffeine;
import ksp.com.github.benmanes.caffeine.cache.Expiry;
import ksp.com.github.benmanes.caffeine.cache.Pacer;
import ksp.com.github.benmanes.caffeine.cache.SIMS;
import ksp.com.github.benmanes.caffeine.cache.Scheduler;
import ksp.com.github.benmanes.caffeine.cache.Ticker;
import ksp.com.github.benmanes.caffeine.cache.TimerWheel;

class SIMSA<K, V>
extends SIMS<K, V> {
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    SIMSA(Caffeine<K, V> builder2, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder2, cacheLoader, async);
        this.ticker = builder2.getTicker();
        this.expiry = builder2.getExpiry(this.isAsync);
        this.timerWheel = builder2.expiresVariable() ? new TimerWheel(this) : null;
        this.expiresAfterAccessNanos = builder2.getExpiresAfterAccessNanos();
        this.pacer = builder2.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(builder2.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    protected final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
        this.expiresAfterAccessNanos = expiresAfterAccessNanos;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

