/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotated;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportIncorrectInline", "Lksp/org/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lksp/org/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class InlineParameterChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineParameterChecker INSTANCE = new InlineParameterChecker();

    private InlineParameterChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration2 instanceof KtFunction)) break block5;
            boolean inline = declaration2.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter2 : ((KtFunction)declaration2).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                block7: {
                    block6: {
                        parameterDescriptor = (VariableDescriptor)context2.getTrace().get(BindingContext.VALUE_PARAMETER, parameter2);
                        if (!inline) break block6;
                        if (parameterDescriptor == null) break block7;
                        KotlinType kotlinType = parameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                        if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) break block7;
                    }
                    Intrinsics.checkNotNull((Object)parameter2);
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"NOINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter2, ktModifierKeywordToken, context2.getTrace());
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter2, ktModifierKeywordToken2, context2.getTrace());
                }
                if (!inline || parameter2.hasModifier(KtTokens.NOINLINE_KEYWORD) || parameter2.hasModifier(KtTokens.CROSSINLINE_KEYWORD)) continue;
                Annotated annotated = parameterDescriptor;
                boolean bl2 = annotated != null && (annotated = annotated.getType()) != null ? FunctionTypesKt.isSuspendFunctionType((KotlinType)annotated) : false;
                if (!bl2) continue;
                if (declaration2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    KtElementImplStub ktElementImplStub = parameter2.getTypeReference();
                    PsiElement modifier = ktElementImplStub != null && (ktElementImplStub = ((KtModifierListOwnerStub)ktElementImplStub).getModifierList()) != null ? ((KtModifierList)ktElementImplStub).getModifier(KtTokens.SUSPEND_KEYWORD) : null;
                    if (modifier == null) continue;
                    context2.getTrace().report(Errors.REDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE.on(modifier));
                    continue;
                }
                context2.getTrace().report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter2)));
            }
        }
    }

    private final void reportIncorrectInline(KtParameter $this$reportIncorrectInline, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        block0: {
            PsiElement modifier;
            KtModifierList ktModifierList = $this$reportIncorrectInline.getModifierList();
            PsiElement psiElement = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl2 = false;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }
}

