/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.ir.IrFileEntry;
import ksp.org.jetbrains.kotlin.ir.LineAndColumn;
import ksp.org.jetbrains.kotlin.ir.SourceRangeInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/ir/AbstractIrFileEntry;", "Lksp/org/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "()V", "lineStartOffsets", "", "getLineStartOffsets", "()[I", "getLineStartOffsetsForSerialization", "", "", "getLineNumber", "offset", "getColumnNumber", "getLineAndColumnNumbers", "Lksp/org/jetbrains/kotlin/ir/LineAndColumn;", "getSourceRangeInfo", "Lksp/org/jetbrains/kotlin/ir/SourceRangeInfo;", "beginOffset", "endOffset", "ir.tree"})
public abstract class AbstractIrFileEntry
implements IrFileEntry {
    @NotNull
    protected abstract int[] getLineStartOffsets();

    @NotNull
    public final Iterable<Integer> getLineStartOffsetsForSerialization() {
        return ArraysKt.asIterable((int[])this.getLineStartOffsets());
    }

    @Override
    public int getLineNumber(int offset) {
        if (offset < 0) {
            return -1;
        }
        int index2 = ArraysKt.binarySearch$default((int[])this.getLineStartOffsets(), (int)offset, (int)0, (int)0, (int)6, null);
        return index2 >= 0 ? index2 : -index2 - 2;
    }

    @Override
    public int getColumnNumber(int offset) {
        if (offset < 0) {
            return -1;
        }
        int lineNumber = this.getLineNumber(offset);
        if (lineNumber < 0) {
            return -1;
        }
        return offset - this.getLineStartOffsets()[lineNumber];
    }

    @Override
    @NotNull
    public LineAndColumn getLineAndColumnNumbers(int offset) {
        if (offset < 0) {
            return new LineAndColumn(-1, -1);
        }
        int lineNumber = this.getLineNumber(offset);
        if (lineNumber < 0) {
            return new LineAndColumn(lineNumber, -1);
        }
        int columnNumber = offset - this.getLineStartOffsets()[lineNumber];
        return new LineAndColumn(lineNumber, columnNumber);
    }

    @Override
    @NotNull
    public SourceRangeInfo getSourceRangeInfo(int beginOffset, int endOffset) {
        LineAndColumn lineAndColumn = this.getLineAndColumnNumbers(beginOffset);
        int startLineNumber = lineAndColumn.component1();
        int startColumnNumber = lineAndColumn.component2();
        LineAndColumn lineAndColumn2 = this.getLineAndColumnNumbers(endOffset);
        int endLineNumber = lineAndColumn2.component1();
        int endColumnNumber = lineAndColumn2.component2();
        return new SourceRangeInfo(this.getName(), beginOffset, startLineNumber, startColumnNumber, endOffset, endLineNumber, endColumnNumber);
    }

    @Override
    public boolean getSupportsDebugInfo() {
        return IrFileEntry.DefaultImpls.getSupportsDebugInfo(this);
    }
}

