/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;

public final class StringOperation {
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final CharSequence myReplacement;
    private static final Comparator<StringOperation> ourComparator = Comparator.comparing(o2 -> o2.myRange, Comparator.comparingInt(TextRange::getStartOffset).thenComparingInt(TextRange::getEndOffset));

    private StringOperation(@NotNull TextRange range, @NotNull CharSequence replacement) {
        if (range == null) {
            StringOperation.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringOperation.$$$reportNull$$$0(1);
        }
        this.myRange = range;
        this.myReplacement = replacement;
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            StringOperation.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public CharSequence getReplacement() {
        CharSequence charSequence = this.myReplacement;
        if (charSequence == null) {
            StringOperation.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        StringOperation operation = (StringOperation)o2;
        return this.myRange.equals(operation.myRange) && this.myReplacement.equals(operation.myReplacement);
    }

    public int hashCode() {
        return Objects.hash(this.myRange, this.myReplacement);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StringOperation replace(@NotNull TextRange range, @NotNull CharSequence replacement) {
        if (range == null) {
            StringOperation.$$$reportNull$$$0(4);
        }
        if (replacement == null) {
            StringOperation.$$$reportNull$$$0(5);
        }
        return new StringOperation(range, replacement);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static StringOperation replace(int startOffset, int endOffset, @NotNull CharSequence replacement) {
        if (replacement == null) {
            StringOperation.$$$reportNull$$$0(6);
        }
        return StringOperation.replace(TextRange.create(startOffset, endOffset), replacement);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StringOperation insert(int offset, @NotNull CharSequence replacement) {
        if (replacement == null) {
            StringOperation.$$$reportNull$$$0(7);
        }
        return StringOperation.replace(offset, offset, replacement);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static StringOperation remove(@NotNull TextRange range) {
        if (range == null) {
            StringOperation.$$$reportNull$$$0(8);
        }
        return StringOperation.replace(range, "");
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StringOperation remove(int startOffset, int endOffset) {
        return StringOperation.remove(TextRange.create(startOffset, endOffset));
    }

    @Contract(pure=true)
    @NotNull
    private static @NotNull List<@NotNull StringOperation> sort(@NotNull @NotNull Collection<@NotNull StringOperation> operations) {
        if (operations == null) {
            StringOperation.$$$reportNull$$$0(9);
        }
        ArrayList<StringOperation> sorted = new ArrayList<StringOperation>(operations);
        sorted.sort(ourComparator);
        ArrayList<StringOperation> arrayList = sorted;
        if (arrayList == null) {
            StringOperation.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence applyOperations(@NotNull CharSequence original, @NotNull @NotNull Collection<@NotNull StringOperation> operations) {
        if (original == null) {
            StringOperation.$$$reportNull$$$0(11);
        }
        if (operations == null) {
            StringOperation.$$$reportNull$$$0(12);
        }
        if (operations.isEmpty()) {
            CharSequence charSequence = original;
            if (charSequence == null) {
                StringOperation.$$$reportNull$$$0(13);
            }
            return charSequence;
        }
        List<StringOperation> sorted = StringOperation.sort(operations);
        StringBuilder result2 = new StringBuilder();
        int previousRangeEnd = 0;
        for (StringOperation operation : sorted) {
            TextRange range = operation.myRange;
            result2.append(original, previousRangeEnd, range.getStartOffset());
            result2.append(operation.myReplacement);
            previousRangeEnd = range.getEndOffset();
        }
        result2.append(original, previousRangeEnd, original.length());
        String string2 = result2.toString();
        if (string2 == null) {
            StringOperation.$$$reportNull$$$0(14);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/text/StringOperation";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/text/StringOperation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyOperations";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyOperations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

