/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.ObjectIntMap;
import ksp.com.intellij.util.containers.RefValueHashMapUtil;
import ksp.it.unimi.dsi.fastutil.objects.Object2IntMap;
import ksp.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import ksp.it.unimi.dsi.fastutil.objects.ObjectIterator;
import ksp.org.jetbrains.annotations.NotNull;

final class WeakKeyIntValueHashMap<K>
implements ObjectIntMap<K> {
    private final Object2IntMap<MyReference<K>> myMap = new Object2IntOpenHashMap<MyReference<K>>();
    private final ReferenceQueue<K> myQueue = new ReferenceQueue();
    private static final Object GCED = ObjectUtils.sentinel("GCED");

    WeakKeyIntValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            this.myMap.removeInt(ref);
        }
        return;
    }

    @Override
    public int get(@NotNull K key) {
        if (key == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(0);
        }
        MyReference ref = new MyReference(key, null);
        return this.myMap.getInt(ref);
    }

    @Override
    public int getOrDefault(@NotNull K key, int defaultValue) {
        if (key == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(1);
        }
        MyReference ref = new MyReference(key, null);
        return this.myMap.getOrDefault((Object)ref, defaultValue);
    }

    @Override
    public int put(@NotNull K key, int value2) {
        if (key == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(2);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, this.myQueue);
        return this.myMap.put(ref, value2);
    }

    @Override
    public int remove(@NotNull K key) {
        if (key == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(3);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, this.myQueue);
        return this.myMap.removeInt(ref);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull K key) {
        if (key == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(4);
        }
        MyReference ref = new MyReference(key, null);
        return this.myMap.containsKey(ref);
    }

    @Override
    public int @NotNull [] values() {
        throw new IncorrectOperationException("values() makes no sense for weak/soft key map because GC can clear the key any moment now");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        HashSet result2 = new HashSet(this.myMap.size());
        for (MyReference t2 : this.myMap.keySet()) {
            result2.add(SoftReference.dereference(t2));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Override
    public boolean containsValue(int value2) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Iterable<ObjectIntMap.Entry<K>> entries() {
        Iterable<ObjectIntMap.Entry<K>> iterable = () -> {
            Iterator tIterator = this.myMap.object2IntEntrySet().iterator();
            return ContainerUtil.filterIterator(new Iterator<ObjectIntMap.Entry<K>>(){
                final /* synthetic */ ObjectIterator val$tIterator;
                {
                    this.val$tIterator = objectIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$tIterator.hasNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectIntMap.Entry<K> next() {
                    final Object2IntMap.Entry entry = (Object2IntMap.Entry)this.val$tIterator.next();
                    return new ObjectIntMap.Entry<K>(){

                        @Override
                        @NotNull
                        public K getKey() {
                            Object v2 = SoftReference.dereference((Reference)entry.getKey());
                            Object object = v2 == null ? GCED : v2;
                            if (object == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return object;
                        }

                        @Override
                        public int getValue() {
                            return entry.getIntValue();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/util/containers/WeakKeyIntValueHashMap$1$1", "getKey"));
                        }
                    };
                }
            }, o2 -> o2.getKey() != GCED);
        };
        if (iterable == null) {
            WeakKeyIntValueHashMap.$$$reportNull$$$0(6);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/containers/WeakKeyIntValueHashMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/containers/WeakKeyIntValueHashMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "entries";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrDefault";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int myHashCode;

        private MyReference(@NotNull T key, ReferenceQueue<? super T> q2) {
            if (key == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            super(key, q2);
            this.myHashCode = key.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyReference)) {
                return false;
            }
            MyReference other = (MyReference)obj;
            Object myKey = this.get();
            Object otherKey = other.get();
            return obj == this || myKey != null && myKey.equals(otherKey);
        }

        public int hashCode() {
            return this.myHashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "ksp/com/intellij/util/containers/WeakKeyIntValueHashMap$MyReference", "<init>"));
        }
    }
}

