/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubElementTypeHolderEP;
import ksp.com.intellij.psi.stubs.StubFieldAccessor;
import ksp.com.intellij.psi.stubs.StubSerializer;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class IStubElementType<StubT extends StubElement<?>, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static final Set<String> NOT_INITIALIZED_SET = Collections.emptySet();
    private static volatile Set<String> lazyExternalIds = NOT_INITIALIZED_SET;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (!this.isLazilyRegistered()) {
            this.checkNotInstantiatedTooLateWithId(this.getClass());
        }
    }

    public static void checkNotInstantiatedTooLate(@NotNull Class<?> aClass) {
        if (aClass == null) {
            IStubElementType.$$$reportNull$$$0(1);
        }
        if (IStubElementType.isInitialized()) {
            Logger.getInstance(IStubElementType.class).error("All stub element types should be created before index initialization is complete.\nPlease add the " + aClass + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList());
        }
    }

    private void checkNotInstantiatedTooLateWithId(@NotNull Class<?> aClass) {
        if (aClass == null) {
            IStubElementType.$$$reportNull$$$0(2);
        }
        if (IStubElementType.isInitialized()) {
            Logger.getInstance(IStubElementType.class).error("All stub element types should be created before index initialization is complete.\nPlease add the " + aClass + " with external ID " + this.getExternalId() + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList() + "\nRegistered lazy ids: " + lazyExternalIds);
        }
    }

    private static boolean isInitialized() {
        return lazyExternalIds != NOT_INITIALIZED_SET;
    }

    private boolean isLazilyRegistered() {
        try {
            return lazyExternalIds.contains(this.getExternalId());
        }
        catch (Throwable e2) {
            return false;
        }
    }

    static void dropRegisteredTypes() {
        lazyExternalIds = NOT_INITIALIZED_SET;
    }

    @NotNull
    static List<StubFieldAccessor> loadRegisteredStubElementTypes() {
        ArrayList<StubFieldAccessor> result2 = new ArrayList<StubFieldAccessor>();
        ArrayList<String> debugStr = new ArrayList<String>();
        StubElementTypeHolderEP.EP_NAME.processWithPluginDescriptor((Function2<StubElementTypeHolderEP, PluginDescriptor, Unit>)((Function2)(bean, pluginDescriptor) -> {
            int accessorCount = bean.initializeOptimized((PluginDescriptor)pluginDescriptor, (List<? super StubFieldAccessor>)result2);
            debugStr.add(accessorCount + " in " + bean.holderClass);
            return Unit.INSTANCE;
        }));
        Logger.getInstance(IStubElementType.class).debug("Lazy stub element types loaded: " + StringUtil.join(debugStr, ", "));
        HashSet<String> lazyIds = new HashSet<String>(result2.size());
        for (StubFieldAccessor accessor : result2) {
            lazyIds.add(accessor.externalId);
        }
        lazyExternalIds = Collections.unmodifiableSet(lazyIds);
        ArrayList<StubFieldAccessor> arrayList = result2;
        if (arrayList == null) {
            IStubElementType.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement<? extends PsiElement> var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/stubs/IStubElementType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/stubs/IStubElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRegisteredStubElementTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkNotInstantiatedTooLate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNotInstantiatedTooLateWithId";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

