/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve;

import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.projectRoots.JavaSdkVersion;
import ksp.com.intellij.openapi.projectRoots.JavaVersionService;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.ConstraintType;
import ksp.com.intellij.psi.GenericsUtil;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiCapturedWildcardType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiEllipsisType;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiInferenceHelper;
import ksp.com.intellij.psi.PsiIntersectionType;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiResolveHelper;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiTypeParameterListOwner;
import ksp.com.intellij.psi.PsiTypes;
import ksp.com.intellij.psi.PsiWildcardType;
import ksp.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import ksp.com.intellij.psi.infos.MethodCandidateInfo;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.PsiTypesUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.ArrayUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiOldInferenceHelper
implements PsiInferenceHelper {
    private static final Logger LOG = Logger.getInstance(PsiOldInferenceHelper.class);
    public static final Pair<PsiType, ConstraintType> RAW_INFERENCE = new Pair<Object, ConstraintType>(null, ConstraintType.EQUALS);
    private final PsiManager myManager;
    private static final Pair<PsiType, ConstraintType> FAILED_INFERENCE = new Pair<PsiType, ConstraintType>(PsiTypes.nullType(), ConstraintType.EQUALS);

    public PsiOldInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(0);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(2);
        }
        if (parameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(3);
        }
        if (arguments2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(4);
        }
        PsiType[] paramTypes = PsiType.createArray(arguments2.length);
        PsiType[] argTypes = PsiType.createArray(arguments2.length);
        if (parameters2.length > 0) {
            for (int j2 = 0; j2 < argTypes.length; ++j2) {
                PsiExpression argument = arguments2[j2];
                if (argument == null || argument instanceof PsiMethodCallExpression && PsiResolveHelper.ourGuard.currentStack().contains(argument)) continue;
                argTypes[j2] = argument.getType();
                PsiParameter parameter2 = parameters2[Math.min(j2, parameters2.length - 1)];
                if (j2 >= parameters2.length && !parameter2.isVarArgs()) break;
                paramTypes[j2] = parameter2.getType();
                if (!(paramTypes[j2] instanceof PsiEllipsisType)) continue;
                paramTypes[j2] = ((PsiEllipsisType)paramTypes[j2]).getComponentType();
                if (arguments2.length != parameters2.length || !(argTypes[j2] instanceof PsiArrayType) || ((PsiArrayType)argTypes[j2]).getComponentType() instanceof PsiPrimitiveType) continue;
                argTypes[j2] = ((PsiArrayType)argTypes[j2]).getComponentType();
            }
        }
        return this.inferTypeForMethodTypeParameterInner(typeParameter, paramTypes, argTypes, partialSubstitutor, parent2, policy);
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, PsiType @NotNull [] paramTypes, PsiType @NotNull [] argTypes, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(5);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(6);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(7);
        }
        if (paramTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(8);
        }
        if (argTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(9);
        }
        PsiType wildcardToCapture = null;
        Pair<PsiType, ConstraintType> rawInference = null;
        PsiType lowerBound = PsiTypes.nullType();
        PsiType upperBound = PsiTypes.nullType();
        if (paramTypes.length > 0) {
            block5: for (int j2 = 0; j2 < argTypes.length; ++j2) {
                Pair<PsiType, ConstraintType> currentSubstitution;
                PsiType parameterType;
                PsiType argumentType = argTypes[j2];
                if (argumentType == null) continue;
                if (j2 >= paramTypes.length || (parameterType = paramTypes[j2]) == null) break;
                if (parameterType instanceof PsiEllipsisType) {
                    parameterType = ((PsiEllipsisType)parameterType).getComponentType();
                    if (argTypes.length == paramTypes.length && argumentType instanceof PsiArrayType && !(((PsiArrayType)argumentType).getComponentType() instanceof PsiPrimitiveType)) {
                        argumentType = ((PsiArrayType)argumentType).getComponentType();
                    }
                }
                if ((currentSubstitution = this.getSubstitutionForTypeParameterConstraint(typeParameter, parameterType, argumentType, true, PsiUtil.getLanguageLevel(typeParameter))) == null) continue;
                if (currentSubstitution == FAILED_INFERENCE) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                ConstraintType constraintType = currentSubstitution.getSecond();
                PsiType type2 = currentSubstitution.getFirst();
                if (type2 == null) {
                    rawInference = RAW_INFERENCE;
                    continue;
                }
                switch (constraintType) {
                    case EQUALS: {
                        if (!(type2 instanceof PsiWildcardType)) {
                            return currentSubstitution;
                        }
                        if (wildcardToCapture != null) {
                            return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                        }
                        wildcardToCapture = (PsiWildcardType)type2;
                        continue block5;
                    }
                    case SUPERTYPE: {
                        if (PsiTypes.nullType().equals(lowerBound)) {
                            lowerBound = type2;
                            continue block5;
                        }
                        if (lowerBound.equals(type2) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type2, this.myManager)) != null) continue block5;
                        return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                    }
                    case SUBTYPE: {
                        if (!PsiTypes.nullType().equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type2)) continue block5;
                        upperBound = type2;
                    }
                }
            }
        }
        if (wildcardToCapture != null) {
            if (lowerBound != PsiTypes.nullType()) {
                if (!wildcardToCapture.isAssignableFrom(lowerBound)) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                if (((PsiWildcardType)wildcardToCapture).isSuper()) {
                    return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.SUPERTYPE);
                }
                lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, wildcardToCapture, this.myManager);
            } else {
                if (upperBound != PsiTypes.nullType() && !upperBound.isAssignableFrom(wildcardToCapture)) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.EQUALS);
            }
        }
        if (rawInference != null) {
            return rawInference;
        }
        if (lowerBound != PsiTypes.nullType()) {
            return Pair.create(lowerBound, ConstraintType.EQUALS);
        }
        if (parent2 != null && (constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent2, policy)) != null) {
            if (constraint.getSecond() != ConstraintType.SUBTYPE) {
                return constraint;
            }
            if (upperBound != PsiTypes.nullType()) {
                return Pair.create(upperBound, ConstraintType.SUBTYPE);
            }
            return constraint;
        }
        if (upperBound != PsiTypes.nullType()) {
            return Pair.create(upperBound, ConstraintType.SUBTYPE);
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> getFailedInferenceConstraint(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(10);
        }
        return new Pair<PsiType, ConstraintType>(JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(typeParameter), ConstraintType.EQUALS);
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(11);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(12);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(13);
        }
        if (parameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(14);
        }
        if (arguments2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(15);
        }
        if ((constraint = this.inferTypeForMethodTypeParameterInner(typeParameter, parameters2, arguments2, partialSubstitutor, parent2, policy)) == null) {
            return PsiTypes.nullType();
        }
        return constraint.getFirst();
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @Nullable MethodCandidateInfo currentMethod, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        PsiType substitution;
        PsiTypeParameter typeParameter;
        int i2;
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(16);
        }
        if (parent2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(17);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(18);
        }
        if (languageLevel == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(19);
        }
        if (typeParameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(20);
        }
        if (parameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(21);
        }
        if (arguments2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(22);
        }
        PsiType[] substitutions = PsiType.createArray(typeParameters2.length);
        Pair[] constraints = new Pair[typeParameters2.length];
        for (i2 = 0; i2 < typeParameters2.length; ++i2) {
            Pair<PsiType, ConstraintType> constraint;
            if (substitutions[i2] != null) continue;
            constraints[i2] = constraint = this.inferTypeForMethodTypeParameterInner(typeParameters2[i2], parameters2, arguments2, partialSubstitutor, null, policy);
            if (constraint == null || constraint.getSecond() == ConstraintType.SUBTYPE) continue;
            substitutions[i2] = constraint.getFirst();
            if (substitutions[i2] == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameters2[i2], substitutions[i2]);
            i2 = -1;
        }
        for (i2 = 0; i2 < typeParameters2.length; ++i2) {
            typeParameter = typeParameters2[i2];
            if (substitutions[i2] != null) continue;
            PsiType substitutionFromBounds = PsiTypes.nullType();
            block2: for (int j2 = 0; j2 < typeParameters2.length; ++j2) {
                PsiClassType[] bounds2;
                if (i2 == j2) continue;
                PsiTypeParameter other = typeParameters2[j2];
                PsiType otherSubstitution = substitutions[j2];
                if (otherSubstitution == null) continue;
                for (PsiClassType bound : bounds2 = other.getExtendsListTypes()) {
                    PsiType substitutedBound = partialSubstitutor.substitute(bound);
                    Pair<PsiType, ConstraintType> currentConstraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                    if (currentConstraint == null) continue;
                    PsiType currentSubstitution = currentConstraint.getFirst();
                    ConstraintType currentConstraintType = currentConstraint.getSecond();
                    if (currentConstraintType == ConstraintType.EQUALS) {
                        substitutionFromBounds = currentSubstitution;
                        if (currentSubstitution != null) break block2;
                        constraints[i2] = FAILED_INFERENCE;
                        break block2;
                    }
                    if (currentConstraintType != ConstraintType.SUPERTYPE || JavaVersionService.getInstance().isAtLeast(parent2, JavaSdkVersion.JDK_1_7)) continue;
                    substitutionFromBounds = PsiTypes.nullType().equals(substitutionFromBounds) ? currentSubstitution : GenericsUtil.getLeastUpperBound(substitutionFromBounds, currentSubstitution, this.myManager);
                }
            }
            if (substitutionFromBounds == PsiTypes.nullType()) continue;
            substitutions[i2] = substitutionFromBounds;
        }
        for (i2 = 0; i2 < typeParameters2.length; ++i2) {
            typeParameter = typeParameters2[i2];
            substitution = substitutions[i2];
            if (substitution == PsiTypes.nullType()) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, substitution);
        }
        for (i2 = 0; i2 < typeParameters2.length; ++i2) {
            Pair<PsiType, ConstraintType> otherConstraint;
            typeParameter = typeParameters2[i2];
            substitution = substitutions[i2];
            if (substitution != null) continue;
            Pair<PsiType, ConstraintType> constraint = constraints[i2];
            if (constraint == null) {
                constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent2, policy);
            } else if (constraint.getSecond() == ConstraintType.SUBTYPE && (otherConstraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent2, policy)) != null && (otherConstraint.getSecond() == ConstraintType.EQUALS || otherConstraint.getSecond() == ConstraintType.SUPERTYPE || PsiOldInferenceHelper.compareSubtypes(constraint.getFirst(), otherConstraint.getFirst()))) {
                constraint = otherConstraint;
            }
            if (constraint != null) {
                substitution = constraint.getFirst();
            }
            if (substitution == null) {
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.myManager.getProject());
                PsiSubstitutor psiSubstitutor = factory2.createRawSubstitutor(partialSubstitutor, typeParameters2);
                if (psiSubstitutor == null) {
                    PsiOldInferenceHelper.$$$reportNull$$$0(23);
                }
                return psiSubstitutor;
            }
            if (substitution == PsiTypes.nullType()) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, substitution);
        }
        PsiSubstitutor psiSubstitutor = partialSubstitutor;
        if (psiSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(24);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(25);
        }
        if (typeParameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(26);
        }
        if (leftTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(27);
        }
        if (rightTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(28);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(typeParameters2, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
        if (psiSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(29);
        }
        return psiSubstitutor;
    }

    private static boolean compareSubtypes(PsiType type2, PsiType parentType) {
        return type2 != null && parentType != null && TypeConversionUtil.isAssignable(type2, parentType);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(30);
        }
        if (languageLevel == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(31);
        }
        if (typeParameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(32);
        }
        if (leftTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(33);
        }
        if (rightTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(34);
        }
        if (leftTypes.length != rightTypes.length) {
            throw new IllegalArgumentException("Types must be of the same length");
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : typeParameters2) {
            PsiType substitution = PsiTypes.nullType();
            PsiType lowerBound = PsiTypes.nullType();
            for (int i1 = 0; i1 < leftTypes.length; ++i1) {
                PsiType leftType = leftTypes[i1];
                PsiType rightType = rightTypes[i1];
                Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, leftType, rightType, true, languageLevel);
                if (constraint == null) continue;
                ConstraintType constraintType = constraint.getSecond();
                PsiType current = constraint.getFirst();
                if (constraintType == ConstraintType.EQUALS) {
                    substitution = current;
                    break;
                }
                if (constraintType == ConstraintType.SUBTYPE) {
                    if (PsiTypes.nullType().equals(substitution)) {
                        substitution = current;
                        continue;
                    }
                    substitution = GenericsUtil.getLeastUpperBound(substitution, current, this.myManager);
                    continue;
                }
                lowerBound = PsiTypes.nullType().equals(lowerBound) ? current : GenericsUtil.getLeastUpperBound(lowerBound, current, this.myManager);
            }
            if (PsiTypes.nullType().equals(substitution)) {
                substitution = lowerBound;
            }
            if (substitution == PsiTypes.nullType()) continue;
            substitutor2 = substitutor2.put(typeParameter, substitution);
        }
        for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
            PsiTypeParameter typeParameter = typeParameters2[i2];
            if (substitutor2.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType substitutionFromBounds = PsiTypes.nullType();
            block3: for (int j2 = 0; j2 < typeParameters2.length; ++j2) {
                PsiClassType[] bounds2;
                PsiTypeParameter other;
                PsiType otherSubstitution;
                if (i2 == j2 || (otherSubstitution = substitutor2.substitute(other = typeParameters2[j2])) == null) continue;
                for (PsiClassType bound : bounds2 = other.getExtendsListTypes()) {
                    PsiType substitutedBound = substitutor2.substitute(bound);
                    Pair<PsiType, ConstraintType> currentConstraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                    if (currentConstraint == null) continue;
                    PsiType currentSubstitution = currentConstraint.getFirst();
                    ConstraintType currentConstraintType = currentConstraint.getSecond();
                    if (currentConstraintType == ConstraintType.EQUALS) {
                        substitutionFromBounds = currentSubstitution;
                        break block3;
                    }
                    if (currentConstraintType != ConstraintType.SUPERTYPE) continue;
                    substitutionFromBounds = PsiTypes.nullType().equals(substitutionFromBounds) ? currentSubstitution : GenericsUtil.getLeastUpperBound(substitutionFromBounds, currentSubstitution, this.myManager);
                }
            }
            if (substitutionFromBounds == PsiTypes.nullType()) continue;
            substitutor2 = substitutor2.put(typeParameter, substitutionFromBounds);
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(35);
        }
        return psiSubstitutor;
    }

    @Nullable
    private static Pair<PsiType, ConstraintType> processArgType(PsiType arg, ConstraintType constraintType, boolean captureWildcard) {
        if (arg instanceof PsiWildcardType && !captureWildcard) {
            return FAILED_INFERENCE;
        }
        if (arg != PsiTypes.nullType()) {
            return Pair.create(arg, constraintType);
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(36);
        }
        if (substitutor2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(37);
        }
        if (parent2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(38);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(39);
        }
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        Pair<PsiType, ConstraintType> substitution = null;
        if (owner instanceof PsiMethod && parent2 instanceof PsiCallExpression) {
            PsiCallExpression methodCall = (PsiCallExpression)parent2;
            substitution = this.inferMethodTypeParameterFromParent(PsiUtil.skipParenthesizedExprUp(methodCall.getParent()), methodCall, typeParameter, substitutor2, policy);
        }
        return substitution;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParam, param, arg, isContraVariantPosition, languageLevel);
        return constraint == null ? (PsiPrimitiveType)PsiTypes.nullType() : constraint.getFirst();
    }

    @Nullable
    public Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterConstraint(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiClassType.ClassResolveResult paramResult;
        PsiClass paramClass;
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterConstraint(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return null;
        }
        if (arg instanceof PsiPrimitiveType) {
            if (!JavaVersionService.getInstance().isAtLeast(typeParam, JavaSdkVersion.JDK_1_7) && !isContraVariantPosition) {
                return null;
            }
            if ((arg = ((PsiPrimitiveType)arg).getBoxedType(typeParam)) == null) {
                return null;
            }
        }
        if (arg instanceof PsiCapturedWildcardType) {
            arg = ((PsiCapturedWildcardType)arg).getUpperBound();
        }
        if (typeParam == (paramClass = (PsiClass)(paramResult = ((PsiClassType)param).resolveGenerics()).getElement())) {
            PsiClass psiClass = PsiUtil.resolveClassInType(arg);
            if (arg == null || arg.getDeepComponentType() instanceof PsiPrimitiveType || arg instanceof PsiIntersectionType || psiClass != null && (isContraVariantPosition || !"java.lang.Object".equals(psiClass.getQualifiedName()) || arg instanceof PsiArrayType)) {
                PsiType bound = PsiOldInferenceHelper.intersectAllExtends(typeParam, arg);
                return Pair.create(bound, ConstraintType.SUPERTYPE);
            }
            if (psiClass == null && arg instanceof PsiClassType) {
                return Pair.create(arg, ConstraintType.EQUALS);
            }
            return null;
        }
        if (paramClass == null) {
            return null;
        }
        if (!(arg instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
        PsiClass argClass = (PsiClass)argResult.getElement();
        if (argClass == null) {
            return null;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.myManager.getProject());
        PsiClassType patternType = factory2.createType(typeParam);
        if (isContraVariantPosition) {
            PsiSubstitutor substitutor2 = TypeConversionUtil.getClassSubstitutor(paramClass, argClass, argResult.getSubstitutor());
            if (substitutor2 == null) {
                return null;
            }
            arg = factory2.createType(paramClass, substitutor2, languageLevel);
        } else {
            PsiSubstitutor substitutor3 = TypeConversionUtil.getClassSubstitutor(argClass, paramClass, paramResult.getSubstitutor());
            if (substitutor3 == null) {
                return null;
            }
            param = factory2.createType(argClass, substitutor3, languageLevel);
        }
        return this.getSubstitutionForTypeParameterInner(param, arg, patternType, ConstraintType.SUPERTYPE, 0);
    }

    private static PsiType intersectAllExtends(PsiTypeParameter typeParam, PsiType arg) {
        if (arg == null) {
            return null;
        }
        PsiClassType[] superTypes2 = typeParam.getSuperTypes();
        PsiType[] erasureTypes = PsiType.createArray(superTypes2.length);
        for (int i2 = 0; i2 < superTypes2.length; ++i2) {
            erasureTypes[i2] = TypeConversionUtil.erasure(superTypes2[i2]);
        }
        PsiType[] types2 = ArrayUtil.append(erasureTypes, arg, PsiType.class);
        assert (types2.length != 0);
        return PsiIntersectionType.createIntersection(types2);
    }

    @Nullable
    private Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterInner(PsiType param, PsiType arg, PsiType patternType, ConstraintType constraintType, int depth) {
        if (patternType.equals(param)) {
            return PsiOldInferenceHelper.processArgType(arg, constraintType, depth < 2);
        }
        if (arg instanceof PsiCapturedWildcardType && (depth < 2 || constraintType != ConstraintType.EQUALS || param instanceof PsiWildcardType)) {
            arg = ((PsiCapturedWildcardType)arg).getWildcard();
        }
        if (param instanceof PsiWildcardType) {
            PsiClassType.ClassResolveResult argResult;
            PsiClass argClass;
            PsiClassType.ClassResolveResult boundResult;
            PsiClass boundClass;
            Pair<PsiType, ConstraintType> res2;
            ConstraintType constrType;
            PsiWildcardType wildcardParam = (PsiWildcardType)param;
            PsiType paramBound = wildcardParam.getBound();
            if (paramBound == null) {
                return null;
            }
            ConstraintType constraintType2 = constrType = wildcardParam.isExtends() ? ConstraintType.SUPERTYPE : ConstraintType.SUBTYPE;
            if (arg instanceof PsiWildcardType) {
                if (((PsiWildcardType)arg).isExtends() == wildcardParam.isExtends() && ((PsiWildcardType)arg).isBounded() == wildcardParam.isBounded() && (res2 = this.getSubstitutionForTypeParameterInner(paramBound, ((PsiWildcardType)arg).getBound(), patternType, constrType, depth)) != null) {
                    return res2;
                }
            } else if (patternType.equals(paramBound)) {
                res2 = this.getSubstitutionForTypeParameterInner(paramBound, arg, patternType, constrType, depth);
                if (res2 != null) {
                    return res2;
                }
            } else if (paramBound instanceof PsiArrayType && arg instanceof PsiArrayType) {
                res2 = this.getSubstitutionForTypeParameterInner(((PsiArrayType)paramBound).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constrType, depth);
                if (res2 != null) {
                    return res2;
                }
            } else if (paramBound instanceof PsiClassType && arg instanceof PsiClassType && (boundClass = (boundResult = ((PsiClassType)paramBound).resolveGenerics()).getElement()) != null && (argClass = (argResult = ((PsiClassType)arg).resolveGenerics()).getElement()) != null) {
                Pair<PsiType, ConstraintType> res3;
                PsiType substituted;
                PsiSubstitutor superSubstitutor;
                if (wildcardParam.isExtends()) {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(boundClass, argClass, argResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(boundClass)) {
                            substituted = superSubstitutor.substitute(typeParameter);
                            if (substituted == null || (res3 = this.getSubstitutionForTypeParameterInner(boundResult.getSubstitutor().substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                            return res3;
                        }
                    }
                } else {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(argClass, boundClass, boundResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(argClass)) {
                            substituted = argResult.getSubstitutor().substitute(typeParameter);
                            if (substituted == null || (res3 = this.getSubstitutionForTypeParameterInner(superSubstitutor.substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null || res3 == FAILED_INFERENCE) continue;
                            return res3;
                        }
                    }
                }
            }
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterInner(((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constraintType, depth);
        }
        if (param instanceof PsiClassType && arg instanceof PsiClassType) {
            PsiClassType.ClassResolveResult paramResult = ((PsiClassType)param).resolveGenerics();
            PsiClass paramClass = paramResult.getElement();
            if (paramClass == null) {
                return null;
            }
            PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
            PsiClass argClass = argResult.getElement();
            if (!paramClass.isEquivalentTo(argClass)) {
                return null;
            }
            PsiType lowerBound = PsiTypes.nullType();
            PsiType upperBound = PsiTypes.nullType();
            Pair<PsiType, ConstraintType> wildcardCaptured = null;
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(paramClass)) {
                Pair<PsiType, ConstraintType> res4;
                PsiType paramType = paramResult.getSubstitutor().substitute(typeParameter);
                PsiType argType = argResult.getSubstitutor().substituteWithBoundsPromotion(typeParameter);
                if (wildcardCaptured != null) {
                    boolean alreadyFound = false;
                    for (PsiTypeParameter typeParam : PsiUtil.typeParametersIterable(paramClass)) {
                        if (typeParam == typeParameter || paramType == null || argResult.getSubstitutor().substituteWithBoundsPromotion(typeParam) != argType || !paramType.equals(paramResult.getSubstitutor().substitute(typeParam))) continue;
                        alreadyFound = true;
                    }
                    if (alreadyFound) continue;
                }
                if ((res4 = this.getSubstitutionForTypeParameterInner(paramType, argType, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                PsiType type2 = res4.getFirst();
                switch (res4.getSecond()) {
                    case EQUALS: {
                        if (!(type2 instanceof PsiWildcardType)) {
                            return res4;
                        }
                        if (wildcardCaptured != null) {
                            return FAILED_INFERENCE;
                        }
                        wildcardCaptured = res4;
                        break;
                    }
                    case SUPERTYPE: {
                        wildcardCaptured = res4;
                        if (PsiTypes.nullType().equals(lowerBound)) {
                            lowerBound = type2;
                            break;
                        }
                        if (lowerBound.equals(type2) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type2, this.myManager)) != null) break;
                        return FAILED_INFERENCE;
                    }
                    case SUBTYPE: {
                        wildcardCaptured = res4;
                        if (!PsiTypes.nullType().equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type2)) break;
                        upperBound = type2;
                    }
                }
            }
            if (lowerBound != PsiTypes.nullType()) {
                return Pair.create(lowerBound, ConstraintType.SUPERTYPE);
            }
            if (upperBound != PsiTypes.nullType()) {
                return Pair.create(upperBound, ConstraintType.SUBTYPE);
            }
            return wildcardCaptured;
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiElement parent2, @NotNull PsiExpression methodCall, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor2, @NotNull ParameterTypeInferencePolicy policy) {
        PsiElement pParent;
        if (parent2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(40);
        }
        if (methodCall == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(41);
        }
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(42);
        }
        if (substitutor2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(43);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(44);
        }
        Pair<PsiType, ConstraintType> constraint = null;
        PsiType expectedType = PsiTypesUtil.getExpectedTypeByParent(methodCall);
        if (expectedType == null && parent2 instanceof PsiExpressionList && (pParent = parent2.getParent()) instanceof PsiCallExpression && parent2.equals(((PsiCallExpression)pParent).getArgumentList())) {
            constraint = policy.inferTypeConstraintFromCallContext(methodCall, (PsiExpressionList)parent2, (PsiCallExpression)pParent, typeParameter);
        }
        GlobalSearchScope scope = parent2.getResolveScope();
        PsiType returnType2 = null;
        if (constraint == null) {
            PsiType guess;
            if (expectedType == null) {
                PsiType psiType = expectedType = methodCall instanceof PsiCallExpression ? policy.getDefaultExpectedType((PsiCallExpression)methodCall) : null;
            }
            if (policy.requestForBoxingExplicitly() && TypeConversionUtil.isPrimitiveAndNotNull(expectedType)) {
                expectedType = ((PsiPrimitiveType)expectedType).getBoxedType(typeParameter);
            }
            if ((constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, returnType2 = ((PsiMethod)typeParameter.getOwner()).getReturnType(), expectedType, false, PsiUtil.getLanguageLevel(parent2))) != null && (guess = constraint.getFirst()) != null && !guess.equals(PsiTypes.nullType()) && constraint.getSecond() == ConstraintType.SUPERTYPE && guess instanceof PsiIntersectionType && !JavaVersionService.getInstance().isAtLeast(parent2, JavaSdkVersion.JDK_1_7)) {
                for (PsiType conjuct : ((PsiIntersectionType)guess).getConjuncts()) {
                    if (conjuct.isAssignableFrom(expectedType)) continue;
                    return FAILED_INFERENCE;
                }
            }
        }
        PsiClassType[] superTypes2 = typeParameter.getSuperTypes();
        PsiType[] types2 = PsiType.createArray(superTypes2.length);
        for (int i2 = 0; i2 < superTypes2.length; ++i2) {
            PsiType superType = substitutor2.substitute(superTypes2[i2]);
            if (superType instanceof PsiClassType && ((PsiClassType)superType).isRaw()) {
                superType = TypeConversionUtil.erasure(superType);
            }
            if (superType == null) {
                superType = PsiType.getJavaLangObject(this.myManager, scope);
            }
            types2[i2] = superType;
        }
        if (constraint == null) {
            if (methodCall instanceof PsiCallExpression) {
                if (types2.length == 0) {
                    return null;
                }
                return policy.getInferredTypeWithNoConstraint(this.myManager, PsiIntersectionType.createIntersection(types2));
            }
            return null;
        }
        PsiType guess = constraint.getFirst();
        if (guess != null && types2.length > 0) {
            guess = GenericsUtil.getGreatestLowerBound(guess, PsiIntersectionType.createIntersection(types2));
        }
        guess = policy.adjustInferredType(this.myManager, guess, constraint.getSecond());
        if (returnType2 instanceof PsiClassType && typeParameter.equals(((PsiClassType)returnType2).resolve())) {
            PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
            PsiSubstitutor newSubstitutor = substitutor2.put(typeParameter, guess);
            for (PsiClassType extendsType1 : extendsTypes) {
                PsiType extendsType = newSubstitutor.substitute(extendsType1);
                if (guess == null || extendsType == null || extendsType.isAssignableFrom(guess)) continue;
                if (!guess.isAssignableFrom(extendsType)) break;
                guess = extendsType;
                newSubstitutor = substitutor2.put(typeParameter, guess);
            }
        }
        return Pair.create(guess, constraint.getSecond());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 16: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 18: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 3: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
            case 17: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypes";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypes";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameterInner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFailedInferenceConstraint";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameter";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodTypeParameterFromParent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

