/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import java.util.List;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.components.Service;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.SimpleModificationTracker;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileManager;
import ksp.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import ksp.com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import ksp.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import ksp.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import ksp.com.intellij.util.messages.MessageBusConnection;
import ksp.org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class PsiJavaModuleModificationTracker
extends SimpleModificationTracker
implements Disposable {
    public static PsiJavaModuleModificationTracker getInstance(Project project) {
        return project.getService(PsiJavaModuleModificationTracker.class);
    }

    public PsiJavaModuleModificationTracker(Project project) {
        MessageBusConnection connect2 = project.getMessageBus().connect(this);
        connect2.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null || (file2.isDirectory() || !PsiJavaModuleModificationTracker.isModuleFile(file2.getName())) && !(vFileEvent instanceof VFileDeleteEvent) && (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName()))) continue;
                    PsiJavaModuleModificationTracker.this.incModificationCount();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "ksp/com/intellij/psi/impl/PsiJavaModuleModificationTracker$1", "after"));
            }
        });
    }

    static boolean isModuleFile(String name2) {
        return "module-info.java".equals(name2) || "MANIFEST.MF".equalsIgnoreCase(name2);
    }

    @Override
    public void dispose() {
    }
}

