/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.ElementManipulator;
import ksp.com.intellij.psi.ElementManipulators;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiPolyVariantReference;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class PsiReferenceBase<T extends PsiElement>
implements PsiReference {
    private static final Logger LOG = Logger.getInstance(PsiReferenceBase.class);
    protected final T myElement;
    private TextRange myRangeInElement;
    protected boolean mySoft;

    public PsiReferenceBase(@NotNull T element2, TextRange rangeInElement, boolean soft) {
        if (element2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
        this.myRangeInElement = rangeInElement;
        this.mySoft = soft;
    }

    public PsiReferenceBase(@NotNull T element2, TextRange rangeInElement) {
        if (element2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(1);
        }
        this(element2);
        this.myRangeInElement = rangeInElement;
    }

    public PsiReferenceBase(@NotNull T element2, boolean soft) {
        if (element2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(2);
        }
        this.myElement = element2;
        this.mySoft = soft;
    }

    public PsiReferenceBase(@NotNull T element2) {
        if (element2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(3);
        }
        this.myElement = element2;
        this.mySoft = false;
    }

    public void setRangeInElement(TextRange rangeInElement) {
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    @NlsSafe
    public String getValue() {
        String string2;
        String text = this.myElement.getText();
        TextRange range = this.getRangeInElement();
        try {
            string2 = range.substring(text);
        }
        catch (StringIndexOutOfBoundsException e2) {
            LOG.error("Wrong range in reference " + this + ": " + range + ". Reference text: '" + text + "'", e2);
            String string3 = text;
            if (string3 == null) {
                PsiReferenceBase.$$$reportNull$$$0(5);
            }
            return string3;
        }
        if (string2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public T getElement() {
        T t2 = this.myElement;
        if (t2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(6);
        }
        return t2;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange rangeInElement = this.myRangeInElement;
        if (rangeInElement == null) {
            this.myRangeInElement = rangeInElement = this.calculateDefaultRangeInElement();
        }
        TextRange textRange = rangeInElement;
        if (textRange == null) {
            PsiReferenceBase.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return this.getManipulator().getRangeInElement(this.myElement);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getCanonicalText() {
        String string2 = this.getValue();
        if (string2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiReferenceBase.$$$reportNull$$$0(9);
        }
        return this.getManipulator().handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(10);
        }
        Class<?> aClass = this.getClass();
        throw new IncorrectOperationException("Rebind cannot be performed for " + aClass, (Throwable)PluginException.createByClass("", null, aClass));
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiReferenceBase.$$$reportNull$$$0(11);
        }
        return this.getElement().getManager().areElementsEquivalent(this.resolve(), element2);
    }

    @NotNull
    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element2, PsiElement resolveTo) {
        return new Immediate<T>(element2, true, resolveTo);
    }

    @NotNull
    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element2, TextRange rangeInElement, PsiElement resolveTo) {
        return new Immediate<T>(element2, rangeInElement, resolveTo);
    }

    @NotNull
    private ElementManipulator<T> getManipulator() {
        ElementManipulator<T> manipulator = ElementManipulators.getManipulator(this.myElement);
        if (manipulator == null) {
            throw PluginException.createByClass("No ElementManipulator instance registered for " + this.myElement + " [" + this.myElement.getClass() + "] in " + this + " [" + this.getClass() + "]", null, this.myElement.getClass());
        }
        ElementManipulator<T> elementManipulator = manipulator;
        if (elementManipulator == null) {
            PsiReferenceBase.$$$reportNull$$$0(12);
        }
        return elementManipulator;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.myElement + ":" + this.myRangeInElement + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/PsiReferenceBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/PsiReferenceBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Immediate<T extends PsiElement>
    extends PsiReferenceBase<T> {
        private final PsiElement myResolveTo;

        public Immediate(T element2, TextRange rangeInElement, boolean soft, PsiElement resolveTo) {
            super(element2, rangeInElement, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element2, TextRange rangeInElement, PsiElement resolveTo) {
            super(element2, rangeInElement);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element2, boolean soft, PsiElement resolveTo) {
            super(element2, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(@NotNull T element2, PsiElement resolveTo) {
            if (element2 == null) {
                Immediate.$$$reportNull$$$0(0);
            }
            super(element2);
            this.myResolveTo = resolveTo;
        }

        @Override
        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                Immediate.$$$reportNull$$$0(1);
            }
            return this.getElement();
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            return this.myResolveTo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/psi/PsiReferenceBase$Immediate";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleElementRename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Poly<T extends PsiElement>
    extends PsiReferenceBase<T>
    implements PsiPolyVariantReference {
        public Poly(T psiElement) {
            super(psiElement);
        }

        public Poly(T element2, boolean soft) {
            super(element2, soft);
        }

        public Poly(T element2, TextRange rangeInElement, boolean soft) {
            super(element2, rangeInElement, soft);
        }

        @Override
        public boolean isReferenceTo(@NotNull PsiElement element2) {
            ResolveResult[] results;
            if (element2 == null) {
                Poly.$$$reportNull$$$0(0);
            }
            for (ResolveResult result2 : results = this.multiResolve(false)) {
                if (!element2.getManager().areElementsEquivalent(result2.getElement(), element2)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "ksp/com/intellij/psi/PsiReferenceBase$Poly", "isReferenceTo"));
        }
    }
}

