/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import ksp.com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import ksp.com.intellij.ide.plugins.ModuleGraphBase;
import ksp.com.intellij.ide.plugins.ModuleGraphKt;
import ksp.com.intellij.ide.plugins.PluginContentDescriptor;
import ksp.com.intellij.ide.plugins.PluginDependency;
import ksp.com.intellij.ide.plugins.PluginLoadingResultKt;
import ksp.com.intellij.ide.plugins.PluginManagerCore;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.kotlinx.collections.immutable.ExtensionsKt;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002\u001a2\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002\u001aB\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00110\n2\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00130\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0000\u001a&\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00130\n2\u0006\u0010\u001a\u001a\u00020\bH\u0002\u001a\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"knownNotFullyMigratedPluginIds", "", "", "getKnownNotFullyMigratedPluginIds", "()Ljava/util/Set;", "collectDirectDependenciesInNewFormat", "", "module", "Lksp/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "idMap", "", "result", "", "collectDirectDependenciesInOldFormat", "rootDescriptor", "", "copySorted", "", "map", "", "comparator", "Ljava/util/Comparator;", "createModuleGraph", "Lksp/com/intellij/ide/plugins/ModuleGraphBase;", "plugins", "getImplicitDependency", "descriptor", "getOrEmpty", "toCoreAwareComparator", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nModuleGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleGraph.kt\ncom/intellij/ide/plugins/ModuleGraphKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1620#2,3:240\n1620#2,3:243\n*S KotlinDebug\n*F\n+ 1 ModuleGraph.kt\ncom/intellij/ide/plugins/ModuleGraphKt\n*L\n201#1:240,3\n208#1:243,3\n*E\n"})
public final class ModuleGraphKt {
    @NotNull
    private static final Set<String> knownNotFullyMigratedPluginIds;

    @NotNull
    public static final ModuleGraphBase createModuleGraph(@NotNull Collection<IdeaPluginDescriptorImpl> plugins) {
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        HashMap<String, IdeaPluginDescriptorImpl> moduleMap = new HashMap<String, IdeaPluginDescriptorImpl>(plugins.size() * 2);
        ArrayList<IdeaPluginDescriptorImpl> modules = new ArrayList<IdeaPluginDescriptorImpl>(moduleMap.size());
        for (IdeaPluginDescriptorImpl module2 : plugins) {
            moduleMap.put(module2.getPluginId().getIdString(), module2);
            for (PluginId pluginId : module2.modules) {
                moduleMap.put(pluginId.getIdString(), module2);
            }
            modules.add(module2);
            for (PluginContentDescriptor.ModuleItem moduleItem : module2.content.modules) {
                IdeaPluginDescriptorImpl subModule = moduleItem.requireDescriptor();
                modules.add(subModule);
                moduleMap.put(moduleItem.name, subModule);
            }
        }
        boolean hasAllModules = moduleMap.containsKey(PluginManagerCore.ALL_MODULES_MARKER.getIdString());
        Set<IdeaPluginDescriptorImpl> result2 = Collections.newSetFromMap(new IdentityHashMap());
        IdentityHashMap<IdeaPluginDescriptorImpl, List<IdeaPluginDescriptorImpl>> directDependencies = new IdentityHashMap<IdeaPluginDescriptorImpl, List<IdeaPluginDescriptorImpl>>(modules.size());
        for (IdeaPluginDescriptorImpl module3 : modules) {
            IdeaPluginDescriptorImpl implicitDep;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (hasAllModules) {
                Intrinsics.checkNotNull((Object)module3);
                ideaPluginDescriptorImpl = ModuleGraphKt.getImplicitDependency(module3, (Map<String, IdeaPluginDescriptorImpl>)moduleMap);
            } else {
                ideaPluginDescriptorImpl = implicitDep = null;
            }
            if (implicitDep != null) {
                if (module3 == implicitDep) {
                    PluginManagerCore.getLogger().error("Plugin " + module3 + " depends on self");
                } else {
                    result2.add(implicitDep);
                }
            }
            Intrinsics.checkNotNull((Object)module3);
            Map map = moduleMap;
            Intrinsics.checkNotNull(result2);
            ModuleGraphKt.collectDirectDependenciesInOldFormat(module3, map, result2);
            ModuleGraphKt.collectDirectDependenciesInNewFormat(module3, (Map<String, IdeaPluginDescriptorImpl>)moduleMap, (Collection<IdeaPluginDescriptorImpl>)result2);
            if (module3.moduleName != null && !Intrinsics.areEqual((Object)module3.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                boolean bl2;
                Object v2 = moduleMap.get(module3.getPluginId().getIdString());
                Intrinsics.checkNotNull(v2);
                IdeaPluginDescriptorImpl main2 = (IdeaPluginDescriptorImpl)v2;
                boolean bl3 = bl2 = main2 != module3;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                result2.add(main2);
            }
            if (result2.isEmpty()) continue;
            directDependencies.put(module3, ExtensionsKt.toPersistentList((Iterable)result2));
            result2.clear();
        }
        IdentityHashMap<IdeaPluginDescriptorImpl, ArrayList<IdeaPluginDescriptorImpl>> identityHashMap = new IdentityHashMap<IdeaPluginDescriptorImpl, ArrayList<IdeaPluginDescriptorImpl>>(modules.size());
        HashSet<AbstractMap.SimpleImmutableEntry<IdeaPluginDescriptorImpl, IdeaPluginDescriptorImpl>> edges = new HashSet<AbstractMap.SimpleImmutableEntry<IdeaPluginDescriptorImpl, IdeaPluginDescriptorImpl>>();
        for (IdeaPluginDescriptorImpl module4 : modules) {
            Map map = directDependencies;
            Intrinsics.checkNotNull((Object)module4);
            for (IdeaPluginDescriptorImpl inNode : ModuleGraphKt.getOrEmpty(map, module4)) {
                if (!edges.add(new AbstractMap.SimpleImmutableEntry<IdeaPluginDescriptorImpl, IdeaPluginDescriptorImpl>(inNode, module4))) continue;
                identityHashMap.computeIfAbsent(inNode, arg_0 -> ModuleGraphKt.createModuleGraph$lambda$0(createModuleGraph.1.INSTANCE, arg_0)).add(module4);
            }
        }
        return new ModuleGraphBase(modules, directDependencies, identityHashMap){};
    }

    private static final Comparator<IdeaPluginDescriptorImpl> toCoreAwareComparator(Comparator<IdeaPluginDescriptorImpl> comparator) {
        return (arg_0, arg_1) -> ModuleGraphKt.toCoreAwareComparator$lambda$1(comparator, arg_0, arg_1);
    }

    private static final Collection<IdeaPluginDescriptorImpl> getOrEmpty(Map<IdeaPluginDescriptorImpl, ? extends Collection<IdeaPluginDescriptorImpl>> map, IdeaPluginDescriptorImpl descriptor2) {
        List list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        return map.getOrDefault(descriptor2, list);
    }

    private static final Map<IdeaPluginDescriptorImpl, List<IdeaPluginDescriptorImpl>> copySorted(Map<IdeaPluginDescriptorImpl, ? extends Collection<IdeaPluginDescriptorImpl>> map, Comparator<IdeaPluginDescriptorImpl> comparator) {
        IdentityHashMap<IdeaPluginDescriptorImpl, List> result2 = new IdentityHashMap<IdeaPluginDescriptorImpl, List>(map.size());
        for (Map.Entry<IdeaPluginDescriptorImpl, ? extends Collection<IdeaPluginDescriptorImpl>> element2 : map.entrySet()) {
            result2.put(element2.getKey(), CollectionsKt.sortedWith((Iterable)element2.getValue(), comparator));
        }
        return result2;
    }

    private static final IdeaPluginDescriptorImpl getImplicitDependency(IdeaPluginDescriptorImpl descriptor2, Map<String, IdeaPluginDescriptorImpl> idMap) {
        if (descriptor2.isBundled() || descriptor2.packagePrefix != null || descriptor2.implementationDetail) {
            return null;
        }
        PluginId pluginId = descriptor2.getPluginId();
        if (Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)pluginId) || Intrinsics.areEqual((Object)PluginManagerCore.JAVA_PLUGIN_ID, (Object)pluginId) || PluginLoadingResultKt.hasModuleDependencies(descriptor2)) {
            return null;
        }
        return idMap.get(PluginManagerCore.JAVA_MODULE_ID.getIdString());
    }

    @NotNull
    public static final Set<String> getKnownNotFullyMigratedPluginIds() {
        return knownNotFullyMigratedPluginIds;
    }

    private static final void collectDirectDependenciesInOldFormat(IdeaPluginDescriptorImpl rootDescriptor, Map<String, IdeaPluginDescriptorImpl> idMap, Set<IdeaPluginDescriptorImpl> result2) {
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl it;
            PluginContentDescriptor.ModuleItem it2;
            Collection collection;
            boolean $i$f$mapTo;
            Iterable $this$mapTo$iv;
            IdeaPluginDescriptorImpl dep;
            if (idMap.get(dependency.getPluginId().getIdString()) == null) continue;
            if (!Intrinsics.areEqual((Object)dep.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                if (rootDescriptor == dep) {
                    if (!Intrinsics.areEqual((Object)rootDescriptor.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                        PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self (" + dependency + ')');
                    }
                } else {
                    $this$mapTo$iv = dep.content.modules;
                    $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        PluginContentDescriptor.ModuleItem moduleItem = (PluginContentDescriptor.ModuleItem)item$iv;
                        collection = result2;
                        boolean bl2 = false;
                        collection.add(it2.requireDescriptor());
                    }
                    result2.add(dep);
                }
            }
            if (knownNotFullyMigratedPluginIds.contains(rootDescriptor.getPluginId().getIdString())) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = idMap.get(PluginManagerCore.CORE_ID.getIdString());
                Intrinsics.checkNotNull((Object)ideaPluginDescriptorImpl);
                $this$mapTo$iv = ideaPluginDescriptorImpl.content.modules;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    it2 = (PluginContentDescriptor.ModuleItem)item$iv;
                    collection = result2;
                    boolean bl3 = false;
                    collection.add(it2.requireDescriptor());
                }
            }
            if (dependency.subDescriptor == null) continue;
            boolean bl4 = false;
            ModuleGraphKt.collectDirectDependenciesInOldFormat(it, idMap, result2);
        }
        for (PluginId moduleId : rootDescriptor.incompatibilities) {
            IdeaPluginDescriptorImpl it;
            if (idMap.get(moduleId.getIdString()) == null) continue;
            boolean bl5 = false;
            result2.add(it);
        }
    }

    private static final void collectDirectDependenciesInNewFormat(IdeaPluginDescriptorImpl module2, Map<String, IdeaPluginDescriptorImpl> idMap, Collection<IdeaPluginDescriptorImpl> result2) {
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module2.dependencies.modules) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(moduleReference.name);
            if (descriptor2 == null) continue;
            result2.add(descriptor2);
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : module2.dependencies.plugins) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(pluginReference.id.getIdString());
            if (descriptor2 == null || Intrinsics.areEqual((Object)descriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID)) continue;
            result2.add(descriptor2);
        }
    }

    private static final ArrayList createModuleGraph$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ArrayList)$tmp0.invoke(p0);
    }

    private static final int toCoreAwareComparator$lambda$1(Comparator $comparator, IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
        Intrinsics.checkNotNullParameter((Object)$comparator, (String)"$comparator");
        return o1.moduleName == null && Intrinsics.areEqual((Object)o1.getPluginId(), (Object)PluginManagerCore.CORE_ID) ? -1 : (o2.moduleName == null && Intrinsics.areEqual((Object)o2.getPluginId(), (Object)PluginManagerCore.CORE_ID) ? 1 : $comparator.compare(o1, o2));
    }

    public static final /* synthetic */ Collection access$getOrEmpty(Map map, IdeaPluginDescriptorImpl descriptor2) {
        return ModuleGraphKt.getOrEmpty(map, descriptor2);
    }

    public static final /* synthetic */ Comparator access$toCoreAwareComparator(Comparator comparator) {
        return ModuleGraphKt.toCoreAwareComparator(comparator);
    }

    public static final /* synthetic */ Map access$copySorted(Map map, Comparator comparator) {
        return ModuleGraphKt.copySorted(map, comparator);
    }

    static {
        Object[] objectArray = new String[]{"Pythonid", "com.jetbrains.pycharm.ds.customization"};
        knownNotFullyMigratedPluginIds = SetsKt.hashSetOf((Object[])objectArray);
    }
}

