/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.codeInsight.folding.impl;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.CodeDocumentationAwareCommenter;
import ksp.com.intellij.lang.Commenter;
import ksp.com.intellij.lang.LanguageCommenters;
import ksp.com.intellij.lang.folding.FoldingDescriptor;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiComment;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.TokenType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class CommentFoldingUtil {
    @Nullable
    public static FoldingDescriptor getCommentDescriptor(@NotNull PsiComment comment, @NotNull Document document, @NotNull Set<? super PsiElement> processedComments, @NotNull Predicate<? super PsiElement> isCustomRegionFunc, boolean isCollapse) {
        if (comment == null) {
            CommentFoldingUtil.$$$reportNull$$$0(0);
        }
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(1);
        }
        if (processedComments == null) {
            CommentFoldingUtil.$$$reportNull$$$0(2);
        }
        if (isCustomRegionFunc == null) {
            CommentFoldingUtil.$$$reportNull$$$0(3);
        }
        if (!processedComments.add(comment)) {
            return null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage());
        if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
            return null;
        }
        CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
        IElementType commentType = comment.getTokenType();
        TextRange commentRange = CommentFoldingUtil.getCommentRange(comment, processedComments, isCustomRegionFunc, docCommenter);
        if (commentRange == null) {
            return null;
        }
        String placeholder = CommentFoldingUtil.getCommentPlaceholder(document, commentType, commentRange);
        if (placeholder == null) {
            return null;
        }
        return new FoldingDescriptor(comment.getNode(), commentRange, null, placeholder, isCollapse, Collections.emptySet());
    }

    @Nullable
    private static TextRange getCommentRange(@NotNull PsiComment comment, @NotNull Set<? super PsiElement> processedComments, @NotNull Predicate<? super PsiElement> isCustomRegionFunc, @NotNull CodeDocumentationAwareCommenter docCommenter) {
        IElementType commentType;
        if (comment == null) {
            CommentFoldingUtil.$$$reportNull$$$0(4);
        }
        if (processedComments == null) {
            CommentFoldingUtil.$$$reportNull$$$0(5);
        }
        if (isCustomRegionFunc == null) {
            CommentFoldingUtil.$$$reportNull$$$0(6);
        }
        if (docCommenter == null) {
            CommentFoldingUtil.$$$reportNull$$$0(7);
        }
        if ((commentType = comment.getTokenType()) == docCommenter.getDocumentationCommentTokenType() || commentType == docCommenter.getBlockCommentTokenType()) {
            return comment.getTextRange();
        }
        if (commentType != docCommenter.getLineCommentTokenType()) {
            return null;
        }
        return CommentFoldingUtil.getOneLineCommentRange(comment, processedComments, isCustomRegionFunc, docCommenter);
    }

    @Nullable
    private static TextRange getOneLineCommentRange(@NotNull PsiComment startComment, @NotNull Set<? super PsiElement> processedComments, @NotNull Predicate<? super PsiElement> isCustomRegionFunc, @NotNull CodeDocumentationAwareCommenter docCommenter) {
        ASTNode node;
        if (startComment == null) {
            CommentFoldingUtil.$$$reportNull$$$0(8);
        }
        if (processedComments == null) {
            CommentFoldingUtil.$$$reportNull$$$0(9);
        }
        if (isCustomRegionFunc == null) {
            CommentFoldingUtil.$$$reportNull$$$0(10);
        }
        if (docCommenter == null) {
            CommentFoldingUtil.$$$reportNull$$$0(11);
        }
        if (isCustomRegionFunc.test(startComment)) {
            return null;
        }
        PsiElement end = null;
        for (PsiElement current = startComment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == docCommenter.getLineCommentTokenType() && !isCustomRegionFunc.test(current) && !processedComments.contains(current)) {
                end = current;
                processedComments.add(current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end == null) {
            return null;
        }
        return new TextRange(startComment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
    }

    @Nullable
    public static String getCommentPlaceholder(@NotNull Document document, @NotNull IElementType commentType, @NotNull TextRange commentRange) {
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(12);
        }
        if (commentType == null) {
            CommentFoldingUtil.$$$reportNull$$$0(13);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(14);
        }
        return CommentFoldingUtil.getCommentPlaceholder(document, commentType, commentRange, "...");
    }

    @Nullable
    public static String getCommentPlaceholder(@NotNull Document document, @NotNull IElementType commentType, @NotNull TextRange commentRange, @NotNull String replacement) {
        Commenter commenter;
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(15);
        }
        if (commentType == null) {
            CommentFoldingUtil.$$$reportNull$$$0(16);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(17);
        }
        if (replacement == null) {
            CommentFoldingUtil.$$$reportNull$$$0(18);
        }
        if (!((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(commentType.getLanguage())) instanceof CodeDocumentationAwareCommenter)) {
            return null;
        }
        CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
        String placeholder = commentType == docCommenter.getLineCommentTokenType() ? CommentFoldingUtil.getLineCommentPlaceholderText(commenter, replacement) : (commentType == docCommenter.getBlockCommentTokenType() ? CommentFoldingUtil.getMultilineCommentPlaceholderText(commenter, replacement) : (commentType == docCommenter.getDocumentationCommentTokenType() ? CommentFoldingUtil.getDocCommentPlaceholderText(document, docCommenter, commentRange, replacement) : null));
        return placeholder;
    }

    @Nullable
    private static String getDocCommentPlaceholderText(@NotNull Document document, @NotNull CodeDocumentationAwareCommenter commenter, @NotNull TextRange commentRange, @NotNull String replacement) {
        String fullText;
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(19);
        }
        if (commenter == null) {
            CommentFoldingUtil.$$$reportNull$$$0(20);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(21);
        }
        if (replacement == null) {
            CommentFoldingUtil.$$$reportNull$$$0(22);
        }
        String prefix = commenter.getDocumentationCommentPrefix();
        String suffix = commenter.getDocumentationCommentSuffix();
        String linePrefix = commenter.getDocumentationCommentLinePrefix();
        if (prefix == null || suffix == null || linePrefix == null) {
            return null;
        }
        String header = CommentFoldingUtil.getCommentHeader(document, suffix, prefix, linePrefix, commentRange);
        if (StringUtil.equalsIgnoreWhitespaces(header, fullText = CommentFoldingUtil.getCommentText(document, suffix, prefix, linePrefix, commentRange))) {
            replacement = "";
        }
        return CommentFoldingUtil.getCommentPlaceholder(prefix, suffix, header, replacement);
    }

    @Nullable
    private static String getMultilineCommentPlaceholderText(@NotNull Commenter commenter, @NotNull String replacement) {
        if (commenter == null) {
            CommentFoldingUtil.$$$reportNull$$$0(23);
        }
        if (replacement == null) {
            CommentFoldingUtil.$$$reportNull$$$0(24);
        }
        String prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return null;
        }
        return CommentFoldingUtil.getCommentPlaceholder(prefix, suffix, null, replacement);
    }

    @Nullable
    private static String getLineCommentPlaceholderText(@NotNull Commenter commenter, @NotNull String replacement) {
        String prefix;
        if (commenter == null) {
            CommentFoldingUtil.$$$reportNull$$$0(25);
        }
        if (replacement == null) {
            CommentFoldingUtil.$$$reportNull$$$0(26);
        }
        if ((prefix = commenter.getLineCommentPrefix()) == null) {
            return null;
        }
        return CommentFoldingUtil.getCommentPlaceholder(prefix, null, null, replacement);
    }

    @NotNull
    public static String getCommentPlaceholder(@NotNull String prefix, @Nullable String suffix, @Nullable String text, @NotNull String replacement) {
        if (prefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(27);
        }
        if (replacement == null) {
            CommentFoldingUtil.$$$reportNull$$$0(28);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (text != null && text.length() > 0) {
            sb.append(text);
            sb.append(" ");
        }
        sb.append(replacement);
        if (suffix != null) {
            sb.append(suffix);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            CommentFoldingUtil.$$$reportNull$$$0(29);
        }
        return string2;
    }

    @NotNull
    public static String getCommentHeader(@NotNull Document document, @NotNull String commentSuffix, @NotNull String commentPrefix, @NotNull String linePrefix, @NotNull TextRange commentRange) {
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(30);
        }
        if (commentSuffix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(31);
        }
        if (commentPrefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(32);
        }
        if (linePrefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(33);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(34);
        }
        int nFirstCommentLine = document.getLineNumber(commentRange.getStartOffset());
        for (int i2 = 0; i2 <= 1; ++i2) {
            String line = CommentFoldingUtil.getCommentLine(i2, nFirstCommentLine, document, commentSuffix, commentPrefix, linePrefix, commentRange);
            if (line == null) {
                return "";
            }
            if (!line.chars().anyMatch(c2 -> !StringUtil.isWhiteSpace((char)c2))) continue;
            String string2 = line;
            if (string2 == null) {
                CommentFoldingUtil.$$$reportNull$$$0(35);
            }
            return string2;
        }
        return "";
    }

    @NotNull
    public static String getCommentText(@NotNull Document document, @NotNull String commentSuffix, @NotNull String commentPrefix, @NotNull String linePrefix, @NotNull TextRange commentRange) {
        String line;
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(36);
        }
        if (commentSuffix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(37);
        }
        if (commentPrefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(38);
        }
        if (linePrefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(39);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(40);
        }
        StringBuilder sb = new StringBuilder();
        int nFirstCommentLine = document.getLineNumber(commentRange.getStartOffset());
        int i2 = 0;
        while ((line = CommentFoldingUtil.getCommentLine(i2, nFirstCommentLine, document, commentSuffix, commentPrefix, linePrefix, commentRange)) != null) {
            sb.append(line);
            ++i2;
        }
        String string2 = sb.toString();
        if (string2 == null) {
            CommentFoldingUtil.$$$reportNull$$$0(41);
        }
        return string2;
    }

    @NotNull
    @Contract(value="_, _ -> new")
    private static TextRange getLineRange(@NotNull Document document, int nLine) {
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(42);
        }
        int startOffset = document.getLineStartOffset(nLine);
        int endOffset = document.getLineEndOffset(nLine);
        return new TextRange(startOffset, endOffset);
    }

    @Nullable
    private static String getCommentLine(int lineOffset, int nFirstCommentLine, @NotNull Document document, @NotNull String commentSuffix, @NotNull String commentPrefix, @NotNull String linePrefix, @NotNull TextRange commentRange) {
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(43);
        }
        if (commentSuffix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(44);
        }
        if (commentPrefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(45);
        }
        if (linePrefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(46);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(47);
        }
        if (lineOffset == 0) {
            TextRange lineRange = CommentFoldingUtil.getLineRange(document, nFirstCommentLine);
            return CommentFoldingUtil.getCommentLine(document, lineRange, commentRange, commentPrefix, commentSuffix);
        }
        int nCommentLine = nFirstCommentLine + lineOffset;
        if (nCommentLine >= document.getLineCount()) {
            return null;
        }
        TextRange lineRange = CommentFoldingUtil.getLineRange(document, nCommentLine);
        if (lineRange.getEndOffset() > commentRange.getEndOffset()) {
            return null;
        }
        return CommentFoldingUtil.getCommentLine(document, lineRange, commentRange, linePrefix, commentSuffix);
    }

    @NotNull
    private static String getCommentLine(@NotNull Document document, @NotNull TextRange lineRange, @NotNull TextRange commentRange, @NotNull String prefix, @NotNull String suffix) {
        int prefixIdx;
        int endOffset;
        int startOffset;
        String commentPart;
        int suffixIdx;
        if (document == null) {
            CommentFoldingUtil.$$$reportNull$$$0(48);
        }
        if (lineRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(49);
        }
        if (commentRange == null) {
            CommentFoldingUtil.$$$reportNull$$$0(50);
        }
        if (prefix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(51);
        }
        if (suffix == null) {
            CommentFoldingUtil.$$$reportNull$$$0(52);
        }
        if ((suffixIdx = (commentPart = document.getText(new TextRange(startOffset = Math.max(lineRange.getStartOffset(), commentRange.getStartOffset()), endOffset = Math.min(lineRange.getEndOffset(), commentRange.getEndOffset())))).indexOf(suffix)) != -1) {
            commentPart = commentPart.substring(0, suffixIdx).trim();
        }
        if ((prefixIdx = commentPart.indexOf(prefix)) != -1) {
            commentPart = commentPart.substring(prefixIdx + prefix.length());
        }
        String string2 = commentPart;
        if (string2 == null) {
            CommentFoldingUtil.$$$reportNull$$$0(53);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 35: 
            case 41: 
            case 53: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 29: 
            case 35: 
            case 41: 
            case 53: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 19: 
            case 30: 
            case 36: 
            case 42: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedComments";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCustomRegionFunc";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docCommenter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startComment";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentType";
                break;
            }
            case 14: 
            case 17: 
            case 21: 
            case 34: 
            case 40: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentRange";
                break;
            }
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
            case 27: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: 
            case 35: 
            case 41: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/codeInsight/folding/impl/CommentFoldingUtil";
                break;
            }
            case 31: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentSuffix";
                break;
            }
            case 32: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentPrefix";
                break;
            }
            case 33: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineRange";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/codeInsight/folding/impl/CommentFoldingUtil";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentPlaceholder";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentHeader";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommentDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommentRange";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOneLineCommentRange";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPlaceholder";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentPlaceholderText";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMultilineCommentPlaceholderText";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentPlaceholderText";
                break;
            }
            case 29: 
            case 35: 
            case 41: 
            case 53: {
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCommentHeader";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLineRange";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getCommentLine";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 29: 
            case 35: 
            case 41: 
            case 53: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

