/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.fasterxml.aalto.in;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import ksp.com.fasterxml.aalto.WFCException;
import ksp.com.fasterxml.aalto.impl.ErrorConsts;
import ksp.com.fasterxml.aalto.impl.IoStreamException;
import ksp.com.fasterxml.aalto.impl.LocationImpl;
import ksp.com.fasterxml.aalto.in.AttributeCollector;
import ksp.com.fasterxml.aalto.in.ElementScope;
import ksp.com.fasterxml.aalto.in.FixedNsContext;
import ksp.com.fasterxml.aalto.in.NsBinding;
import ksp.com.fasterxml.aalto.in.NsDeclaration;
import ksp.com.fasterxml.aalto.in.PName;
import ksp.com.fasterxml.aalto.in.ReaderConfig;
import ksp.com.fasterxml.aalto.util.DataUtil;
import ksp.com.fasterxml.aalto.util.EmptyIterator;
import ksp.com.fasterxml.aalto.util.IllegalCharHandler;
import ksp.com.fasterxml.aalto.util.SingletonIterator;
import ksp.com.fasterxml.aalto.util.TextBuilder;
import ksp.com.fasterxml.aalto.util.XmlChars;
import ksp.com.fasterxml.aalto.util.XmlConsts;
import ksp.org.codehaus.stax2.XMLStreamLocation2;
import ksp.org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import ksp.org.codehaus.stax2.typed.Base64Variant;
import ksp.org.codehaus.stax2.typed.TypedArrayDecoder;
import ksp.org.codehaus.stax2.typed.TypedValueDecoder;
import ksp.org.codehaus.stax2.typed.TypedXMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XmlScanner
implements XmlConsts,
XMLStreamConstants,
NamespaceContext {
    protected final String CDATA_STR = "CDATA[";
    public static final int TOKEN_EOI = -1;
    protected static final int MAX_UNICODE_CHAR = 0x10FFFF;
    protected static final int INT_NULL = 0;
    protected static final int INT_CR = 13;
    protected static final int INT_LF = 10;
    protected static final int INT_TAB = 9;
    protected static final int INT_SPACE = 32;
    protected static final int INT_HYPHEN = 45;
    protected static final int INT_QMARK = 63;
    protected static final int INT_AMP = 38;
    protected static final int INT_LT = 60;
    protected static final int INT_GT = 62;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_APOS = 39;
    protected static final int INT_EXCL = 33;
    protected static final int INT_COLON = 58;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_SLASH = 47;
    protected static final int INT_EQ = 61;
    protected static final int INT_A = 65;
    protected static final int INT_F = 70;
    protected static final int INT_a = 97;
    protected static final int INT_f = 102;
    protected static final int INT_z = 122;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    private static final int BIND_MISSES_TO_ACTIVATE_CACHE = 10;
    private static final int BIND_CACHE_SIZE = 64;
    private static final int BIND_CACHE_MASK = 63;
    protected final ReaderConfig _config;
    protected final boolean _xml11;
    protected final boolean _cfgCoalescing;
    protected boolean _cfgLazyParsing;
    protected int _currToken = 7;
    protected boolean _tokenIncomplete = false;
    protected int _depth = 0;
    protected final TextBuilder _textBuilder;
    protected boolean _entityPending = false;
    protected char[] _nameBuffer = null;
    protected PName _tokenName = null;
    protected boolean _isEmptyTag = false;
    protected ElementScope _currElem;
    protected String _publicId;
    protected String _systemId;
    protected NsDeclaration _lastNsDecl = null;
    protected int _currNsCount = 0;
    protected NsBinding _defaultNs = NsBinding.createDefaultNs();
    protected NsBinding[] _nsBindings;
    protected int _nsBindingCount = 0;
    protected PName[] _nsBindingCache = null;
    protected int _nsBindMisses = 0;
    protected FixedNsContext _lastNsContext = FixedNsContext.EMPTY_CONTEXT;
    protected final AttributeCollector _attrCollector;
    protected int _attrCount = 0;
    protected long _pastBytesOrChars;
    protected int _currRow;
    protected int _rowStartOffset;
    protected long _startRawOffset;
    protected long _startRow = -1L;
    protected long _startColumn = -1L;

    protected XmlScanner(ReaderConfig cfg) {
        this._config = cfg;
        this._cfgCoalescing = cfg.willCoalesceText();
        this._cfgLazyParsing = cfg.willParseLazily();
        this._xml11 = cfg.isXml11();
        this._textBuilder = TextBuilder.createRecyclableBuffer(this._config);
        this._attrCollector = new AttributeCollector(cfg);
        this._nameBuffer = cfg.allocSmallCBuffer(60);
        this._currRow = 0;
    }

    public final void close(boolean forceCloseSource) throws XMLStreamException {
        this._releaseBuffers();
        if (forceCloseSource || this._config.willAutoCloseInput()) {
            try {
                this._closeSource();
            }
            catch (IOException ioe) {
                throw new IoStreamException(ioe);
            }
        }
    }

    protected void _releaseBuffers() {
        this._textBuilder.recycle(true);
        if (this._nameBuffer != null) {
            char[] buf = this._nameBuffer;
            this._nameBuffer = null;
            this._config.freeSmallCBuffer(buf);
        }
    }

    protected abstract void _closeSource() throws IOException;

    public ReaderConfig getConfig() {
        return this._config;
    }

    public AttributeCollector getAttrCollector() {
        return this._attrCollector;
    }

    public abstract int nextFromProlog(boolean var1) throws XMLStreamException;

    public abstract int nextFromTree() throws XMLStreamException;

    protected abstract void finishToken() throws XMLStreamException;

    protected final boolean skipToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.skipPI();
                break;
            }
            case 4: {
                if (this.skipCharacters()) {
                    this._currToken = 9;
                    return true;
                }
                if (!this._cfgCoalescing || !this.skipCoalescedText()) break;
                this._currToken = 9;
                return true;
            }
            case 5: {
                this.skipComment();
                break;
            }
            case 6: {
                this.skipSpace();
                break;
            }
            case 12: {
                this.skipCData();
                if (!this._cfgCoalescing) break;
                this.skipCoalescedText();
                if (!this._entityPending) break;
                this._currToken = 9;
                return true;
            }
            case 11: {
                this.finishDTD(false);
                break;
            }
            default: {
                throw new Error("Internal error, unexpected incomplete token type " + ErrorConsts.tokenTypeDesc(this._currToken));
            }
        }
        return false;
    }

    public abstract XMLStreamLocation2 getCurrentLocation();

    public final XMLStreamLocation2 getStartLocation() {
        int row = (int)this._startRow;
        int col = (int)this._startColumn;
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._startRawOffset, row, col);
    }

    public abstract long getStartingByteOffset();

    public abstract long getStartingCharOffset();

    public abstract long getEndingByteOffset() throws XMLStreamException;

    public abstract long getEndingCharOffset() throws XMLStreamException;

    public XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this.getCurrentLocation();
    }

    public final int getCurrentLineNr() {
        return this._currRow + 1;
    }

    public abstract int getCurrentColumnNr();

    public final String getInputSystemId() {
        return this._config.getSystemId();
    }

    public final String getInputPublicId() {
        return this._config.getPublicId();
    }

    public final boolean hasEmptyStack() {
        return this._depth == 0;
    }

    public final int getDepth() {
        return this._depth;
    }

    public final boolean isEmptyTag() {
        return this._isEmptyTag;
    }

    public final PName getName() {
        return this._tokenName;
    }

    public final QName getQName() {
        return this._tokenName.constructQName(this._defaultNs);
    }

    public final String getDTDPublicId() {
        return this._publicId;
    }

    public final String getDTDSystemId() {
        return this._systemId;
    }

    public final String getText() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsAsString();
    }

    public final int getTextLength() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.size();
    }

    public final char[] getTextCharacters() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.getTextBuffer();
    }

    public final int getTextCharacters(int srcStart, char[] target, int targetStart, int len) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsToArray(srcStart, target, targetStart, len);
    }

    public final int getText(Writer w2, boolean preserveContents) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        try {
            return this._textBuilder.rawContentsTo(w2);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    public final boolean isTextWhitespace() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.isAllWhitespace();
    }

    public final int decodeElements(TypedArrayDecoder tad, boolean reset) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        try {
            return this._textBuilder.decodeElements(tad, reset);
        }
        catch (TypedXMLStreamException tex) {
            XMLStreamLocation2 loc = this.getCurrentLocation();
            String lexical = tex.getLexical();
            IllegalArgumentException iae = (IllegalArgumentException)tex.getCause();
            throw new TypedXMLStreamException(lexical, tex.getMessage(), loc, iae);
        }
    }

    public final void resetForDecoding(Base64Variant v2, CharArrayBase64Decoder dec, boolean firstChunk) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        this._textBuilder.resetForBinaryDecode(v2, dec, firstChunk);
    }

    public void fireSaxStartElement(ContentHandler h2, Attributes attrs) throws SAXException {
        if (h2 != null) {
            String uri;
            int level = this._depth - 1;
            for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null && nsDecl.getLevel() == level; nsDecl = nsDecl.getPrev()) {
                String prefix = nsDecl.getPrefix();
                uri = nsDecl.getCurrNsURI();
                h2.startPrefixMapping(prefix == null ? "" : prefix, uri);
            }
            PName n2 = this.getName();
            uri = n2.getNsUri();
            h2.startElement(uri == null ? "" : uri, n2.getLocalName(), n2.getPrefixedName(), attrs);
        }
    }

    public void fireSaxEndElement(ContentHandler h2) throws SAXException {
        if (h2 != null) {
            PName n2 = this.getName();
            String uri = n2.getNsUri();
            h2.endElement(uri == null ? "" : uri, n2.getLocalName(), n2.getPrefixedName());
            int level = this._depth;
            for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null && nsDecl.getLevel() == level; nsDecl = nsDecl.getPrev()) {
                String prefix = nsDecl.getPrefix();
                h2.endPrefixMapping(prefix == null ? "" : prefix);
            }
        }
    }

    public void fireSaxCharacterEvents(ContentHandler h2) throws XMLStreamException, SAXException {
        if (h2 != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxCharacterEvents(h2);
        }
    }

    public void fireSaxSpaceEvents(ContentHandler h2) throws XMLStreamException, SAXException {
        if (h2 != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxSpaceEvents(h2);
        }
    }

    public void fireSaxCommentEvent(LexicalHandler h2) throws XMLStreamException, SAXException {
        if (h2 != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxCommentEvent(h2);
        }
    }

    public void fireSaxPIEvent(ContentHandler h2) throws XMLStreamException, SAXException {
        if (h2 != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            h2.processingInstruction(this._tokenName.getLocalName(), this.getText());
        }
    }

    public final int getAttrCount() {
        return this._attrCount;
    }

    public final String getAttrLocalName(int index2) {
        return this._attrCollector.getName(index2).getLocalName();
    }

    public final QName getAttrQName(int index2) {
        return this._attrCollector.getQName(index2);
    }

    public final String getAttrPrefixedName(int index2) {
        return this._attrCollector.getName(index2).getPrefixedName();
    }

    public final String getAttrNsURI(int index2) {
        return this._attrCollector.getName(index2).getNsUri();
    }

    public final String getAttrPrefix(int index2) {
        return this._attrCollector.getName(index2).getPrefix();
    }

    public final String getAttrValue(int index2) {
        return this._attrCollector.getValue(index2);
    }

    public final String getAttrValue(String nsURI, String localName) {
        if (this._attrCount < 1) {
            return null;
        }
        return this._attrCollector.getValue(nsURI, localName);
    }

    public final void decodeAttrValue(int index2, TypedValueDecoder tvd) throws XMLStreamException {
        this._attrCollector.decodeValue(index2, tvd);
    }

    public final int decodeAttrValues(int index2, TypedArrayDecoder tad) throws XMLStreamException {
        return this._attrCollector.decodeValues(index2, tad, this);
    }

    public final byte[] decodeAttrBinaryValue(int index2, Base64Variant v2, CharArrayBase64Decoder dec) throws XMLStreamException {
        return this._attrCollector.decodeBinaryValue(index2, v2, dec, this);
    }

    public final int findAttrIndex(String nsURI, String localName) {
        if (this._attrCount < 1) {
            return -1;
        }
        return this._attrCollector.findIndex(nsURI, localName);
    }

    public final String getAttrType(int index2) {
        return "CDATA";
    }

    public final boolean isAttrSpecified(int index2) {
        return true;
    }

    public final int getNsCount() {
        if (this._currToken == 1) {
            return this._currNsCount;
        }
        return this._lastNsDecl == null ? 0 : this._lastNsDecl.countDeclsOnLevel(this._depth);
    }

    public final String getNamespacePrefix(int index2) {
        return this.findCurrNsDecl((int)index2).getBinding().mPrefix;
    }

    public final String getNamespaceURI(int index2) {
        return this.findCurrNsDecl((int)index2).getBinding().mURI;
    }

    private NsDeclaration findCurrNsDecl(int index2) {
        int count;
        NsDeclaration nsDecl = this._lastNsDecl;
        int level = this._depth;
        if (this._currToken == 1) {
            count = this._currNsCount - 1 - index2;
            --level;
        } else {
            count = index2;
        }
        while (nsDecl != null && nsDecl.getLevel() == level) {
            if (count == 0) {
                return nsDecl;
            }
            --count;
            nsDecl = nsDecl.getPrev();
        }
        this.reportInvalidNsIndex(index2);
        return null;
    }

    public final String getNamespaceURI() {
        String uri = this._tokenName.getNsUri();
        return uri == null ? this._defaultNs.mURI : uri;
    }

    public final NamespaceContext getNonTransientNamespaceContext() {
        this._lastNsContext = this._lastNsContext.reuseOrCreate(this._lastNsDecl);
        return this._lastNsContext;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (prefix.length() == 0) {
            String uri = this._defaultNs.mURI;
            return uri == null ? "" : uri;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            if (!nsDecl.hasPrefix(prefix)) continue;
            return nsDecl.getCurrNsURI();
        }
        return null;
    }

    @Override
    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (nsURI.equals(this._defaultNs.mURI)) {
            return "";
        }
        block0: for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            String prefix;
            if (!nsDecl.hasNsURI(nsURI) || (prefix = nsDecl.getPrefix()) == null) continue;
            for (NsDeclaration decl2 = this._lastNsDecl; decl2 != nsDecl; decl2 = decl2.getPrev()) {
                if (decl2.hasPrefix(prefix)) continue block0;
            }
            return prefix;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return new SingletonIterator("xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return new SingletonIterator("xmlns");
        }
        ArrayList<String> l2 = null;
        if (nsURI.equals(this._defaultNs.mURI)) {
            l2 = new ArrayList<String>();
            l2.add("");
        }
        block0: for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            String prefix;
            if (!nsDecl.hasNsURI(nsURI) || (prefix = nsDecl.getPrefix()) == null) continue;
            for (NsDeclaration decl2 = this._lastNsDecl; decl2 != nsDecl; decl2 = decl2.getPrev()) {
                if (decl2.hasPrefix(prefix)) continue block0;
            }
            if (l2 == null) {
                l2 = new ArrayList();
            }
            l2.add(prefix);
        }
        if (l2 == null) {
            return EmptyIterator.getInstance();
        }
        if (l2.size() == 1) {
            return new SingletonIterator((String)l2.get(0));
        }
        return l2.iterator();
    }

    protected abstract void finishCharacters() throws XMLStreamException;

    protected abstract void finishCData() throws XMLStreamException;

    protected abstract void finishComment() throws XMLStreamException;

    protected abstract void finishDTD(boolean var1) throws XMLStreamException;

    protected abstract void finishPI() throws XMLStreamException;

    protected abstract void finishSpace() throws XMLStreamException;

    protected abstract boolean skipCharacters() throws XMLStreamException;

    protected abstract void skipCData() throws XMLStreamException;

    protected abstract void skipComment() throws XMLStreamException;

    protected abstract void skipPI() throws XMLStreamException;

    protected abstract void skipSpace() throws XMLStreamException;

    protected abstract boolean skipCoalescedText() throws XMLStreamException;

    protected abstract boolean loadMore() throws XMLStreamException;

    protected final PName bindName(PName name2, String prefix) {
        PName cn;
        if (this._nsBindingCache != null && (cn = this._nsBindingCache[name2.unboundHashCode() & 0x3F]) != null && cn.unboundEquals(name2)) {
            return cn;
        }
        int len = this._nsBindingCount;
        for (int i2 = 0; i2 < len; ++i2) {
            NsBinding b2 = this._nsBindings[i2];
            if (b2.mPrefix != prefix) continue;
            if (i2 > 0) {
                this._nsBindings[i2] = this._nsBindings[i2 - 1];
                this._nsBindings[i2 - 1] = b2;
            }
            PName bn = name2.createBoundName(b2);
            if (this._nsBindingCache == null) {
                if (++this._nsBindMisses < 10) {
                    return bn;
                }
                this._nsBindingCache = new PName[64];
            }
            this._nsBindingCache[bn.unboundHashCode() & 0x3F] = bn;
            return bn;
        }
        if (prefix == "xml") {
            return name2.createBoundName(NsBinding.XML_BINDING);
        }
        ++this._nsBindMisses;
        NsBinding b3 = new NsBinding(prefix);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = b3;
        ++this._nsBindingCount;
        return name2.createBoundName(b3);
    }

    protected final NsBinding findOrCreateBinding(String prefix) throws XMLStreamException {
        int len = this._nsBindingCount;
        for (int i2 = 0; i2 < len; ++i2) {
            NsBinding b2 = this._nsBindings[i2];
            if (b2.mPrefix != prefix) continue;
            if (i2 > 0) {
                this._nsBindings[i2] = this._nsBindings[i2 - 1];
                this._nsBindings[i2 - 1] = b2;
            }
            return b2;
        }
        if (prefix == "xml") {
            return NsBinding.XML_BINDING;
        }
        if (prefix == "xmlns") {
            return NsBinding.XMLNS_BINDING;
        }
        NsBinding b3 = new NsBinding(prefix);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = b3;
        ++this._nsBindingCount;
        return b3;
    }

    protected final void bindNs(PName name2, String uri) throws XMLStreamException {
        NsBinding ns;
        String prefix = name2.getPrefix();
        if (prefix == null) {
            ns = this._defaultNs;
        } else {
            prefix = name2.getLocalName();
            ns = this.findOrCreateBinding(prefix);
            if (ns.isImmutable()) {
                this.checkImmutableBinding(prefix, uri);
            }
        }
        if (!ns.isImmutable()) {
            if (uri == "http://www.w3.org/XML/1998/namespace") {
                this.reportIllegalNsDecl("xml", "http://www.w3.org/XML/1998/namespace");
            } else if (uri == "http://www.w3.org/2000/xmlns/") {
                this.reportIllegalNsDecl("xmlns", "http://www.w3.org/2000/xmlns/");
            }
        }
        if (this._lastNsDecl != null && this._lastNsDecl.alreadyDeclared(prefix, this._depth)) {
            this.reportDuplicateNsDecl(prefix);
        }
        this._lastNsDecl = new NsDeclaration(ns, uri, this._lastNsDecl, this._depth);
    }

    protected final void checkImmutableBinding(String prefix, String uri) throws XMLStreamException {
        if (prefix != "xml" || !uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.reportIllegalNsDecl(prefix);
        }
    }

    protected final void loadMoreGuaranteed() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
    }

    protected final void loadMoreGuaranteed(int tt) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(tt));
        }
    }

    protected final void verifyXmlChar(int value2) throws XMLStreamException {
        if (value2 >= 55296) {
            if (value2 < 57344) {
                this.reportInvalidXmlChar(value2);
            }
            if (value2 == 65534 || value2 == 65535) {
                this.reportInvalidXmlChar(value2);
            }
        } else if (!(value2 >= 32 || value2 == 10 || value2 == 13 || value2 == 9 || this._xml11 && value2 != 0)) {
            this.reportInvalidXmlChar(value2);
        }
    }

    protected void reportInputProblem(String msg) throws XMLStreamException {
        throw new WFCException(msg, this.getCurrentLocation());
    }

    protected void reportUnexpandedEntityInAttr(PName name2, boolean isNsDecl) throws XMLStreamException {
        this.reportInputProblem("Unexpanded ENTITY_REFERENCE (" + this._tokenName + ") in " + (isNsDecl ? "namespace declaration" : "attribute value"));
    }

    protected void reportPrologUnexpElement(boolean isProlog, int ch) throws XMLStreamException {
        if (ch < 0) {
            ch &= 0x7FFFF;
        }
        if (ch == 47) {
            if (isProlog) {
                this.reportInputProblem("Unexpected end element in prolog: malformed XML document, expected root element");
            }
            this.reportInputProblem("Unexpected end element in epilog: malformed XML document (unbalanced start/end tags?)");
        }
        if (ch < 32) {
            String type2 = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
            this.throwUnexpectedChar(ch, "Unrecognized directive " + type2);
        }
        this.reportInputProblem("Second root element in content: malformed XML document, only one allowed");
    }

    protected void reportPrologUnexpChar(boolean isProlog, int ch, String msg) throws XMLStreamException {
        String fullMsg;
        String string2 = fullMsg = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        if (msg == null) {
            if (ch == 38) {
                this.throwUnexpectedChar(ch, fullMsg + "; no entities allowed");
            }
        } else {
            fullMsg = fullMsg + msg;
        }
        this.throwUnexpectedChar(ch, fullMsg);
    }

    protected void reportPrologProblem(boolean isProlog, String msg) throws XMLStreamException {
        String prefix = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        this.reportInputProblem(prefix + ": " + msg);
    }

    protected void reportTreeUnexpChar(int ch, String msg) throws XMLStreamException {
        String fullMsg = ErrorConsts.SUFFIX_IN_TREE;
        if (msg != null) {
            fullMsg = fullMsg + msg;
        }
        this.throwUnexpectedChar(ch, fullMsg);
    }

    protected void reportInvalidNameChar(int ch, int index2) throws XMLStreamException {
        if (ch == 58) {
            this.reportInputProblem("Invalid colon in name: at most one colon allowed in element/attribute names, and none in PI target or entity names");
        }
        if (index2 == 0) {
            this.reportInputProblem("Invalid name start character (0x" + Integer.toHexString(ch) + ")");
        }
        this.reportInputProblem("Invalid name character (0x" + Integer.toHexString(ch) + ")");
    }

    protected void reportInvalidXmlChar(int ch) throws XMLStreamException {
        if (ch == 0) {
            this.reportInputProblem("Invalid null character");
        }
        if (ch < 32) {
            this.reportInputProblem("Invalid white space character (0x" + Integer.toHexString(ch) + ")");
        }
        this.reportInputProblem("Invalid xml content character (0x" + Integer.toHexString(ch) + ")");
    }

    protected void reportEofInName(char[] cbuf, int clen) throws XMLStreamException {
        this.reportInputProblem("Unexpected end-of-input in name (parsing " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    protected void reportMissingPISpace(int ch) throws XMLStreamException {
        this.throwUnexpectedChar(ch, ": expected either white space, or closing '?>'");
    }

    protected void reportDoubleHyphenInComments() throws XMLStreamException {
        this.reportInputProblem("String '--' not allowed in comment (missing '>'?)");
    }

    protected void reportMultipleColonsInName() throws XMLStreamException {
        this.reportInputProblem("Multiple colons not allowed in names");
    }

    protected void reportEntityOverflow() throws XMLStreamException {
        this.reportInputProblem("Illegal character entity: value higher than max allowed (0x" + Integer.toHexString(0x10FFFF) + ")");
    }

    protected void reportInvalidNsIndex(int index2) {
        throw new IndexOutOfBoundsException("Illegal namespace declaration index, " + index2 + ", current START_ELEMENT/END_ELEMENT has " + this.getNsCount() + " declarations");
    }

    protected void reportUnboundPrefix(PName name2, boolean isAttr) throws XMLStreamException {
        this.reportInputProblem("Unbound namespace prefix '" + name2.getPrefix() + "' (for " + (isAttr ? "attribute" : "element") + " name '" + name2.getPrefixedName() + "')");
    }

    protected void reportDuplicateNsDecl(String prefix) throws XMLStreamException {
        if (prefix == null) {
            this.reportInputProblem("Duplicate namespace declaration for the default namespace");
        } else {
            this.reportInputProblem("Duplicate namespace declaration for prefix '" + prefix + "'");
        }
    }

    protected void reportIllegalNsDecl(String prefix) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not re-bind prefix '" + prefix + "'");
    }

    protected void reportIllegalNsDecl(String prefix, String uri) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not bind URI '" + uri + "' to prefix other than '" + prefix + "'");
    }

    protected void reportUnexpectedEndTag(String expName) throws XMLStreamException {
        this.reportInputProblem("Unexpected end tag: expected </" + expName + ">");
    }

    protected void reportIllegalCDataEnd() throws XMLStreamException {
        this.reportInputProblem("String ']]>' not allowed in textual content, except as the end marker of CDATA section");
    }

    protected void throwUnexpectedChar(int i2, String msg) throws XMLStreamException {
        if (i2 < 32 && i2 != 13 && i2 != 10 && i2 != 9) {
            this.throwInvalidSpace(i2);
        }
        char c2 = (char)i2;
        String excMsg = "Unexpected character " + XmlChars.getCharDesc(c2) + msg;
        this.reportInputProblem(excMsg);
    }

    protected void throwNullChar() throws XMLStreamException {
        this.reportInputProblem("Illegal character (NULL, unicode 0) encountered: not valid in any content");
    }

    protected char handleInvalidXmlChar(int i2) throws XMLStreamException {
        IllegalCharHandler iHandler = this._config.getIllegalCharHandler();
        if (iHandler != null) {
            return iHandler.convertIllegalChar(i2);
        }
        char c2 = (char)i2;
        if (c2 == '\u0000') {
            this.throwNullChar();
        }
        String msg = "Illegal XML character (" + XmlChars.getCharDesc(c2) + ")";
        if (this._xml11 && i2 < 32) {
            msg = msg + " [note: in XML 1.1, it could be included via entity expansion]";
        }
        this.reportInputProblem(msg);
        return (char)i2;
    }

    protected void throwInvalidSpace(int i2) throws XMLStreamException {
        char c2 = (char)i2;
        if (c2 == '\u0000') {
            this.throwNullChar();
        }
        String msg = "Illegal character (" + XmlChars.getCharDesc(c2) + ")";
        if (this._xml11 && i2 < 32) {
            msg = msg + " [note: in XML 1.1, it could be included via entity expansion]";
        }
        this.reportInputProblem(msg);
    }
}

