/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.standalone;

import com.google.devtools.ksp.standalone.IncrementalGlobalSearchScope;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.mock.MockProject;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import ksp.org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import ksp.org.jetbrains.kotlin.analysis.project.structure.impl.KaSourceModuleImpl;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import ksp.org.jetbrains.kotlin.config.ApiVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import ksp.org.jetbrains.kotlin.platform.TargetPlatform;

@KtModuleBuilderDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u0014\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0006H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/google/devtools/ksp/standalone/KspModuleBuilder;", "Lksp/org/jetbrains/kotlin/analysis/project/structure/builder/KtModuleBuilder;", "kotlinCoreProjectEnvironment", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "analyzableExtensions", "", "", "getAnalyzableExtensions", "()Ljava/util/Set;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "moduleName", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "sourceRoots", "", "Ljava/nio/file/Path;", "addSourceRoot", "", "path", "addSourceRoots", "paths", "", "build", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "collectVirtualFilesByRoots", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "kotlin-analysis-api"})
@SourceDebugExtension(value={"SMAP\nKspSourceModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KspSourceModuleBuilder.kt\ncom/google/devtools/ksp/standalone/KspModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1617#2,9:121\n1869#2:130\n1870#2:132\n1626#2:133\n1#3:131\n*S KotlinDebug\n*F\n+ 1 KspSourceModuleBuilder.kt\ncom/google/devtools/ksp/standalone/KspModuleBuilder\n*L\n62#1:121,9\n62#1:130\n62#1:132\n62#1:133\n62#1:131\n*E\n"})
public final class KspModuleBuilder
extends KtModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String moduleName;
    @NotNull
    private LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Set<Path> sourceRoots;
    @NotNull
    private final Set<String> analyzableExtensions;

    public KspModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter((Object)kotlinCoreProjectEnvironment, (String)"kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
        this.languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
        this.sourceRoots = new LinkedHashSet();
        Object[] objectArray = new String[]{"kt", "java", "kts"};
        this.analyzableExtensions = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final String getModuleName() {
        String string2 = this.moduleName;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"moduleName");
        return null;
    }

    public final void setModuleName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.moduleName = string2;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"<set-?>");
        this.languageVersionSettings = languageVersionSettings;
    }

    public final void addSourceRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.sourceRoots.add(path);
    }

    public final void addSourceRoots(@NotNull Collection<? extends Path> paths2) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        this.sourceRoots.addAll(paths2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KaSourceModule build() {
        void $this$mapNotNullTo$iv$iv;
        Set<VirtualFile> virtualFiles = this.collectVirtualFilesByRoots();
        PsiManager psiManager = PsiManager.getInstance(this.kotlinCoreProjectEnvironment.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl3 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
        IncrementalGlobalSearchScope contentScope = new IncrementalGlobalSearchScope(mockProject, (Collection<? extends VirtualFile>)virtualFiles);
        List<KaModule> list = this.getDirectRegularDependencies();
        List<KaModule> list2 = this.getDirectDependsOnDependencies();
        List<KaModule> list3 = this.getDirectFriendDependencies();
        GlobalSearchScope globalSearchScope = contentScope;
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject2 = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject2, (String)"getProject(...)");
        return new KaSourceModuleImpl(list, list2, list3, globalSearchScope, targetPlatform, mockProject2, this.getModuleName(), this.languageVersionSettings, psiFiles);
    }

    @NotNull
    public final Set<String> getAnalyzableExtensions() {
        return this.analyzableExtensions;
    }

    private final Set<VirtualFile> collectVirtualFilesByRoots() {
        Set set;
        CoreLocalFileSystem coreLocalFileSystem = this.kotlinCoreProjectEnvironment.getEnvironment().getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)coreLocalFileSystem, (String)"getLocalFileSystem(...)");
        CoreLocalFileSystem localFileSystem = coreLocalFileSystem;
        Set $this$collectVirtualFilesByRoots_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl2 = false;
        for (Path root : this.sourceRoots) {
            File file2 = root.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            Sequence files2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file2, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ KspModuleBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(File it) {
                    boolean bl2;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (!it.isDirectory()) {
                        Set<String> set = this.this$0.getAnalyzableExtensions();
                        String string2 = FilesKt.getExtension((File)it).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        if (!set.contains(string2)) {
                            bl2 = false;
                            return bl2;
                        }
                    }
                    bl2 = true;
                    return bl2;
                }
            }));
            for (File file3 : files2) {
                VirtualFile virtualFile;
                if (localFileSystem.findFileByIoFile(file3) == null) continue;
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile;
                $this$collectVirtualFilesByRoots_u24lambda_u241.add(virtualFile2);
            }
        }
        return SetsKt.build((Set)set);
    }
}

