/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/codegen/intrinsics/UnsignedIntrinsic;", "Lksp/org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "targetDescriptor", "", "<init>", "(Ljava/lang/String;)V", "isApplicableToOverload", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "backend"})
public abstract class UnsignedIntrinsic
extends IntrinsicMethod {
    @NotNull
    private final String targetDescriptor;

    public UnsignedIntrinsic(@NotNull String targetDescriptor) {
        Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
        this.targetDescriptor = targetDescriptor;
    }

    @Override
    public boolean isApplicableToOverload(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return true;
        }
        List<ValueParameterDescriptor> list = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list);
        if (valueParameterDescriptor == null) {
            return true;
        }
        ValueParameterDescriptor valueParameter2 = valueParameterDescriptor;
        ClassifierDescriptor classifierDescriptor = valueParameter2.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new AssertionError((Object)("Unexpected descriptor for unsigned intrinsic: " + descriptor2));
        }
        ClassifierDescriptor singleValueParameterTypeDescriptor = classifierDescriptor;
        return Intrinsics.areEqual((Object)singleValueParameterTypeDescriptor.getName().asString(), (Object)this.targetDescriptor);
    }
}

