/*
 * Decompiled with CFR 0.152.
 */
package ksp.it.unimi.dsi.fastutil.floats;

import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import ksp.it.unimi.dsi.fastutil.SafeMath;

@FunctionalInterface
public interface FloatPredicate
extends Predicate<Float>,
DoublePredicate {
    @Override
    public boolean test(float var1);

    @Override
    @Deprecated
    default public boolean test(double t2) {
        return this.test(SafeMath.safeDoubleToFloat(t2));
    }

    @Override
    @Deprecated
    default public boolean test(Float t2) {
        return this.test(t2.floatValue());
    }

    default public FloatPredicate and(FloatPredicate other) {
        Objects.requireNonNull(other);
        return t2 -> this.test(t2) && other.test(t2);
    }

    @Override
    default public FloatPredicate and(DoublePredicate other) {
        return this.and(other instanceof FloatPredicate ? (FloatPredicate)other : other::test);
    }

    @Override
    @Deprecated
    default public Predicate<Float> and(Predicate<? super Float> other) {
        return Predicate.super.and(other);
    }

    @Override
    default public FloatPredicate negate() {
        return t2 -> !this.test(t2);
    }

    default public FloatPredicate or(FloatPredicate other) {
        Objects.requireNonNull(other);
        return t2 -> this.test(t2) || other.test(t2);
    }

    @Override
    default public FloatPredicate or(DoublePredicate other) {
        return this.or(other instanceof FloatPredicate ? (FloatPredicate)other : other::test);
    }

    @Override
    @Deprecated
    default public Predicate<Float> or(Predicate<? super Float> other) {
        return Predicate.super.or(other);
    }
}

