/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.compiled;

import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.util.Function;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.cls.ClsFormatException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.org.objectweb.asm.TypeReference;

public final class SignatureParsing {
    private static final char VARIANCE_NONE = '\u0000';
    private static final char VARIANCE_EXTENDS = '+';
    private static final char VARIANCE_SUPER = '-';

    private SignatureParsing() {
    }

    @NotNull
    static TypeParametersDeclaration parseTypeParametersDeclaration(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        if (signature.current() != '<') {
            TypeParametersDeclaration typeParametersDeclaration = TypeParametersDeclaration.EMPTY;
            if (typeParametersDeclaration == null) {
                SignatureParsing.$$$reportNull$$$0(0);
            }
            return typeParametersDeclaration;
        }
        ArrayList<TypeParameterDeclaration> typeParameters2 = new ArrayList<TypeParameterDeclaration>();
        signature.next();
        while (signature.current() != '>') {
            typeParameters2.add(SignatureParsing.parseTypeParameter(signature, mapping));
        }
        signature.next();
        return new TypeParametersDeclaration(typeParameters2);
    }

    private static TypeParameterDeclaration parseTypeParameter(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        int from2 = signature.pos();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            signature.next();
        }
        String name2 = signature.substring(from2);
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping.toTypeInfo(name2).text();
        SmartList<TypeInfo> bounds2 = new SmartList<TypeInfo>();
        while (signature.current() == ':') {
            signature.next();
            TypeInfo bound = SignatureParsing.parseTopLevelClassRefSignatureToTypeInfo(signature, mapping);
            if (!bounds2.isEmpty() && bound == null) continue;
            bounds2.add(bound);
        }
        return new TypeParameterDeclaration(parameterName, bounds2.toArray(TypeInfo.EMPTY_ARRAY));
    }

    @Nullable
    static TypeInfo parseTopLevelClassRefSignatureToTypeInfo(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature, mapping);
            }
            case 'T': {
                return new TypeInfo.RefTypeInfo(SignatureParsing.parseTypeVariableRefSignature(signature));
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharIterator signature) throws ClsFormatException {
        signature.next();
        int from2 = signature.pos();
        while (signature.current() != ';' && signature.current() != '>' && signature.current() != '\uffff') {
            signature.next();
        }
        String id = signature.substring(from2);
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id;
    }

    @NotNull
    private static TypeInfo parseParameterizedClassRefSignatureToTypeInfo(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        signature.next();
        int start = signature.pos();
        boolean hasSpace = false;
        while (true) {
            switch (signature.current()) {
                case ';': {
                    String jvmName = signature.substring(start);
                    if (hasSpace) {
                        jvmName = jvmName.replace(" ", "");
                    }
                    TypeInfo.RefTypeInfo type2 = mapping.toTypeInfo(jvmName);
                    signature.next();
                    TypeInfo.RefTypeInfo refTypeInfo = type2;
                    if (refTypeInfo == null) {
                        SignatureParsing.$$$reportNull$$$0(1);
                    }
                    return refTypeInfo;
                }
                case '\uffff': {
                    throw new ClsFormatException("Malformed signature: " + signature);
                }
                case '<': {
                    String jvmName = signature.substring(start);
                    if (hasSpace) {
                        jvmName = jvmName.replace(" ", "");
                    }
                    TypeInfo.RefTypeInfo type3 = mapping.toTypeInfo(jvmName);
                    signature.next();
                    ArrayList<TypeInfo> components = new ArrayList<TypeInfo>();
                    do {
                        components.add(SignatureParsing.parseClassOrTypeVariableElementToTypeInfo(signature, mapping));
                    } while (signature.current() != '>');
                    type3 = type3.withComponents(components);
                    signature.next();
                    switch (signature.current()) {
                        case ';': {
                            signature.next();
                            TypeInfo.RefTypeInfo refTypeInfo = type3;
                            if (refTypeInfo == null) {
                                SignatureParsing.$$$reportNull$$$0(2);
                            }
                            return refTypeInfo;
                        }
                        case '.': {
                            TypeInfo inner = SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature, mapping);
                            if (!(inner instanceof TypeInfo.RefTypeInfo)) {
                                throw new ClsFormatException("Malformed signature: " + signature);
                            }
                            TypeInfo.RefTypeInfo refTypeInfo = ((TypeInfo.RefTypeInfo)inner).withOuter(type3);
                            if (refTypeInfo == null) {
                                SignatureParsing.$$$reportNull$$$0(3);
                            }
                            return refTypeInfo;
                        }
                    }
                    throw new ClsFormatException("Malformed signature: " + signature);
                }
                case ' ': {
                    hasSpace = true;
                    break;
                }
            }
            signature.next();
        }
    }

    @NotNull
    private static TypeInfo parseClassOrTypeVariableElementToTypeInfo(@NotNull CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        char variance2;
        if (signature == null) {
            SignatureParsing.$$$reportNull$$$0(4);
        }
        if ((variance2 = SignatureParsing.parseVariance(signature)) == '*') {
            return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.WILDCARD);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        TypeInfo info = SignatureParsing.parseTypeWithoutVarianceToTypeInfo(signature, mapping);
        if (info == null) {
            throw new ClsFormatException("Unable to parse signature: " + signature);
        }
        while (dimensions > 0) {
            --dimensions;
            info = info.arrayOf();
        }
        switch (variance2) {
            case '\u0000': {
                TypeInfo typeInfo = info;
                if (typeInfo == null) {
                    SignatureParsing.$$$reportNull$$$0(5);
                }
                return typeInfo;
            }
            case '+': {
                return new TypeInfo.DerivedTypeInfo(TypeInfo.TypeKind.EXTENDS, info);
            }
            case '-': {
                return new TypeInfo.DerivedTypeInfo(TypeInfo.TypeKind.SUPER, info);
            }
        }
        throw new ClsFormatException("Unable to parse signature: " + signature);
    }

    private static char parseVariance(CharIterator signature) {
        char variance2;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance2 = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance2 = '\u0000';
            }
        }
        return variance2;
    }

    private static int parseDimensions(CharIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @Deprecated
    @NotNull
    public static String parseTypeString(CharacterIterator signature, Function<? super String, String> mapping) throws ClsFormatException {
        char ch;
        StringBuilder sb = new StringBuilder();
        int pos = signature.getIndex();
        while ((ch = signature.current()) != '\uffff') {
            sb.append(ch);
            signature.next();
        }
        CharIterator iterator2 = new CharIterator(sb.toString());
        String result2 = SignatureParsing.parseTypeStringToTypeInfo(iterator2, TypeInfoProvider.from(mapping)).text();
        signature.setIndex(iterator2.pos() + pos);
        String string2 = result2;
        if (string2 == null) {
            SignatureParsing.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public static TypeInfo parseTypeStringToTypeInfo(@NotNull CharIterator signature, @NotNull TypeInfoProvider mapping) throws ClsFormatException {
        if (signature == null) {
            SignatureParsing.$$$reportNull$$$0(7);
        }
        if (mapping == null) {
            SignatureParsing.$$$reportNull$$$0(8);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        TypeInfo type2 = SignatureParsing.parseTypeWithoutVarianceToTypeInfo(signature, mapping);
        if (type2 == null) {
            throw new ClsFormatException();
        }
        while (dimensions > 0) {
            --dimensions;
            type2 = type2.arrayOf();
        }
        TypeInfo typeInfo = type2;
        if (typeInfo == null) {
            SignatureParsing.$$$reportNull$$$0(9);
        }
        return typeInfo;
    }

    @Nullable
    private static TypeInfo parseTypeWithoutVarianceToTypeInfo(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature, mapping);
            }
            case 'T': {
                return new TypeInfo.RefTypeInfo(SignatureParsing.parseTypeVariableRefSignature(signature));
            }
            case 'B': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.BYTE);
            }
            case 'C': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.CHAR);
            }
            case 'D': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.DOUBLE);
            }
            case 'F': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.FLOAT);
            }
            case 'I': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.INT);
            }
            case 'J': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.LONG);
            }
            case 'S': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.SHORT);
            }
            case 'Z': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.BOOLEAN);
            }
            case 'V': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.VOID);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/compiled/SignatureParsing";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParametersDeclaration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseParameterizedClassRefSignatureToTypeInfo";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/compiled/SignatureParsing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassOrTypeVariableElementToTypeInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeStringToTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseClassOrTypeVariableElementToTypeInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeStringToTypeInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CharIterator {
        static final int DONE = 65535;
        private final String myData;
        private final int myEnd;
        private int myPos = 0;

        public CharIterator(String data) {
            this.myData = data;
            this.myEnd = data.length();
        }

        char current() {
            if (this.myPos == this.myEnd) {
                return '\uffff';
            }
            return this.myData.charAt(this.myPos);
        }

        void next() {
            if (this.myPos < this.myEnd) {
                ++this.myPos;
            }
        }

        int pos() {
            return this.myPos;
        }

        String substring(int fromIndex) {
            return this.myData.substring(fromIndex, this.myPos);
        }

        public String toString() {
            return this.myData;
        }
    }

    static class TypeParametersDeclaration {
        static final TypeParametersDeclaration EMPTY = new TypeParametersDeclaration(Collections.emptyList());
        private final List<TypeParameterDeclaration> myDeclarations;

        private TypeParametersDeclaration(List<TypeParameterDeclaration> declarations2) {
            this.myDeclarations = declarations2;
        }

        TypeInfo getBoundType(TypeReference ref) {
            TypeParameterDeclaration typeParam;
            int typeParameterIndex = ref.getTypeParameterIndex();
            int boundIndex = ref.getTypeParameterBoundIndex();
            if (typeParameterIndex < this.myDeclarations.size() && boundIndex < (typeParam = this.myDeclarations.get(typeParameterIndex)).myBounds.length) {
                return typeParam.myBounds[boundIndex];
            }
            return null;
        }

        TypeInfo getParameterType(TypeReference ref) {
            int typeParameterIndex = ref.getTypeParameterIndex();
            if (typeParameterIndex < this.myDeclarations.size()) {
                return this.myDeclarations.get(typeParameterIndex).myTypeParameter;
            }
            return null;
        }

        void fillInTypeParameterList(StubElement<?> parent2) {
            List<TypeParameterDeclaration> declarations2 = this.myDeclarations;
            if (declarations2.isEmpty()) {
                return;
            }
            PsiTypeParameterListStub listStub = parent2.findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
            if (listStub == null) {
                return;
            }
            for (TypeParameterDeclaration parameter2 : declarations2) {
                parameter2.createTypeParameter(listStub);
            }
        }
    }

    @FunctionalInterface
    public static interface TypeInfoProvider {
        @NotNull
        public TypeInfo.RefTypeInfo toTypeInfo(@NotNull String var1);

        public static TypeInfoProvider from(Function<? super String, String> fn) {
            return internalName -> new TypeInfo.RefTypeInfo((String)fn.apply(internalName));
        }
    }

    private static class TypeParameterDeclaration {
        private final TypeInfo myTypeParameter;
        private final TypeInfo[] myBounds;

        private TypeParameterDeclaration(String parameter2, TypeInfo[] bounds2) {
            this.myTypeParameter = new TypeInfo.RefTypeInfo(parameter2);
            this.myBounds = bounds2;
        }

        private void createTypeParameter(PsiTypeParameterListStub listStub) {
            PsiTypeParameterStubImpl stub = new PsiTypeParameterStubImpl((StubElement)listStub, this.myTypeParameter.text());
            this.myTypeParameter.getTypeAnnotations().createAnnotationStubs(stub);
            TypeInfo[] info = this.myBounds;
            if (info.length > 0 && info[0] == null) {
                info = Arrays.copyOfRange(info, 1, info.length);
            }
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)stub, info);
        }
    }
}

