/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import ksp.com.intellij.openapi.util.text.StringUtilRt;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class Comparing {
    private Comparing() {
    }

    @Contract(value="null,!null -> false; !null,null -> false; null,null -> true", pure=true)
    public static <T> boolean equal(@Nullable T arg1, @Nullable T arg2) {
        if (arg1 == arg2) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        if (arg1 instanceof Object[] && arg2 instanceof Object[]) {
            Object[] arr1 = (Object[])arg1;
            Object[] arr2 = (Object[])arg2;
            return Arrays.equals(arr1, arr2);
        }
        if (arg1 instanceof CharSequence && arg2 instanceof CharSequence) {
            return Comparing.equal((CharSequence)arg1, (CharSequence)arg2, true);
        }
        return arg1.equals(arg2);
    }

    @Contract(value="null,!null -> false; !null,null -> false; null,null -> true", pure=true)
    public static boolean equal(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    @Contract(value="null,!null,_ -> false; !null,null,_ -> false; null,null,_ -> true", pure=true)
    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        return StringUtilRt.equal(s1, s2, caseSensitive);
    }

    @Deprecated
    @Contract(value="null,!null -> false; !null,null -> false; null,null -> true", pure=true)
    public static boolean equal(@Nullable String arg1, @Nullable String arg2) {
        return Objects.equals(arg1, arg2);
    }

    @Contract(value="null,!null,_ -> false; !null,null,_ -> false; null,null,_ -> true", pure=true)
    public static boolean equal(@Nullable String arg1, @Nullable String arg2, boolean caseSensitive) {
        return arg1 == null ? arg2 == null : (caseSensitive ? arg1.equals(arg2) : arg1.equalsIgnoreCase(arg2));
    }

    public static boolean strEqual(@Nullable String arg1, @Nullable String arg2) {
        return Comparing.strEqual(arg1, arg2, true);
    }

    public static boolean strEqual(@Nullable String arg1, @Nullable String arg2, boolean caseSensitive) {
        return Comparing.equal(arg1 == null ? "" : arg1, arg2 == null ? "" : arg2, caseSensitive);
    }

    public static <T> boolean haveEqualElements(@NotNull Collection<? extends T> a, @NotNull Collection<? extends T> b) {
        if (a == null) {
            Comparing.$$$reportNull$$$0(0);
        }
        if (b == null) {
            Comparing.$$$reportNull$$$0(1);
        }
        if (a.size() != b.size()) {
            return false;
        }
        HashSet<T> aSet = new HashSet<T>(a);
        for (T t2 : b) {
            if (aSet.contains(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean haveEqualElements(@Nullable T[] a, @Nullable T[] b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length != b.length) {
            return false;
        }
        HashSet<T> aSet = new HashSet<T>(Arrays.asList(a));
        for (T t2 : b) {
            if (aSet.contains(t2)) continue;
            return false;
        }
        return true;
    }

    public static int hashcode(@Nullable Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static int hashcode(Object obj1, Object obj2) {
        return Comparing.hashcode(obj1) ^ Comparing.hashcode(obj2);
    }

    public static int unorderedHashcode(@NotNull Collection<?> collection) {
        if (collection == null) {
            Comparing.$$$reportNull$$$0(2);
        }
        int h2 = 0;
        for (Object obj : collection) {
            if (obj == null) continue;
            h2 += obj.hashCode();
        }
        return h2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static int compare(byte o1, byte o2) {
        return Byte.compare(o1, o2);
    }

    @Deprecated
    public static int compare(boolean o1, boolean o2) {
        return Boolean.compare(o1, o2);
    }

    @Deprecated
    public static int compare(int o1, int o2) {
        return Integer.compare(o1, o2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static int compare(long o1, long o2) {
        return Long.compare(o1, o2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static int compare(double o1, double o2) {
        return Double.compare(o1, o2);
    }

    public static int compare(@Nullable byte[] o1, @Nullable byte[] o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1.length > o2.length) {
            return 1;
        }
        if (o1.length < o2.length) {
            return -1;
        }
        for (int i = 0; i < o1.length; ++i) {
            if (o1[i] > o2[i]) {
                return 1;
            }
            if (o1[i] >= o2[i]) continue;
            return -1;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compare(@Nullable T o1, @Nullable T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @ApiStatus.Obsolete
    public static <T> int compare(@Nullable T o1, @Nullable T o2, @NotNull Comparator<? super T> notNullComparator) {
        if (notNullComparator == null) {
            Comparing.$$$reportNull$$$0(3);
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return notNullComparator.compare(o1, o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullComparator";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/openapi/util/Comparing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "haveEqualElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unorderedHashcode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

