/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.progress;

import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.progress.PerformInBackgroundOption;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.progress.Task;
import ksp.com.intellij.openapi.progress.WrappedProgressIndicator;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Computable;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    private static ProgressManager ourInstance;

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager instance2 = ourInstance;
        if (instance2 == null) {
            ourInstance = instance2 = ApplicationManager.getApplication().getService(ProgressManager.class);
        }
        ProgressManager progressManager = instance2;
        if (progressManager == null) {
            ProgressManager.$$$reportNull$$$0(0);
        }
        return progressManager;
    }

    @ApiStatus.Internal
    @Nullable
    public static ProgressManager getInstanceOrNull() {
        return ourInstance;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public final <T> T runProcess(@NotNull Computable<T> process2, ProgressIndicator progress) throws ProcessCanceledException {
        if (process2 == null) {
            ProgressManager.$$$reportNull$$$0(1);
        }
        Ref ref = new Ref();
        this.runProcess(() -> ref.set(process2.compute()), progress);
        return ref.get();
    }

    @Override
    public abstract ProgressIndicator getProgressIndicator();

    public static void progress(@NotNull @NlsContexts.ProgressText String text) throws ProcessCanceledException {
        if (text == null) {
            ProgressManager.$$$reportNull$$$0(2);
        }
        ProgressManager.progress(text, "");
    }

    public static void progress2(@NotNull @NlsContexts.ProgressDetails String text) throws ProcessCanceledException {
        ProgressIndicator pi;
        if (text == null) {
            ProgressManager.$$$reportNull$$$0(3);
        }
        if ((pi = ProgressManager.getInstance().getProgressIndicator()) != null) {
            pi.checkCanceled();
            pi.setText2(text);
        }
    }

    public static void progress(@NotNull @NlsContexts.ProgressText String text, @Nullable @NlsContexts.ProgressDetails String text2) throws ProcessCanceledException {
        ProgressIndicator pi;
        if (text == null) {
            ProgressManager.$$$reportNull$$$0(4);
        }
        if ((pi = ProgressManager.getInstance().getProgressIndicator()) != null) {
            pi.checkCanceled();
            pi.setText(text);
            pi.setText2(text2 == null ? "" : text2);
        }
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> var1) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @NlsContexts.DialogTitle String var2, boolean var3, @Nullable Project var4);

    public abstract <T, E extends Exception> T runProcessWithProgressSynchronously(@NotNull ThrowableComputable<T, E> var1, @NotNull @NlsContexts.DialogTitle String var2, boolean var3, @Nullable Project var4) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @NlsContexts.DialogTitle String var2, boolean var3, @Nullable Project var4, @Nullable JComponent var5);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @NlsContexts.ProgressTitle String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5, @NotNull PerformInBackgroundOption var6);

    public abstract void run(@NotNull Task var1);

    public <T, E extends Exception> T run(@NotNull Task.WithResult<T, E> task) throws E {
        if (task == null) {
            ProgressManager.$$$reportNull$$$0(5);
        }
        this.run((Task)task);
        return task.getResult();
    }

    public abstract void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable var1, @NotNull ProgressIndicator var2);

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressManager.$$$reportNull$$$0(6);
        }
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressManager.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager instance2 = ProgressManager.getInstanceOrNull();
        if (instance2 != null) {
            instance2.doCheckCanceled();
        }
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public static void assertNotCircular(@NotNull ProgressIndicator original) {
        if (original == null) {
            ProgressManager.$$$reportNull$$$0(8);
        }
        HashSet<ProgressIndicator> wrappedParents = null;
        ProgressIndicator i = original;
        while (i instanceof WrappedProgressIndicator) {
            if (wrappedParents == null) {
                wrappedParents = new HashSet<ProgressIndicator>();
            }
            if (!wrappedParents.add(i)) {
                throw new IllegalArgumentException(i + " wraps itself");
            }
            i = ((WrappedProgressIndicator)i).getOriginalProgressIndicator();
        }
    }

    public abstract boolean runInReadActionWithWriteActionPriority(@NotNull Runnable var1, @Nullable ProgressIndicator var2);

    public abstract boolean isInNonCancelableSection();

    @ApiStatus.Internal
    public abstract <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> var1) throws E;

    @ApiStatus.Internal
    public abstract <X> X silenceGlobalIndicator(@NotNull Supplier<? extends X> var1);

    @ApiStatus.Internal
    @Nullable
    public abstract ModalityState getCurrentProgressModality();

    static {
        ApplicationManager.registerCleaner(() -> {
            ourInstance = null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/progress/ProgressManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/progress/ProgressManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "progress2";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canceled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertNotCircular";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

