/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.jna;

import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.SystemInfoRt;
import ksp.com.intellij.util.system.CpuArch;
import ksp.com.sun.jna.Native;
import ksp.org.jetbrains.annotations.NotNull;

public final class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(@NotNull Logger logger2) {
        if (logger2 == null) {
            JnaLoader.$$$reportNull$$$0(0);
        }
        if (ourJnaLoaded == null) {
            ourJnaLoaded = Boolean.FALSE;
            try {
                long t2 = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t2 = System.currentTimeMillis() - t2;
                logger2.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t2 + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t3) {
                logger2.warn("Unable to load JNA library (os=" + SystemInfoRt.OS_NAME + " " + SystemInfoRt.OS_VERSION + ", jna.boot.library.path=" + System.getProperty("jna.boot.library.path") + ")", t3);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }

    public static boolean isSupportsDirectMapping() {
        return !SystemInfoRt.isMac || !CpuArch.isArm64();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "ksp/com/intellij/jna/JnaLoader", "load"));
    }
}

