/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.ReflectionTypes;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import ksp.org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import ksp.org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import ksp.org.jetbrains.kotlin.js.naming.SuggestedName;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/js/naming/NameSuggestion;", "", "<init>", "()V", "cache", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lksp/org/jetbrains/kotlin/js/naming/SuggestedName;", "suggest", "descriptor", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "generate", "generateDefault", "getSuggestedName", "", "Companion", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nNameSuggestion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameSuggestion.kt\norg/jetbrains/kotlin/js/naming/NameSuggestion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n381#2,7:368\n1557#3:375\n1628#3,3:376\n*S KotlinDebug\n*F\n+ 1 NameSuggestion.kt\norg/jetbrains/kotlin/js/naming/NameSuggestion\n*L\n73#1:368,7\n100#1:375\n100#1:376,3\n*E\n"})
public class NameSuggestion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<DeclarationDescriptor, SuggestedName> cache;

    public NameSuggestion() {
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.cache = map;
    }

    @Nullable
    public final SuggestedName suggest(@NotNull DeclarationDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        SuggestedName suggestedName;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Map<DeclarationDescriptor, SuggestedName> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        SuggestedName value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
            SuggestedName answer$iv = this.generate(declarationDescriptor, bindingContext);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            suggestedName = answer$iv;
        } else {
            suggestedName = value$iv;
        }
        return suggestedName;
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generate(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        DeclarationDescriptor declarationDescriptor;
        if (AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isCompanionObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor2);
            return this.suggest(declarationDescriptor2, bindingContext);
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend() && (declarationDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
            DeclarationDescriptor it = declarationDescriptor;
            boolean bl = false;
            return NameSuggestion.generate$suggest(this, bindingContext, it);
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            List list = CollectionsKt.listOf((Object)descriptor2.getName().asString());
            DeclarationDescriptor declarationDescriptor3 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor3);
            return new SuggestedName(list, true, descriptor2, declarationDescriptor3);
        }
        declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ModuleDescriptor) {
            return null;
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            SuggestedName suggestedName;
            if (!((PackageFragmentDescriptor)descriptor2).getFqName().isRoot()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    Name name2 = (Name)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.asString());
                }
                DeclarationDescriptor declarationDescriptor4 = ((PackageFragmentDescriptor)descriptor2).getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor5 = descriptor2;
                boolean bl3 = true;
                List list = (List)destination$iv$iv;
                suggestedName = new SuggestedName(list, bl3, declarationDescriptor5, declarationDescriptor4);
            } else {
                suggestedName = null;
            }
            return suggestedName;
        }
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((FakeCallableDescriptorForObject)descriptor2).getReferencedObject());
        }
        if (declarationDescriptor instanceof TypeAliasConstructorDescriptor) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor());
        }
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary() || AnnotationsUtils.isNativeObject(descriptor2)) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
                return NameSuggestion.generate$suggest(this, bindingContext, classifierDescriptorWithTypeParameters);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            String ownName;
            String string2 = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, bindingContext);
            if (string2 == null) {
                string2 = this.getSuggestedName(descriptor2);
            }
            String name3 = ownName = string2;
            DeclarationDescriptor declarationDescriptor6 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor6, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor scope = declarationDescriptor6;
            if (descriptor2 instanceof FunctionDescriptor) {
                DeclarationDescriptor declarationDescriptor7 = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor7, (String)"getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor7;
                String liftedName = ownName;
                boolean hasInline = false;
                while (container instanceof FunctionDescriptor) {
                    if (((FunctionDescriptor)container).isInline() && NameSuggestion.Companion.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)container).isPublicAPI()) {
                        hasInline = true;
                    }
                    liftedName = this.getSuggestedName(container) + '$' + liftedName;
                    container = ((FunctionDescriptor)container).getContainingDeclaration();
                }
                if (hasInline) {
                    scope = container;
                    name3 = liftedName;
                }
            }
            return new SuggestedName(CollectionsKt.listOf((Object)name3), false, descriptor2, scope);
        }
        return this.generateDefault(descriptor2, bindingContext);
    }

    private final SuggestedName generateDefault(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        String string2;
        List parts = new ArrayList();
        DeclarationDescriptor current = descriptor2;
        if (current instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)current).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            CallableDescriptor callableDescriptor = NameSuggestion.Companion.getOverridden((CallableDescriptor)current);
            Intrinsics.checkNotNull((Object)callableDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)callableDescriptor;
            if (!ModalityUtilsKt.isOverridableOrOverrides(overridden)) {
                current = overridden;
            }
        }
        DeclarationDescriptor fixedDescriptor = current;
        Collection collection = parts;
        if (fixedDescriptor instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)current).getContainingDeclaration();
            Intrinsics.checkNotNull((Object)classifierDescriptorWithTypeParameters);
            current = classifierDescriptorWithTypeParameters;
            string2 = this.getSuggestedName(current) + "_init";
        } else {
            string2 = this.getSuggestedName(fixedDescriptor);
        }
        Object object = string2;
        collection.add(object);
        if (current.getContainingDeclaration() instanceof FunctionDescriptor && !(current instanceof TypeParameterDescriptor)) {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            SuggestedName suggestedName = this.suggest((FunctionDescriptor)declarationDescriptor, bindingContext);
            Intrinsics.checkNotNull((Object)suggestedName);
            SuggestedName outerFunctionName = suggestedName;
            ((Collection)parts).add(CollectionsKt.single(outerFunctionName.getNames()));
            current = outerFunctionName.getScope();
        } else {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor);
            current = declarationDescriptor;
        }
        if (current instanceof PropertyDescriptor) {
            current = ((PropertyDescriptor)current).getContainingDeclaration();
        }
        CollectionsKt.reverse((List)parts);
        String unmangledName = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"$", null, null, (int)0, null, null, (int)62, null);
        object = NameSuggestion.Companion.mangleNameIfNecessary(unmangledName, fixedDescriptor, bindingContext);
        String id = ((Companion.NameAndStability)object).component1();
        boolean stable = ((Companion.NameAndStability)object).component2();
        return new SuggestedName(CollectionsKt.listOf((Object)id), stable, fixedDescriptor, current);
    }

    private final String getSuggestedName(DeclarationDescriptor descriptor2) {
        String string2;
        Name name2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        if (name3.isSpecial()) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyGetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("get_");
                PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
                string2 = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else if (declarationDescriptor instanceof PropertySetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("set_");
                PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
                string2 = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else {
                string2 = "f";
            }
        } else {
            String string3 = name3.asString();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }

    private static final SuggestedName generate$suggest(NameSuggestion this$0, BindingContext $bindingContext, DeclarationDescriptor d) {
        return this$0.suggest(d, $bindingContext);
    }

    @JvmStatic
    @NotNull
    public static final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
        return Companion.getPrivateMangledName(baseName, descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
        return Companion.getStableMangledName(suggestedName, forCalculateId);
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeName(@NotNull String name2) {
        return Companion.sanitizeName(name2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0007J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0007R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/js/naming/NameSuggestion$Companion;", "", "<init>", "()V", "mangleNameIfNecessary", "Lksp/org/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "baseName", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "getOverridden", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "mangleRegularNameIfNecessary", "getPrivateMangledName", "getInternalMangledName", "suggestedName", "forCalculateId", "getStableMangledName", "mangledId", "ownEffectiveVisibility", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "getOwnEffectiveVisibility", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "sanitizeName", "name", "NameAndStability", "js.frontend"})
    @SourceDebugExtension(value={"SMAP\nNameSuggestion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameSuggestion.kt\norg/jetbrains/kotlin/js/naming/NameSuggestion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,367:1\n1#2:368\n975#3:369\n1046#3,3:370\n*S KotlinDebug\n*F\n+ 1 NameSuggestion.kt\norg/jetbrains/kotlin/js/naming/NameSuggestion$Companion\n*L\n364#1:369\n364#1:370,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final NameAndStability mangleNameIfNecessary(String baseName, DeclarationDescriptor descriptor2, BindingContext bindingContext) {
            DeclarationDescriptor overriddenDescriptor = descriptor2 instanceof CallableDescriptor ? (DeclarationDescriptor)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)descriptor2, Companion::mangleNameIfNecessary$lambda$0)) : descriptor2;
            String nativeName = AnnotationsUtils.getNameForAnnotatedObject(overriddenDescriptor, bindingContext);
            if (nativeName != null) {
                return new NameAndStability(nativeName, true);
            }
            if (overriddenDescriptor instanceof FunctionDescriptor) {
                String string2 = DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor).asString();
                if (Intrinsics.areEqual((Object)string2, (Object)"kotlin.CharSequence.get")) {
                    return new NameAndStability("charCodeAt", true);
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"kotlin.Any.equals")) {
                    return new NameAndStability("equals", true);
                }
                DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)overriddenDescriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor;
                if (container instanceof ClassDescriptor) {
                    SimpleType simpleType = ((ClassDescriptor)container).getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                    if (ReflectionTypes.Companion.isNumberedKPropertyOrKMutablePropertyType(simpleType)) {
                        String name2;
                        String string3 = ((FunctionDescriptor)overriddenDescriptor).getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                        String string4 = name2 = string3;
                        if (Intrinsics.areEqual((Object)string4, (Object)"get") || Intrinsics.areEqual((Object)string4, (Object)"set")) {
                            return new NameAndStability(name2, true);
                        }
                    }
                }
            } else if (overriddenDescriptor instanceof PropertyDescriptor && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor).asString(), (Object)"kotlin.reflect.KCallable.name")) {
                return new NameAndStability("callableName", true);
            }
            return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor);
        }

        private final CallableDescriptor getOverridden(CallableDescriptor descriptor2) {
            return (CallableDescriptor)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)descriptor2, Companion::getOverridden$lambda$1));
        }

        private final NameAndStability mangleRegularNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            NameAndStability nameAndStability;
            DeclarationDescriptor containingDeclaration;
            if (descriptor2 instanceof ClassOrPackageFragmentDescriptor) {
                return new NameAndStability(baseName, !DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2));
            }
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            DescriptorVisibility effectiveVisibility = this.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)descriptor2);
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor declarationDescriptor2 = containingDeclaration = declarationDescriptor;
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                nameAndStability = effectiveVisibility.isPublicAPI() ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.INTERNAL) ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName));
            } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                nameAndStability = descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isEnumValueOfMethod((FunctionDescriptor)descriptor2) ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.PUBLIC) ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (ModalityUtilsKt.isOverridableOrOverrides((CallableMemberDescriptor)descriptor2) ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.PROTECTED) && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) && ((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.INTERNAL) ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : (((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) ? ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledPrivate(baseName, descriptor2) : ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName))))));
            } else {
                boolean bl = containingDeclaration instanceof CallableMemberDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
                    throw new AssertionError((Object)string2);
                }
                nameAndStability = ksp.org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            return nameAndStability;
        }

        @JvmStatic
        @NotNull
        public final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            String ownerName = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            return this.getStableMangledName(this.sanitizeName(baseName), ownerName + '.' + baseName + ':' + EncodeSignatureKt.encodeSignature(descriptor2));
        }

        @NotNull
        public final String getInternalMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter((Object)forCalculateId, (String)"forCalculateId");
            String suffix = '_' + this.mangledId("internal:" + forCalculateId) + '$';
            return suggestedName + suffix;
        }

        @JvmStatic
        @NotNull
        public final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter((Object)forCalculateId, (String)"forCalculateId");
            String suffix = ((CharSequence)forCalculateId).length() == 0 ? "" : '_' + this.mangledId(forCalculateId) + '$';
            return suggestedName + suffix;
        }

        private final String mangledId(String forCalculateId) {
            String string2;
            int absHashCode = Math.abs(forCalculateId.hashCode());
            if (absHashCode != 0) {
                String string3 = Integer.toString(absHashCode, CharsKt.checkRadix((int)36));
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            } else {
                string2 = "";
            }
            return string2;
        }

        private final DescriptorVisibility getOwnEffectiveVisibility(DeclarationDescriptorWithVisibility $this$ownEffectiveVisibility) {
            DescriptorVisibility descriptorVisibility = $this$ownEffectiveVisibility.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
            return EffectiveVisibilityUtilsKt.toDescriptorVisibility(EffectiveVisibilityUtilsKt.effectiveVisibility(descriptorVisibility, $this$ownEffectiveVisibility, true));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String sanitizeName(@NotNull String name2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (((CharSequence)name2).length() == 0) {
                return "_";
            }
            char it = StringsKt.first((CharSequence)name2);
            boolean $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = false;
            char first = IdentifierPolicyKt.isES5IdentifierStart(it) ? it : (char)'_';
            CharSequence charSequence = StringsKt.drop((String)name2, (int)1);
            StringBuilder stringBuilder = new StringBuilder().append(first);
            boolean $i$f$map = false;
            void $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                char it2;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(IdentifierPolicyKt.isES5IdentifierPart(it2) ? it2 : (char)'_'));
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
        }

        private static final CallableDescriptor mangleNameIfNecessary$lambda$0(CallableDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Collection<? extends CallableDescriptor> collection = it.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
            return callableDescriptor != null ? callableDescriptor.getOriginal() : null;
        }

        private static final CallableDescriptor getOverridden$lambda$1(CallableDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Collection<? extends CallableDescriptor> collection = it.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
            return callableDescriptor != null ? callableDescriptor.getOriginal() : null;
        }

        private static final NameAndStability mangleRegularNameIfNecessary$regularAndUnstable(String $baseName) {
            return new NameAndStability($baseName, false);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledAndStable(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getStableMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledInternal(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getInternalMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledPrivate(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getPrivateMangledName($baseName, (CallableDescriptor)$descriptor), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "", "name", "", "stable", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getStable", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "js.frontend"})
        public static final class NameAndStability {
            @NotNull
            private final String name;
            private final boolean stable;

            public NameAndStability(@NotNull String name2, boolean stable) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.name = name2;
                this.stable = stable;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean getStable() {
                return this.stable;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final boolean component2() {
                return this.stable;
            }

            @NotNull
            public final NameAndStability copy(@NotNull String name2, boolean stable) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return new NameAndStability(name2, stable);
            }

            public static /* synthetic */ NameAndStability copy$default(NameAndStability nameAndStability, String string2, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = nameAndStability.name;
                }
                if ((n & 2) != 0) {
                    bl = nameAndStability.stable;
                }
                return nameAndStability.copy(string2, bl);
            }

            @NotNull
            public String toString() {
                return "NameAndStability(name=" + this.name + ", stable=" + this.stable + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.stable);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NameAndStability)) {
                    return false;
                }
                NameAndStability nameAndStability = (NameAndStability)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)nameAndStability.name)) {
                    return false;
                }
                return this.stable == nameAndStability.stable;
            }
        }
    }
}

