/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import ksp.org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrElementBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import ksp.org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformer;
import ksp.org.jetbrains.kotlin.ir.types.IrErrorType;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeArgument;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0004J\f\u0010#\u001a\u00020$*\u00020$H\u0002J\u0016\u0010%\u001a\u0004\u0018\u00010\u001f*\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u00020\u001f*\u00020\u001f2\u0006\u0010)\u001a\u00020'H\u0002\u00a8\u0006*"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer;", "Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer;", "interpreter", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lksp/org/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lksp/org/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "transformAnnotations", "annotationContainer", "Lksp/org/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "transformAnnotation", "annotation", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformAnnotationArgument", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "valueParameter", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "transformVarArg", "Lksp/org/jetbrains/kotlin/ir/expressions/IrVararg;", "transformSingleArg", "expectedType", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "convertToConstIfPossible", "type", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrConstAnnotationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstAnnotationTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1863#2,2:96\n1863#2,2:98\n1#3:100\n*S KotlinDebug\n*F\n+ 1 IrConstAnnotationTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer\n*L\n39#1:96,2\n65#1:98,2\n*E\n"})
public abstract class IrConstAnnotationTransformer
extends IrConstTransformer {
    public IrConstAnnotationTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        super(interpreter2, irFile, mode, checker, evaluatedConstTracker, inlineConstTracker, onWarning, onError, suppressExceptions);
    }

    protected final void transformAnnotations(@NotNull IrAnnotationContainer annotationContainer) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation = (IrConstructorCall)element$iv;
            boolean bl = false;
            this.transformAnnotation(annotation);
        }
    }

    private final void transformAnnotation(IrConstructorCall annotation) {
        if (annotation.getType() instanceof IrErrorType) {
            return;
        }
        int n = annotation.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression arg;
            if (annotation.getValueArgument(i) == null) continue;
            annotation.putValueArgument(i, this.transformAnnotationArgument(arg, ((IrConstructor)annotation.getSymbol().getOwner()).getValueParameters().get(i)));
        }
        this.saveInConstTracker(annotation);
    }

    @Nullable
    protected final IrExpression transformAnnotationArgument(@NotNull IrExpression argument, @NotNull IrValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return argument instanceof IrVararg ? (IrExpression)this.transformVarArg((IrVararg)argument) : this.transformSingleArg(argument, valueParameter2.getType());
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = BuildersKt.IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element2 : $this$transformVarArg.getElements()) {
            IrVarargElement arg;
            IrElementBase irElementBase = element2 instanceof IrSpreadElement ? (IrSpreadElement)element2 : null;
            IrVarargElement irVarargElement = irElementBase != null && (irElementBase = irElementBase.getExpression()) != null ? (IrVarargElement)((Object)irElementBase) : (arg = element2);
            if (arg instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)arg).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, it);
                }
                continue;
            }
            if (arg instanceof IrExpression) {
                IrExpression irExpression = this.transformSingleArg((IrExpression)arg, $this$transformVarArg.getVarargElementType());
                if (irExpression != null) {
                    IrVarargElement p0 = irExpression;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, p0);
                }
                continue;
            }
            IrExpressionsKt.addElement(newIrVararg, arg);
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType) {
        IrExpression irExpression;
        if ($this$transformSingleArg instanceof IrGetClass && ((IrGetClass)$this$transformSingleArg).getArgument().getType() instanceof IrErrorType) {
            irExpression = null;
        } else if ($this$transformSingleArg instanceof IrGetEnumValue || $this$transformSingleArg instanceof IrClassReference) {
            irExpression = $this$transformSingleArg;
        } else if ($this$transformSingleArg instanceof IrConstructorCall && IrTypeUtilsKt.isAnnotation($this$transformSingleArg.getType())) {
            this.transformAnnotation((IrConstructorCall)$this$transformSingleArg);
            irExpression = $this$transformSingleArg;
        } else if (this.canBeInterpreted($this$transformSingleArg)) {
            irExpression = this.convertToConstIfPossible(this.interpret($this$transformSingleArg, true), expectedType);
        } else {
            throw new IllegalStateException(("Cannot evaluate IR expression in annotation:\n " + DumpIrTreeKt.dump$default($this$transformSingleArg, null, 1, null)).toString());
        }
        return irExpression;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        IrExpression irExpression;
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            irExpression = $this$convertToConstIfPossible;
        } else if (IrTypePredicatesKt.isArray(type2)) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)type2).getArguments()));
            Intrinsics.checkNotNull((Object)irType);
            irExpression = this.convertToConstIfPossible($this$convertToConstIfPossible, irType);
        } else {
            irExpression = UtilsKt.isPrimitiveArray(type2) ? this.convertToConstIfPossible($this$convertToConstIfPossible, $this$convertToConstIfPossible.getType()) : (IrExpression)IrUtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
        }
        return irExpression;
    }
}

