/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ksp.com.intellij.openapi.util.Key;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.CompilerConfigurationKey;

public class CompilerConfiguration {
    public static CompilerConfiguration EMPTY = new CompilerConfiguration();
    private final Map<Key, Object> map = new LinkedHashMap<Key, Object>();
    private boolean readOnly = false;

    @Nullable
    public <T> T get(@NotNull CompilerConfigurationKey<T> key) {
        Object data;
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(0);
        }
        return (T)((data = this.map.get(key.ideaKey)) == null ? null : CompilerConfiguration.unmodifiable(data));
    }

    @NotNull
    public <T> T get(@NotNull CompilerConfigurationKey<T> key, @NotNull T defaultValue) {
        T data;
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(1);
        }
        if (defaultValue == null) {
            CompilerConfiguration.$$$reportNull$$$0(2);
        }
        T t = (data = this.get(key)) == null ? defaultValue : data;
        if (t == null) {
            CompilerConfiguration.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public <T> T getNotNull(@NotNull CompilerConfigurationKey<T> key) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(4);
        }
        T data = this.get(key);
        assert (data != null) : "No value for configuration key: " + key;
        T t = data;
        if (t == null) {
            CompilerConfiguration.$$$reportNull$$$0(5);
        }
        return t;
    }

    public boolean getBoolean(@NotNull CompilerConfigurationKey<Boolean> key) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(6);
        }
        return this.get(key, false);
    }

    @NotNull
    public <T> List<T> getList(@NotNull CompilerConfigurationKey<List<T>> key) {
        List<T> data;
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(7);
        }
        List list = (data = this.get(key)) == null ? Collections.emptyList() : data;
        if (list == null) {
            CompilerConfiguration.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public <K, V> Map<K, V> getMap(@NotNull CompilerConfigurationKey<Map<K, V>> key) {
        Map<K, V> data;
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(9);
        }
        Map map = (data = this.get(key)) == null ? Collections.emptyMap() : data;
        if (map == null) {
            CompilerConfiguration.$$$reportNull$$$0(10);
        }
        return map;
    }

    public <T> void put(@NotNull CompilerConfigurationKey<T> key, @NotNull T value2) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(11);
        }
        if (value2 == null) {
            CompilerConfiguration.$$$reportNull$$$0(12);
        }
        this.checkReadOnly();
        this.map.put(key.ideaKey, value2);
    }

    public <T> T putIfAbsent(@NotNull CompilerConfigurationKey<T> key, @NotNull T value2) {
        T data;
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(13);
        }
        if (value2 == null) {
            CompilerConfiguration.$$$reportNull$$$0(14);
        }
        if ((data = this.get(key)) != null) {
            return data;
        }
        this.checkReadOnly();
        this.put(key, value2);
        return value2;
    }

    public <T> void putIfNotNull(@NotNull CompilerConfigurationKey<T> key, @Nullable T value2) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(15);
        }
        if (value2 != null) {
            this.put(key, value2);
        }
    }

    public <T> void add(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull T value2) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(16);
        }
        if (value2 == null) {
            CompilerConfiguration.$$$reportNull$$$0(17);
        }
        this.checkReadOnly();
        Key ideaKey = key.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new ArrayList());
        List list = (List)this.map.get(ideaKey);
        list.add(value2);
    }

    public <K, V> void put(@NotNull CompilerConfigurationKey<Map<K, V>> configurationKey, @NotNull K key, @NotNull V value2) {
        if (configurationKey == null) {
            CompilerConfiguration.$$$reportNull$$$0(18);
        }
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(19);
        }
        if (value2 == null) {
            CompilerConfiguration.$$$reportNull$$$0(20);
        }
        this.checkReadOnly();
        Key ideaKey = configurationKey.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new HashMap());
        Map data = (Map)this.map.get(ideaKey);
        data.put(key, value2);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, @Nullable Collection<T> values2) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(21);
        }
        if (values2 != null) {
            this.addAll(key, this.getList(key).size(), values2);
        }
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, int index2, @NotNull Collection<T> values2) {
        if (key == null) {
            CompilerConfiguration.$$$reportNull$$$0(22);
        }
        if (values2 == null) {
            CompilerConfiguration.$$$reportNull$$$0(23);
        }
        this.checkReadOnly();
        CompilerConfiguration.checkForNullElements(values2);
        Key ideaKey = key.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new ArrayList());
        List list = (List)this.map.get(ideaKey);
        list.addAll(index2, values2);
    }

    public CompilerConfiguration copy() {
        CompilerConfiguration copy = new CompilerConfiguration();
        copy.map.putAll(this.map);
        return copy;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("CompilerConfiguration is read-only");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.readOnly = readOnly;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @NotNull
    private static <T> T unmodifiable(@NotNull T object) {
        if (object == null) {
            CompilerConfiguration.$$$reportNull$$$0(24);
        }
        if (object instanceof List) {
            List list = Collections.unmodifiableList((List)object);
            if (list == null) {
                CompilerConfiguration.$$$reportNull$$$0(25);
            }
            return (T)list;
        }
        if (object instanceof Map) {
            Map map = Collections.unmodifiableMap((Map)object);
            if (map == null) {
                CompilerConfiguration.$$$reportNull$$$0(26);
            }
            return (T)map;
        }
        if (object instanceof Set) {
            Set set = Collections.unmodifiableSet((Set)object);
            if (set == null) {
                CompilerConfiguration.$$$reportNull$$$0(27);
            }
            return (T)set;
        }
        if (object instanceof Collection) {
            Collection collection = Collections.unmodifiableCollection((Collection)object);
            if (collection == null) {
                CompilerConfiguration.$$$reportNull$$$0(28);
            }
            return (T)collection;
        }
        T t = object;
        if (t == null) {
            CompilerConfiguration.$$$reportNull$$$0(29);
        }
        return t;
    }

    public String toString() {
        return this.map.toString();
    }

    private static <T> void checkForNullElements(Collection<T> values2) {
        int index2 = 0;
        for (T value2 : values2) {
            if (value2 == null) {
                throw new IllegalArgumentException("Element " + index2 + " is null, while null values in compiler configuration are not allowed");
            }
            ++index2;
        }
    }

    static {
        EMPTY.setReadOnly(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/config/CompilerConfiguration";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKey";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/config/CompilerConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNull";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNotNull";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

