/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiNameHelper;
import ksp.com.intellij.psi.impl.cache.RecordUtil;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiClassStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import ksp.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import ksp.com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import ksp.com.intellij.psi.impl.source.PsiClassImpl;
import ksp.com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import ksp.com.intellij.psi.impl.source.PsiUnnamedClassImpl;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.LightTreeUtil;
import ksp.com.intellij.psi.impl.source.tree.java.AnonymousClassElement;
import ksp.com.intellij.psi.impl.source.tree.java.EnumConstantInitializerElement;
import ksp.com.intellij.psi.impl.source.tree.java.UnnamedClassElement;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;

public abstract class JavaClassElementType
extends JavaStubElementType<PsiClassStub<?>, PsiClass> {
    JavaClassElementType(@NotNull String id, @NotNull IElementType parentElementType) {
        if (id == null) {
            JavaClassElementType.$$$reportNull$$$0(0);
        }
        if (parentElementType == null) {
            JavaClassElementType.$$$reportNull$$$0(1);
        }
        super(id, parentElementType);
    }

    @Override
    public PsiClass createPsi(@NotNull PsiClassStub stub) {
        if (stub == null) {
            JavaClassElementType.$$$reportNull$$$0(2);
        }
        return this.getPsiFactory(stub).createClass(stub);
    }

    @Override
    public PsiClass createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassElementType.$$$reportNull$$$0(3);
        }
        if (node instanceof EnumConstantInitializerElement) {
            return new PsiEnumConstantInitializerImpl(node);
        }
        if (node instanceof AnonymousClassElement) {
            return new PsiAnonymousClassImpl(node);
        }
        if (node instanceof UnnamedClassElement) {
            return new PsiUnnamedClassImpl(node);
        }
        return new PsiClassImpl(node);
    }

    @Override
    @NotNull
    public PsiClassStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        LighterASTNode parent2;
        IElementType type2;
        if (tree == null) {
            JavaClassElementType.$$$reportNull$$$0(4);
        }
        if (node == null) {
            JavaClassElementType.$$$reportNull$$$0(5);
        }
        if (parentStub == null) {
            JavaClassElementType.$$$reportNull$$$0(6);
        }
        boolean isDeprecatedByComment = false;
        boolean isInterface = false;
        boolean isEnum = false;
        boolean isRecord = false;
        boolean isEnumConst = false;
        boolean isAnonymous = false;
        boolean isAnnotation = false;
        boolean isInQualifiedNew = false;
        boolean classKindFound = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String qualifiedName2 = null;
        String name2 = null;
        String baseRef = null;
        if (node.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
            isAnonymous = true;
            classKindFound = true;
        } else if (node.getTokenType() == JavaElementType.ENUM_CONSTANT_INITIALIZER) {
            isEnumConst = true;
            isAnonymous = true;
            classKindFound = true;
            baseRef = ((PsiClassStub)parentStub.getParentStub()).getName();
        }
        for (LighterASTNode child : tree.getChildren(node)) {
            type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaTokenType.AT) {
                isAnnotation = true;
                continue;
            }
            if (type2 == JavaTokenType.INTERFACE_KEYWORD && !classKindFound) {
                isInterface = true;
                classKindFound = true;
                continue;
            }
            if (type2 == JavaTokenType.ENUM_KEYWORD && !classKindFound) {
                isEnum = true;
                classKindFound = true;
                continue;
            }
            if (type2 == JavaTokenType.RECORD_KEYWORD && !classKindFound) {
                isRecord = true;
                classKindFound = true;
                continue;
            }
            if (type2 == JavaTokenType.CLASS_KEYWORD) {
                classKindFound = true;
                continue;
            }
            if (!isAnonymous && type2 == JavaTokenType.IDENTIFIER) {
                name2 = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!isAnonymous || isEnumConst || type2 != JavaElementType.JAVA_CODE_REFERENCE) continue;
            baseRef = LightTreeUtil.toFilteredString(tree, child, null);
        }
        if (name2 != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName2 = !pkg.isEmpty() ? pkg + '.' + name2 : name2;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                String string2 = qualifiedName2 = parentFqn != null ? parentFqn + '.' + name2 : null;
            }
        }
        if (isAnonymous && (parent2 = tree.getParent(node)) != null && parent2.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            isInQualifiedNew = LightTreeUtil.firstChildOfType(tree, parent2, JavaTokenType.DOT) != null;
        }
        boolean isUnnamed = node.getTokenType() == JavaElementType.UNNAMED_CLASS;
        short flags = PsiClassStubImpl.packFlags(isDeprecatedByComment, isInterface, isEnum, isEnumConst, isAnonymous, isAnnotation, isInQualifiedNew, hasDeprecatedAnnotation, false, false, hasDocComment, isRecord, isUnnamed);
        type2 = JavaClassElementType.typeForClass(isAnonymous, isEnumConst, isUnnamed);
        return new PsiClassStubImpl((JavaClassElementType)type2, parentStub, qualifiedName2, name2, baseRef, flags);
    }

    @NotNull
    private static JavaClassElementType typeForClass(boolean anonymous, boolean enumConst, boolean unnamedClass) {
        JavaClassElementType javaClassElementType = enumConst ? JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER : (unnamedClass ? JavaStubElementTypes.UNNAMED_CLASS : (anonymous ? JavaStubElementTypes.ANONYMOUS_CLASS : JavaStubElementTypes.CLASS));
        if (javaClassElementType == null) {
            JavaClassElementType.$$$reportNull$$$0(7);
        }
        return javaClassElementType;
    }

    @Override
    public void serialize(@NotNull PsiClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaClassElementType.$$$reportNull$$$0(8);
        }
        if (dataStream == null) {
            JavaClassElementType.$$$reportNull$$$0(9);
        }
        dataStream.writeShort(((PsiClassStubImpl)stub).getFlags());
        if (!stub.isAnonymous()) {
            String name2 = stub.getName();
            TypeInfo info = ((PsiClassStubImpl)stub).getQualifiedNameTypeInfo();
            dataStream.writeName(info.getShortTypeText().equals(name2) ? null : name2);
            TypeInfo.writeTYPE(dataStream, info);
            dataStream.writeName(stub.getSourceFileName());
        } else {
            dataStream.writeName(stub.getBaseClassReferenceText());
        }
    }

    @Override
    @NotNull
    public PsiClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaClassElementType.$$$reportNull$$$0(10);
        }
        short flags = dataStream.readShort();
        boolean isAnonymous = PsiClassStubImpl.isAnonymous(flags);
        boolean isEnumConst = PsiClassStubImpl.isEnumConstInitializer(flags);
        boolean isUnnamed = PsiClassStubImpl.isUnnamed(flags);
        JavaClassElementType type2 = JavaClassElementType.typeForClass(isAnonymous, isEnumConst, isUnnamed);
        if (!isAnonymous) {
            String name2 = dataStream.readNameString();
            TypeInfo typeInfo = TypeInfo.readTYPE(dataStream);
            if (name2 == null) {
                name2 = typeInfo.getShortTypeText();
            }
            String sourceFileName = dataStream.readNameString();
            PsiClassStubImpl classStub = new PsiClassStubImpl(type2, parentStub, typeInfo, name2, null, flags);
            classStub.setSourceFileName(sourceFileName);
            PsiClassStubImpl psiClassStubImpl = classStub;
            if (psiClassStubImpl == null) {
                JavaClassElementType.$$$reportNull$$$0(11);
            }
            return psiClassStubImpl;
        }
        String baseRef = dataStream.readNameString();
        return new PsiClassStubImpl(type2, parentStub, TypeInfo.SimpleTypeInfo.NULL, null, baseRef, flags);
    }

    @Override
    public void indexStub(@NotNull PsiClassStub stub, @NotNull IndexSink sink) {
        boolean isAnonymous;
        if (stub == null) {
            JavaClassElementType.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            JavaClassElementType.$$$reportNull$$$0(13);
        }
        if (isAnonymous = stub.isAnonymous()) {
            String baseRef = stub.getBaseClassReferenceText();
            if (baseRef != null) {
                sink.occurrence(JavaStubIndexKeys.ANONYMOUS_BASEREF, PsiNameHelper.getShortClassName(baseRef));
            }
        } else {
            String fqn;
            String shortName2 = stub.getName();
            if (!(shortName2 == null || stub instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub).isAnonymousInner())) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, shortName2);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_FQN, fqn);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/java/stubs/JavaClassElementType";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/java/stubs/JavaClassElementType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "typeForClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

