/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import ksp.org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.DeprecatedCallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "element", "frontend"})
@SourceDebugExtension(value={"SMAP\nApiVersionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVersionCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class ApiVersionCallChecker
implements CallChecker {
    @NotNull
    public static final ApiVersionCallChecker INSTANCE = new ApiVersionCallChecker();

    private ApiVersionCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        this.check((CallableDescriptor)obj, context2, reportOn);
    }

    private final void check(CallableDescriptor targetDescriptor, CallCheckerContext context2, PsiElement element2) {
        block3: {
            if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                return;
            }
            SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context2.getLanguageVersionSettings());
            if (accessibility instanceof SinceKotlinAccessibility.NotAccessible) {
                context2.getTrace().report(Errors.API_NOT_AVAILABLE.on(element2, ((SinceKotlinAccessibility.NotAccessible)accessibility).getVersion().getVersionString(), context2.getLanguageVersionSettings().getApiVersion().getVersionString()));
            }
            if (!Intrinsics.areEqual((Object)accessibility, (Object)SinceKotlinAccessibility.Accessible.INSTANCE) || !(targetDescriptor instanceof PropertyDescriptor) || !DeprecatedCallChecker.INSTANCE.shouldCheckPropertyGetter$frontend(element2)) break block3;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor it = propertyGetterDescriptor;
                boolean bl = false;
                INSTANCE.check(it, context2, element2);
            }
        }
    }
}

