/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.util.List;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.FileASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.lang.TreeBackedLighterAST;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.LanguageFileType;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.StubBuilder;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.stubs.ILightStubElementType;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.stubs.ObjectStubBase;
import ksp.com.intellij.psi.stubs.PsiFileStubImpl;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.ILightStubFileElementType;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.containers.BooleanStack;
import ksp.com.intellij.util.containers.Stack;
import ksp.it.unimi.dsi.fastutil.ints.IntArrayList;
import ksp.org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(LightStubBuilder.class);
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement<?> buildStubTree(@NotNull PsiFile file2) {
        LighterAST tree;
        if (file2 == null) {
            LightStubBuilder.$$$reportNull$$$0(0);
        }
        if ((tree = FORCED_AST.get()) == null) {
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + file2 + ", " + fileType);
                return null;
            }
            if (!(file2 instanceof PsiFileImpl)) {
                LOG.error("Unexpected PsiFile instance: " + file2 + ", " + file2.getClass());
                return null;
            }
            if (((PsiFileImpl)file2).getElementTypeForStubBuilder() == null) {
                LOG.error("File is not of IStubFileElementType: " + file2);
                return null;
            }
            FileASTNode node = file2.getNode();
            tree = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        StubElement<?> rootStub = this.createStubForFile(file2, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement<?> createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree) {
        if (file2 == null) {
            LightStubBuilder.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(2);
        }
        return new PsiFileStubImpl<PsiFile>(file2);
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement<?> rootStub) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(3);
        }
        if (root == null) {
            LightStubBuilder.$$$reportNull$$$0(4);
        }
        if (rootStub == null) {
            LightStubBuilder.$$$reportNull$$$0(5);
        }
        Stack<LighterASTNode> parents2 = new Stack<LighterASTNode>();
        IntArrayList childNumbers = new IntArrayList();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent2 = null;
        LighterASTNode element2 = root;
        List children2 = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element2 != null) {
            List kids;
            boolean hasStub;
            ProgressManager.checkCanceled();
            StubElement<?> stub = LightStubBuilder.createStub(tree, element2, parentStub);
            boolean bl = hasStub = stub != parentStub || parent2 == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            if (!(parent2 != null && this.skipNode(tree, parent2, element2) || (kids = tree.getChildren(element2)).isEmpty())) {
                if (parent2 != null) {
                    parents2.push(parent2);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children2);
                    parentStubs.push(parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent2 = element2;
                immediateParentStubbed = hasStub;
                children2 = kids;
                childNumber = 0;
                element2 = children2.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent2, element2)) continue;
            }
            while (children2 != null && ++childNumber < children2.size()) {
                element2 = (LighterASTNode)children2.get(childNumber);
                if (this.skipNode(tree, parent2, element2)) continue;
                continue block0;
            }
            element2 = null;
            while (!parents2.isEmpty()) {
                parent2 = (LighterASTNode)parents2.pop();
                childNumber = childNumbers.popInt();
                children2 = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children2.size()) {
                    element2 = (LighterASTNode)children2.get(childNumber);
                    if (this.skipNode(tree, parent2, element2)) continue;
                    continue block0;
                }
                element2 = null;
            }
        }
    }

    private static StubElement<?> createStub(LighterAST tree, LighterASTNode element2, StubElement<?> parentStub) {
        IElementType elementType = element2.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element2, parentStub)) {
                    return lightElementType.createStub(tree, element2, parentStub);
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + ObjectUtils.objectInfo(elementType) + ", " + element2);
            }
        }
        return parentStub;
    }

    private boolean skipNode(LighterAST tree, LighterASTNode parent2, LighterASTNode node) {
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent2), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent2, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        if (parent2 == null) {
            LightStubBuilder.$$$reportNull$$$0(6);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(8);
        }
        if (parent2 == null) {
            LightStubBuilder.$$$reportNull$$$0(9);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/stubs/LightStubBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStubTree";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createStubForFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

