/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import ksp.com.intellij.navigation.ItemPresentation;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.INativeFileType;
import ksp.com.intellij.openapi.fileTypes.UnknownFileType;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.project.IndexNotReadyException;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Iconable;
import ksp.com.intellij.openapi.util.LastComputedIconCache;
import ksp.com.intellij.openapi.util.NotNullLazyValue;
import ksp.com.intellij.openapi.util.UserDataHolderBase;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.SmartPointerManager;
import ksp.com.intellij.psi.SmartPsiElementPointer;
import ksp.com.intellij.ui.CoreAwareIconManager;
import ksp.com.intellij.ui.IconManager;
import ksp.com.intellij.ui.PlatformIcons;
import ksp.com.intellij.ui.icons.RowIcon;
import ksp.com.intellij.util.AstLoadingFilter;
import ksp.com.intellij.util.BitUtil;
import ksp.com.intellij.util.PsiIconUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function1<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element2 = ((ElementIconRequest)request).myPointer.getElement();
        if (element2 == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element2, ((ElementIconRequest)request).myFlags);
        LastComputedIconCache.put(element2, icon, ((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = NotNullLazyValue.createValue(() -> {
        IconManager iconManager = IconManager.getInstance();
        return iconManager.createEmptyIcon(iconManager.getPlatformIcon(PlatformIcons.Public));
    });

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading", true)) {
            Icon baseIcon = LastComputedIconCache.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            if (baseIcon == null) {
                return null;
            }
            return IconManager.getInstance().createDeferredIcon(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        if (element2 == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element2, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        Icon providersIcon;
        if (element2 == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon(element2, flags)) != null) {
            if (providersIcon instanceof RowIcon) {
                return providersIcon;
            }
            return IconManager.getInstance().createLayeredIcon(element2, providersIcon, flags);
        }
        return ((ElementBase)((Object)element2)).getElementIcon(flags);
    }

    @Nullable
    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file2;
        Icon baseIcon;
        Icon icon = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (baseIcon != null && this instanceof PsiElement && (file2 = ((PsiElement)((Object)this)).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon(file2, baseIcon, flags);
        }
        return baseIcon;
    }

    @Nullable
    protected Icon getBaseIcon() {
        PsiFile file2;
        if (this instanceof PsiElement && (file2 = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file2.getFileType())) {
            try {
                return file2.getFileType().getIcon();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.NodePlaceholder);
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(@Nullable Icon icon, @Iconable.IconFlags int flags) {
        if (icon != null && BitUtil.isSet(flags, 1)) {
            return IconManager.getInstance().createRowIcon(icon, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(baseIcon, visibilityIcon);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element2 = (PsiElement)((Object)this);
        if (!element2.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element2.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element2 instanceof ItemPresentation && (baseIcon = ((ItemPresentation)((Object)element2)).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon(this, baseIcon, elementFlags);
        }
        if (element2 instanceof PsiFile) {
            Icon baseIcon2;
            PsiFile psiFile = (PsiFile)element2;
            VirtualFile vFile = psiFile.getVirtualFile();
            if (vFile == null) {
                baseIcon2 = psiFile.getFileType().getIcon();
            } else {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    baseIcon2 = ((CoreAwareIconManager)((Object)iconManager)).getIcon(vFile, flags & 0xFFFFFFFD, psiFile.getProject());
                } else {
                    return null;
                }
            }
            return IconManager.getInstance().createLayeredIcon(this, baseIcon2, elementFlags);
        }
        return null;
    }

    public static int transformFlags(PsiElement element2, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element2.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/ElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element2, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element2 == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element2);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer == request.myPointer;
        }

        public int hashCode() {
            int result2 = System.identityHashCode(this.myPointer);
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

