/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.controlFlow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.controlFlow.AbstractControlFlow;
import ksp.com.intellij.psi.controlFlow.ControlFlow;
import ksp.com.intellij.psi.controlFlow.Instruction;
import ksp.com.intellij.psi.controlFlow.ReadVariableInstruction;
import ksp.com.intellij.psi.controlFlow.WriteVariableInstruction;
import ksp.com.intellij.util.containers.Stack;
import ksp.it.unimi.dsi.fastutil.objects.Object2LongMap;
import ksp.it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import ksp.org.jetbrains.annotations.NotNull;

class ControlFlowImpl
extends AbstractControlFlow {
    private static final Logger LOG = Logger.getInstance(ControlFlowImpl.class);
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final List<PsiElement> myElementsForInstructions = new ArrayList<PsiElement>();
    private boolean myConstantConditionOccurred;
    private final Map<Instruction, Instruction> myInstructionCache = new HashMap<Instruction, Instruction>();
    private final Stack<PsiElement> myElementStack = new Stack();

    protected ControlFlowImpl() {
        super(new Object2LongOpenHashMap<PsiElement>());
    }

    void addInstruction(Instruction instruction) {
        Instruction oldInstruction;
        if ((instruction instanceof ReadVariableInstruction || instruction instanceof WriteVariableInstruction) && (oldInstruction = this.myInstructionCache.putIfAbsent(instruction, instruction)) != null) {
            instruction = oldInstruction;
        }
        this.myInstructions.add(instruction);
        this.myElementsForInstructions.add(this.myElementStack.peek());
    }

    public void startElement(PsiElement element2) {
        this.myElementStack.push(element2);
        this.myElementToOffsetMap.put(element2, 0xFFFFFFFF00000000L | (long)this.myInstructions.size());
        assert (this.getStartOffset(element2) == this.myInstructions.size());
    }

    void finishElement(PsiElement element2) {
        PsiElement popped = this.myElementStack.pop();
        LOG.assertTrue(popped.equals(element2));
        this.myElementToOffsetMap.computeLong(element2, (e, old) -> {
            long endOffset = (long)this.myInstructions.size() << 32;
            return endOffset | (old == null ? 0xFFFFFFFFL : old & 0xFFFFFFFFL);
        });
        assert (this.getEndOffset(element2) == this.myInstructions.size());
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        List<Instruction> list = this.myInstructions;
        if (list == null) {
            ControlFlowImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.myInstructions.size();
    }

    ControlFlow immutableCopy() {
        return new ImmutableControlFlow(this.myInstructions.toArray(new Instruction[0]), new Object2LongOpenHashMap(this.myElementToOffsetMap), this.myElementsForInstructions.toArray(PsiElement.EMPTY_ARRAY), this.myConstantConditionOccurred);
    }

    @Override
    public PsiElement getElement(int offset) {
        return this.myElementsForInstructions.get(offset);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myConstantConditionOccurred;
    }

    void setConstantConditionOccurred(boolean constantConditionOccurred) {
        this.myConstantConditionOccurred = constantConditionOccurred;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/psi/controlFlow/ControlFlowImpl", "getInstructions"));
    }

    private static final class ImmutableControlFlow
    extends AbstractControlFlow {
        @NotNull
        private final List<Instruction> myInstructions;
        @NotNull
        private final @NotNull PsiElement @NotNull [] myElementsForInstructions;
        private final boolean myConstantConditionOccurred;

        private ImmutableControlFlow(@NotNull @NotNull Instruction @NotNull [] instructions, @NotNull Object2LongMap<PsiElement> myElementToOffsetMap, @NotNull @NotNull PsiElement @NotNull [] elementsForInstructions, boolean occurred) {
            if (myElementToOffsetMap == null) {
                ImmutableControlFlow.$$$reportNull$$$0(0);
            }
            if (instructions == null) {
                ImmutableControlFlow.$$$reportNull$$$0(1);
            }
            if (elementsForInstructions == null) {
                ImmutableControlFlow.$$$reportNull$$$0(2);
            }
            super(myElementToOffsetMap);
            this.myInstructions = Arrays.asList(instructions);
            this.myElementsForInstructions = elementsForInstructions;
            this.myConstantConditionOccurred = occurred;
        }

        @Override
        @NotNull
        public List<Instruction> getInstructions() {
            List<Instruction> list = this.myInstructions;
            if (list == null) {
                ImmutableControlFlow.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public int getSize() {
            return this.myInstructions.size();
        }

        @Override
        public PsiElement getElement(int offset) {
            return this.myElementsForInstructions[offset];
        }

        @Override
        public boolean isConstantConditionOccurred() {
            return this.myConstantConditionOccurred;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myElementToOffsetMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsForInstructions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/controlFlow/ControlFlowImpl$ImmutableControlFlow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/controlFlow/ControlFlowImpl$ImmutableControlFlow";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstructions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

