/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.roots.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.roots.PackageDirectoryCache;
import ksp.com.intellij.openapi.util.NotNullLazyValue;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.MultiMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class PackageDirectoryCacheImpl
implements PackageDirectoryCache {
    @NotNull
    private final @NotNull BiConsumer<? super @NotNull String, ? super @NotNull List<? super VirtualFile>> myFillDirectoriesByPackage;
    @NotNull
    private final @NotNull BiPredicate<? super @NotNull VirtualFile, ? super @NotNull String> myPackageDirectoryFilter;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCacheImpl(@NotNull @NotNull BiConsumer<? super @NotNull String, ? super @NotNull List<? super VirtualFile>> fillDirectoriesByPackage, @NotNull @NotNull BiPredicate<? super @NotNull VirtualFile, ? super @NotNull String> packageDirectoryFilter) {
        if (fillDirectoriesByPackage == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(0);
        }
        if (packageDirectoryFilter == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(1);
        }
        this.myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
        this.myNonExistentPackages = ContainerUtil.newConcurrentSet();
        this.myFillDirectoriesByPackage = fillDirectoriesByPackage;
        this.myPackageDirectoryFilter = packageDirectoryFilter;
    }

    public void clear() {
        this.myNonExistentPackages.clear();
        this.myDirectoriesByPackageNameCache.clear();
    }

    public static void addValidDirectories(@NotNull Collection<? extends VirtualFile> source, @NotNull List<? super VirtualFile> target) {
        if (source == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(2);
        }
        if (target == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(3);
        }
        for (VirtualFile virtualFile : source) {
            if (!virtualFile.isDirectory() || !virtualFile.isValid()) continue;
            target.add(virtualFile);
        }
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @Override
    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName2) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(4);
        }
        List<VirtualFile> list = (info = this.getPackageInfo(packageName2)) == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageDirectories);
        if (list == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName2) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(6);
        }
        if ((info = this.myDirectoriesByPackageNameCache.get(packageName2)) == null && !this.myNonExistentPackages.contains(packageName2)) {
            if (packageName2.length() > Registry.intValue("java.max.package.name.length", 100) || Strings.containsAnyChar(packageName2, ";[/")) {
                return null;
            }
            SmartList<VirtualFile> result2 = new SmartList<VirtualFile>();
            if (Strings.isNotEmpty(packageName2) && !StringUtil.startsWithChar(packageName2, '.')) {
                int i = packageName2.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName2.substring(0, i) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName2.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName2.lastIndexOf(46, i - 1);
                    ProgressManager.checkCanceled();
                }
            }
            this.myFillDirectoriesByPackage.accept(packageName2, result2);
            if (!result2.isEmpty()) {
                info = new PackageInfo(packageName2, result2);
                this.myDirectoriesByPackageNameCache.put(packageName2, info);
            } else {
                this.myNonExistentPackages.add(packageName2);
            }
        }
        return info;
    }

    @Override
    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName2, @NotNull GlobalSearchScope scope) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(8);
        }
        if ((info = this.getPackageInfo(packageName2)) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageDirectoryCacheImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        HashSet<String> result2 = new HashSet<String>();
        for (Map.Entry<String, Collection<VirtualFile>> entry : info.mySubPackages.getValue().entrySet()) {
            String shortName2 = entry.getKey();
            Collection<VirtualFile> directories2 = entry.getValue();
            if (!ContainerUtil.exists(directories2, scope::contains)) continue;
            result2.add(shortName2);
        }
        Set<String> set = Collections.unmodifiableSet(result2);
        if (set == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillDirectoriesByPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirectoryFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addValidDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages;

        PackageInfo(@NotNull String qname, List<? extends VirtualFile> packageDirectories) {
            if (qname == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (packageDirectories == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
            this.mySubPackages = NotNullLazyValue.volatileLazy(() -> {
                MultiMap<String, VirtualFile> result2 = MultiMap.createLinked();
                for (VirtualFile virtualFile : this.myPackageDirectories) {
                    ProgressManager.checkCanceled();
                    for (VirtualFile child : virtualFile.getChildren()) {
                        String packageName2;
                        String childName = child.getName();
                        String string2 = packageName2 = this.myQname.isEmpty() ? childName : this.myQname + "." + childName;
                        if (!child.isDirectory() || !PackageDirectoryCacheImpl.this.myPackageDirectoryFilter.test(child, packageName2)) continue;
                        result2.putValue(childName, child);
                    }
                }
                return result2;
            });
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName2) {
            Collection<VirtualFile> collection = this.mySubPackages.getValue().get(shortName2);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qname";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDirectories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubPackageDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

