/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.FunctionTypeKindSubstitutor;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeRigidType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import ksp.org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import ksp.org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"prepareCapturedType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentType", "context", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "getExpectedType", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "parameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "captureFromTypeParameterUpperBoundIfNeeded", "expectedType", "hasSupertypeWithGivenClassId", "", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "Lksp/org/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nArgumentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentUtils.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n669#2,11:113\n*S KotlinDebug\n*F\n+ 1 ArgumentUtils.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentUtilsKt\n*L\n94#1:113,11\n*E\n"})
public final class ArgumentUtilsKt {
    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull ConeKotlinType argumentType, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt.isRaw(argumentType)) {
            return argumentType;
        }
        ConeKotlinType coneKotlinType = (ConeKotlinType)context2.getTypeContext().captureFromExpression(TypeExpansionUtilsKt.fullyExpandedType$default(argumentType, context2.getSession(), null, 2, null));
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter2) {
        ConeKotlinType expectedType;
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        FirExpression firExpression = $this$getExpectedType;
        boolean shouldUnwrapVarargType = firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression ? false : parameter2.isVararg();
        ConeKotlinType coneKotlinType = expectedType = shouldUnwrapVarargType ? ArrayUtilsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
        if (!FirFunctionTypeKindServiceKt.getFunctionTypeService(session).hasExtensionKinds()) {
            return expectedType;
        }
        return new FunctionTypeKindSubstitutor(session).substituteOrSelf(expectedType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Object v2;
        ConeInferenceContext context2;
        block8: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.upperBoundIfFlexible(expectedType));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType = coneRigidType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneRigidType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            context2 = TypeComponentsKt.getTypeContext(session);
            Iterable iterable = TypeUtilsKt.collectUpperBounds(simplifiedArgumentType);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv;
                boolean bl = false;
                if (!ArgumentUtilsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v2 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeClassLikeType coneClassLikeType = v2;
        if (coneClassLikeType == null) {
            return argumentType;
        }
        ConeClassLikeType chosenSupertype = coneClassLikeType;
        ConeKotlinType coneKotlinType2 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType2 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType2;
        if (argumentType instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, TypeComponentsKt.getTypeContext(session), false, 4, null);
            coneKotlinType = coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : capturedType;
        } else {
            coneKotlinType = capturedType;
        }
        return coneKotlinType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context2) {
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u242 = context2;
        boolean bl = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u242.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super SimpleTypeMarker, Boolean>)((Function1)arg_0 -> ArgumentUtilsKt.hasSupertypeWithGivenClassId$lambda$2$lambda$1($this$hasSupertypeWithGivenClassId_u24lambda_u242, classId, arg_0)));
    }

    private static final boolean hasSupertypeWithGivenClassId$lambda$2$lambda$1(TypeSystemCommonSuperTypesContext $this_with, ClassId $classId, SimpleTypeMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TypeConstructorMarker typeConstructor2 = $this_with.typeConstructor(it);
        return typeConstructor2 instanceof ConeClassLikeLookupTag && Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)typeConstructor2).getClassId(), (Object)$classId);
    }
}

