/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmDefinedExternallyCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
public final class FirWasmDefinedExternallyCallChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirWasmDefinedExternallyCallChecker INSTANCE = new FirWasmDefinedExternallyCallChecker();

    private FirWasmDefinedExternallyCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        if (object == null || (object = FirReferenceUtilsKt.toResolvedCallableSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object symbol = object;
        if (!Intrinsics.areEqual((Object)((FirCallableSymbol)symbol).getCallableId(), (Object)WebCommonStandardClassIds.Callables.JsDefinedExternally)) {
            return;
        }
        Object object2 = FirHelpersKt.getClosestNonLocal(context2);
        if (object2 == null || (object2 = ((FirDeclaration)object2).getSymbol()) == null) {
            return;
        }
        Object container = object2;
        if (!FirWebCommonHelpersKt.isEffectivelyExternal(container, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirWasmErrors.INSTANCE.getCALL_TO_DEFINED_EXTERNALLY_FROM_NON_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

